/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class TestPlatformProject {
    private final IProject project;
    public static final String CR = System.getProperty("line.separator");

    public static TestPlatformProject buildPlatformProject(String baseProjectName, boolean autoBuild) throws CoreException {
        return new TestPlatformProject(baseProjectName, autoBuild);
    }

    public TestPlatformProject(String projectName, boolean autoBuild) throws CoreException {
        this.setAutoBuild(autoBuild);
        this.project = this.buildPlatformProject(projectName);
    }

    private void setAutoBuild(boolean autoBuild) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(autoBuild);
        ResourcesPlugin.getWorkspace().setDescription(description);
    }

    private IProject buildPlatformProject(String projectName) throws CoreException {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        p.create(null);
        p.open(null);
        return p;
    }

    public IProject getProject() {
        return this.project;
    }

    public void addProjectNature(String natureID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds((String[])CollectionTools.add((Object[])description.getNatureIds(), (Object)natureID));
        this.project.setDescription(description, null);
    }

    public void removeProjectNature(String natureID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds((String[])CollectionTools.removeAllOccurrences((Object[])description.getNatureIds(), (Object)natureID));
        this.project.setDescription(description, null);
    }
}

