/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.JptEclipseLinkCoreContextModelTests;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.JptEclipselinkCoreResourceModelTests;

public class JptEclipseLinkCoreTests {
    private static final String JPA_JAR_PROPERTY = "org.eclipse.jpt.jpa.jar";
    private static final String ECLIPSELINK_JAR_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static Test suite() {
        TestSuite suite = new TestSuite(JptEclipseLinkCoreTests.class.getPackage().getName());
        if (JptEclipseLinkCoreTests.requiredJarsExists()) {
            suite.addTest(JptEclipselinkCoreResourceModelTests.suite());
            suite.addTest(JptEclipseLinkCoreContextModelTests.suite());
        } else {
            suite.addTest(TestSuite.warning((String)JptEclipseLinkCoreTests.buildMissingJarErrorMessage()));
        }
        return suite;
    }

    public static boolean requiredJarsExists() {
        return JptEclipseLinkCoreTests.jpaJarPropertyExists() && JptEclipseLinkCoreTests.jpaJarFileExists() && JptEclipseLinkCoreTests.eclipselinkJarPropertyExists() && JptEclipseLinkCoreTests.eclipselinkJarFileExists();
    }

    public static boolean jpaJarPropertyExists() {
        return JptEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY) != null;
    }

    public static boolean jpaJarFileExists() {
        return new File(JptEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY)).exists();
    }

    public static boolean eclipselinkJarPropertyExists() {
        return JptEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY) != null;
    }

    public static boolean eclipselinkJarFileExists() {
        return new File(JptEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY)).exists();
    }

    private static String buildMissingJarErrorMessage() {
        if (!JptEclipseLinkCoreTests.jpaJarPropertyExists()) {
            return JptEclipseLinkCoreTests.errorMissingProperty(JPA_JAR_PROPERTY);
        }
        if (!JptEclipseLinkCoreTests.jpaJarFileExists()) {
            return JptEclipseLinkCoreTests.errorJarFileDoesNotExist(JptEclipseLinkCoreTests.getSystemProperty(JPA_JAR_PROPERTY));
        }
        if (!JptEclipseLinkCoreTests.eclipselinkJarPropertyExists()) {
            return JptEclipseLinkCoreTests.errorMissingProperty(ECLIPSELINK_JAR_PROPERTY);
        }
        return JptEclipseLinkCoreTests.errorJarFileDoesNotExist(JptEclipseLinkCoreTests.getSystemProperty(ECLIPSELINK_JAR_PROPERTY));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private JptEclipseLinkCoreTests() {
        throw new UnsupportedOperationException();
    }
}

