/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @Converter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @Converter(converterClass=Foo.class");
            }
        });
    }

    public EclipseLinkJavaConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConverterAnnotation converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConverterAnnotation converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        converterAnnotation.setName("bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"bar", (String)converter.getName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setName("FOO");
        EclipseLinkJavaConverterTests.assertEquals((String)"FOO", (String)eclipseLinkConvert.getConverter().getName());
    }

    public void testGetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConverterAnnotation converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverterClass());
        converter.setConverterClass(null);
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converter.getConverterClass());
        converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (String)converterAnnotation.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverterClass());
    }

    public void testGetConverterClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        CustomConverter converter = (CustomConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConverterAnnotation converterAnnotation = (ConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        converterAnnotation.setConverterClass("Bar");
        EclipseLinkJavaConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Converter");
        EclipseLinkJavaConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setConverterClass("FooBar");
        EclipseLinkJavaConverterTests.assertEquals((String)"FooBar", (String)((CustomConverter)eclipseLinkConvert.getConverter()).getConverterClass());
    }
}

