/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.ExistenceCheckingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ExistenceType;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ExistenceCheckingTests
extends EclipseLinkJavaResourceModelTestCase {
    public ExistenceCheckingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestExistenceChecking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ExistenceChecking", "org.eclipse.persistence.annotations.ExistenceType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ExistenceChecking");
            }
        });
    }

    private ICompilationUnit createTestExistenceCheckingWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ExistenceChecking", "org.eclipse.persistence.annotations.ExistenceType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ExistenceChecking(ExistenceType.ASSUME_EXISTENCE)");
            }
        });
    }

    public void testExistenceChecking() throws Exception {
        ICompilationUnit cu = this.createTestExistenceChecking();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ExistenceCheckingAnnotation existenceChecking = (ExistenceCheckingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        ExistenceCheckingTests.assertNotNull((Object)existenceChecking);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestExistenceCheckingWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ExistenceCheckingAnnotation existenceChecking = (ExistenceCheckingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        ExistenceCheckingTests.assertEquals((Object)ExistenceType.ASSUME_EXISTENCE, (Object)existenceChecking.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestExistenceCheckingWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ExistenceCheckingAnnotation existenceChecking = (ExistenceCheckingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        ExistenceCheckingTests.assertEquals((Object)ExistenceType.ASSUME_EXISTENCE, (Object)existenceChecking.getValue());
        existenceChecking.setValue(ExistenceType.ASSUME_NON_EXISTENCE);
        ExistenceCheckingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)existenceChecking.getValue());
        this.assertSourceContains("@ExistenceChecking(ASSUME_NON_EXISTENCE)", cu);
        existenceChecking.setValue(null);
        ExistenceCheckingTests.assertNull((Object)existenceChecking.getValue());
        this.assertSourceDoesNotContain("(ASSUME_NON_EXISTENCE)", cu);
        this.assertSourceContains("@ExistenceChecking", cu);
        this.assertSourceDoesNotContain("@ExistenceChecking(", cu);
    }
}

