/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.ui.internal.validation.Messages;
import org.eclipse.jst.jsf.ui.internal.validation.MyLocalizedMessage;
import org.eclipse.jst.jsf.ui.internal.validation.SeverityOverrideStrategy;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.JSFTypeComparatorPreferences;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.wst.validation.internal.core.Message;

public final class ValidationMessageFactory {
    private final Map<String, SeverityOverrideStrategy> _strategies = new HashMap<String, SeverityOverrideStrategy>();

    public ValidationMessageFactory(ValidationPreferences prefs) {
        this._strategies.put("org.eclipse.jst.jsf.validation.el.Diagnostics", new ELSeverityOverrideStrategy(prefs));
        this._strategies.put("org.eclipse.jst.jsf.common.types.TypeComparator", new TypeComparatorOverrideStrategy(prefs));
    }

    public Message createFromDiagnostic(Diagnostic diagnostic, int offset, int length, IFile file) {
        Integer value;
        int severity = diagnostic.getSeverity();
        String sourceId = diagnostic.getSource();
        SeverityOverrideStrategy strategy = this._strategies.get(sourceId);
        if (strategy != null && (value = strategy.override(diagnostic)) != null) {
            severity = value;
        }
        MyLocalizedMessage message = new MyLocalizedMessage(this.convertSeverity(severity), diagnostic.getMessage(), (IResource)file, diagnostic.getCode());
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    private int convertSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 0;
    }

    private static class ELSeverityOverrideStrategy
    extends SeverityOverrideStrategy {
        private final ValidationPreferences _prefs;

        public ELSeverityOverrideStrategy(ValidationPreferences prefs) {
            super("org.eclipse.jst.jsf.validation.el.Diagnostics");
            this._prefs = prefs;
        }

        public Integer override(Diagnostic diagnostic) {
            int code = diagnostic.getCode();
            ELValidationPreferences elPrefs = this._prefs.getElPrefs();
            return elPrefs.getDiagnosticSeverity(code);
        }

        public String getDisplayName() {
            return Messages.ValidationMessageFactory_DefaultElSeverityDisplayName;
        }
    }

    private static class TypeComparatorOverrideStrategy
    extends SeverityOverrideStrategy {
        private final ValidationPreferences _prefs;

        public TypeComparatorOverrideStrategy(ValidationPreferences prefs) {
            super("org.eclipse.jst.jsf.common.types.TypeComparator");
            this._prefs = prefs;
        }

        public Integer override(Diagnostic diagnostic) {
            int code = diagnostic.getCode();
            JSFTypeComparatorPreferences jsfTypeCompPrefs = this._prefs.getTypeComparatorPrefs();
            return jsfTypeCompPrefs.getDiagnosticSeverity(code);
        }

        public String getDisplayName() {
            return Messages.ValidationMessageFactory_DefaultTypeComparatorDisplayName;
        }
    }
}

