/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EjbAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotationReader
extends AbstractAnnotationModelProvider<EJBJar>
implements IElementChangedListener {
    private IProject clientProject;
    public Map<ICompilationUnit, JavaEEObject> unitToModel;
    private ManyToOneRelation<BeanInterfaceRef, ICompilationUnit> beanRefToResolvedInterfaceUnit;
    private EjbAnnotationFactory annotationFactory;

    public EJBAnnotationReader(IFacetedProject project, IProject clientProject) {
        super(project);
        this.clientProject = clientProject;
    }

    public void loadModel() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.facetedProject.getProject());
        HashSet javaFiles = new HashSet();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            this.visitJavaFiles(javaFiles, root);
            ++n2;
        }
        if (this.clientProject != null) {
            IJavaProject clientProjectJavaView = JavaCore.create((IProject)this.facetedProject.getProject());
            IPackageFragmentRoot[] iPackageFragmentRootArray2 = clientProjectJavaView.getAllPackageFragmentRoots();
            int n3 = iPackageFragmentRootArray2.length;
            n = 0;
            while (n < n3) {
                IPackageFragmentRoot root = iPackageFragmentRootArray2[n];
                this.visitJavaFiles(javaFiles, root);
                ++n;
            }
        }
        this.unitToModel = new HashMap<ICompilationUnit, JavaEEObject>();
        this.beanRefToResolvedInterfaceUnit = new ManyToOneRelation();
        for (ICompilationUnit unit : javaFiles) {
            Result result = this.analyzeUnitForBean(unit);
            if (result == null) continue;
            this.processResult(unit, result);
        }
    }

    protected void preLoad() {
        super.preLoad();
        this.modelObject = EjbFactory.eINSTANCE.createEJBJar();
        this.annotationFactory = EjbAnnotationFactory.createFactory();
    }

    private void processResult(ICompilationUnit unit, Result result) throws JavaModelException {
        JavaEEObject modelObject = result.getMainObject();
        if (SessionBean.class.isInstance(modelObject)) {
            this.sessionBeanFound(unit, (SessionBean)modelObject, result.getDependedTypes());
        } else if (MessageDrivenBean.class.isInstance(modelObject)) {
            this.messageBeanFound(unit, (MessageDrivenBean)modelObject, result.getDependedTypes());
        }
        for (JavaEEObject additional : result.getAdditional()) {
            if (!SecurityRole.class.isInstance(additional)) continue;
            this.securityRoleFound((JavaEEObject)((SessionBean)this.unitToModel.get(unit)), (SecurityRole)additional);
        }
    }

    private Result analyzeUnitForBean(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit == null) {
            return null;
        }
        IType rootType = compilationUnit.findPrimaryType();
        if (rootType == null || !rootType.isClass()) {
            return null;
        }
        return this.annotationFactory.createJavaeeObject(rootType);
    }

    private void messageBeanFound(ICompilationUnit unit, MessageDrivenBean messageBean, Collection<IType> dependedTypes) throws JavaModelException {
        if (((EJBJar)this.modelObject).getEnterpriseBeans() == null) {
            ((EJBJar)this.modelObject).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        }
        ((EJBJar)this.modelObject).getEnterpriseBeans().getMessageDrivenBeans().add(messageBean);
        this.connectBeanWithTypes(unit, (JavaEEObject)messageBean, dependedTypes);
    }

    private void sessionBeanFound(ICompilationUnit unit, SessionBean sessionBean, Collection<IType> dependedTypes) throws JavaModelException {
        if (((EJBJar)this.modelObject).getEnterpriseBeans() == null) {
            ((EJBJar)this.modelObject).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        }
        ((EJBJar)this.modelObject).getEnterpriseBeans().getSessionBeans().add(sessionBean);
        this.connectBeanWithTypes(unit, (JavaEEObject)sessionBean, dependedTypes);
    }

    private void connectBeanWithTypes(ICompilationUnit unit, JavaEEObject bean, Collection<IType> dependedTypes) throws JavaModelException {
        this.unitToModel.put(unit, bean);
        for (IType type : dependedTypes) {
            if (type.isBinary() || !type.isInterface()) continue;
            this.beanRefToResolvedInterfaceUnit.connect((Object)new BeanInterfaceRef(type.getFullyQualifiedName(), bean), (Object)type.getCompilationUnit());
        }
    }

    public void dispose() {
        this.beanRefToResolvedInterfaceUnit = null;
        if (this.unitToModel != null) {
            this.unitToModel.clear();
        }
        super.dispose();
    }

    protected boolean isProjectRelative(IJavaProject javaProject) {
        if (super.isProjectRelative(javaProject)) {
            return true;
        }
        return this.clientProject != null && javaProject.getProject().equals((Object)this.clientProject.getProject());
    }

    protected void processAddedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        if (unit == null) {
            return;
        }
        HashSet<ICompilationUnit> unitsToRebuild = new HashSet<ICompilationUnit>();
        IType rootType = unit.findPrimaryType();
        if (rootType == null) {
            return;
        }
        if (rootType.isClass()) {
            Result result = this.analyzeUnitForBean(unit);
            if (result == null || result.isEmpty()) {
                return;
            }
            this.processResult(unit, result);
            modelEvent.addResource((Object)unit);
        } else if (rootType.isInterface()) {
            unitsToRebuild.addAll(this.processAddedInterface(rootType));
        }
        if (unitsToRebuild.isEmpty()) {
            return;
        }
        for (ICompilationUnit changedUnit : unitsToRebuild) {
            this.processRemovedCompilationUnit(modelEvent, changedUnit);
            this.processAddedCompilationUnit(modelEvent, changedUnit);
        }
        unitsToRebuild.clear();
    }

    private Collection<ICompilationUnit> processAddedInterface(IType rootType) {
        HashSet<ICompilationUnit> unitsToRebuild = new HashSet<ICompilationUnit>();
        String rootTypeSimpleName = rootType.getElementName();
        if (((EJBJar)this.getConcreteModel()).getEnterpriseBeans() == null) {
            return unitsToRebuild;
        }
        for (SessionBean bean : ((EJBJar)this.getConcreteModel()).getEnterpriseBeans().getSessionBeans()) {
            for (String inter : bean.getBusinessLocals()) {
                if (!rootTypeSimpleName.equals(inter)) continue;
                unitsToRebuild.add(this.getCompilationUnitFromModel((JavaEEObject)bean));
            }
            if (rootTypeSimpleName.equals(bean.getLocalHome()) || rootTypeSimpleName.equals(bean.getHome())) {
                unitsToRebuild.add(this.getCompilationUnitFromModel((JavaEEObject)bean));
            }
            this.findDependedFiles((JavaEEObject)bean, rootTypeSimpleName, bean.getEjbLocalRefs(), bean.getResourceRefs(), unitsToRebuild);
        }
        for (SessionBean bean : ((EJBJar)this.getConcreteModel()).getEnterpriseBeans().getMessageDrivenBeans()) {
            this.findDependedFiles((JavaEEObject)bean, rootTypeSimpleName, bean.getEjbLocalRefs(), bean.getResourceRefs(), unitsToRebuild);
        }
        return unitsToRebuild;
    }

    private ICompilationUnit getCompilationUnitFromModel(JavaEEObject bean) {
        for (Map.Entry<ICompilationUnit, JavaEEObject> entry : this.unitToModel.entrySet()) {
            if (!entry.getValue().equals(bean)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void findDependedFiles(JavaEEObject bean, String rootTypeSimpleName, Collection<EjbLocalRef> ejbRefs, Collection<ResourceRef> resourceRefs, Collection<ICompilationUnit> filesToRebuild) {
        Iterator<EjbLocalRef> refsIter = ejbRefs.iterator();
        while (refsIter.hasNext()) {
            String localRefInterface = refsIter.next().getLocal();
            if (!rootTypeSimpleName.equals(localRefInterface)) continue;
            filesToRebuild.add(this.getCompilationUnitFromModel(bean));
        }
        refsIter = resourceRefs.iterator();
        while (refsIter.hasNext()) {
            String resourceRef = ((ResourceRef)refsIter.next()).getResType();
            if (!rootTypeSimpleName.equals(resourceRef)) continue;
            filesToRebuild.add(this.getCompilationUnitFromModel(bean));
        }
    }

    protected void processRemovedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        if (this.unitToModel.containsKey(unit)) {
            this.processRemoveBean(modelEvent, unit);
        } else if (this.beanRefToResolvedInterfaceUnit.containsTarget((Object)unit)) {
            this.processRemovedInterface(modelEvent, unit);
        }
    }

    private void processRemovedInterface(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        Collection refs = this.beanRefToResolvedInterfaceUnit.getSources((Object)unit);
        HashSet<ICompilationUnit> filesToRebuild = new HashSet<ICompilationUnit>();
        for (BeanInterfaceRef ref : refs) {
            filesToRebuild.add(this.getCompilationUnitFromModel(ref.getModelObject()));
        }
        if (filesToRebuild.isEmpty()) {
            return;
        }
        for (ICompilationUnit changedFile : filesToRebuild) {
            this.processRemovedCompilationUnit(modelEvent, changedFile);
            this.processAddedCompilationUnit(modelEvent, changedFile);
        }
        filesToRebuild.clear();
        this.beanRefToResolvedInterfaceUnit.disconnect((Object)unit);
    }

    private void processRemoveBean(IModelProviderEvent modelEvent, ICompilationUnit unit) throws JavaModelException {
        EObject modelObject = (EObject)this.unitToModel.get(unit);
        EcoreUtil.remove((EObject)modelObject);
        if (((EJBJar)this.getConcreteModel()).getEnterpriseBeans().getGroup().isEmpty()) {
            ((EJBJar)this.getConcreteModel()).setEnterpriseBeans(null);
        }
        this.unitToModel.remove(unit);
        modelEvent.setEventCode(modelEvent.getEventCode() | 4);
        modelEvent.addResource((Object)unit);
        this.disconnectFromRoles((JavaEEObject)modelObject);
    }

    protected void processChangedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        if (this.unitToModel.containsKey(unit)) {
            this.processChangedBean(modelEvent, unit);
        } else if (this.beanRefToResolvedInterfaceUnit.containsTarget((Object)unit)) {
            this.processChangedInterface(modelEvent, unit);
        } else {
            this.processAddedCompilationUnit(modelEvent, unit);
        }
    }

    private void processChangedBean(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        EObject oldBean = (EObject)this.unitToModel.get(unit);
        ICompilationUnit beanUnit = this.getCompilationUnitFromModel((JavaEEObject)oldBean);
        this.processRemovedCompilationUnit(modelEvent, beanUnit);
        this.processAddedCompilationUnit(modelEvent, beanUnit);
    }

    private void processChangedInterface(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        Collection references = this.beanRefToResolvedInterfaceUnit.getSources((Object)unit);
        for (BeanInterfaceRef ref : references) {
            ICompilationUnit next = this.getCompilationUnitFromModel(ref.getModelObject());
            this.processRemovedCompilationUnit(modelEvent, next);
            this.processAddedCompilationUnit(modelEvent, next);
        }
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        return null;
    }

    protected Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject target) {
        if (SessionBean.class.isInstance(target)) {
            return ((SessionBean)target).getSecurityRoleRefs();
        }
        return null;
    }

    protected Collection<SecurityRole> getSecurityRoles() {
        if (((EJBJar)this.modelObject).getAssemblyDescriptor() == null) {
            ((EJBJar)this.modelObject).setAssemblyDescriptor(EjbFactory.eINSTANCE.createAssemblyDescriptor());
        }
        return ((EJBJar)this.modelObject).getAssemblyDescriptor().getSecurityRoles();
    }

    protected void processRemovedPackage(IModelProviderEvent modelEvent, IJavaElementDelta delta) throws CoreException {
        HashSet<ICompilationUnit> keySet = new HashSet<ICompilationUnit>(this.unitToModel.keySet());
        for (ICompilationUnit unit : keySet) {
            if (!unit.getParent().getElementName().equals(delta.getElement().getElementName())) continue;
            this.processRemovedCompilationUnit(modelEvent, unit);
        }
    }

    private static class BeanInterfaceRef {
        private String interfacee;
        private JavaEEObject modelObject;

        public BeanInterfaceRef(String interfacee, JavaEEObject modelObject) {
            this.interfacee = interfacee;
            this.modelObject = modelObject;
        }

        public String getInterfacee() {
            return this.interfacee;
        }

        public JavaEEObject getModelObject() {
            return this.modelObject;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.interfacee == null ? 0 : this.interfacee.hashCode());
            result = 31 * result + (this.modelObject == null ? 0 : this.modelObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanInterfaceRef other = (BeanInterfaceRef)obj;
            if (this.interfacee == null ? other.interfacee != null : !this.interfacee.equals(other.interfacee)) {
                return false;
            }
            return !(this.modelObject == null ? other.modelObject != null : !this.modelObject.equals(other.modelObject));
        }
    }
}

