/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ImportReferencesCollector
extends GenericVisitor {
    private JavaScriptUnit fASTRoot;
    private Region fSubRange;
    private Collection fTypeImports;
    private Collection fStaticImports;

    public static void collect(ASTNode node, IJavaScriptProject project, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        JavaScriptUnit astRoot = (JavaScriptUnit)node.getRoot();
        node.accept((ASTVisitor)new ImportReferencesCollector(project, astRoot, rangeLimit, resultingTypeImports, resultingStaticImports));
    }

    private ImportReferencesCollector(IJavaScriptProject project, JavaScriptUnit astRoot, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        super(true);
        this.fTypeImports = resultingTypeImports;
        this.fStaticImports = resultingStaticImports;
        this.fSubRange = rangeLimit;
        if (project == null || !JavaModelUtil.is50OrHigher(project)) {
            this.fStaticImports = null;
        }
        this.fASTRoot = astRoot;
    }

    public ImportReferencesCollector(IJavaScriptProject project, Region rangeLimit, Collection resultingTypeImports, Collection resultingStaticImports) {
        this(project, null, rangeLimit, resultingTypeImports, resultingStaticImports);
    }

    public JavaScriptUnit getASTRoot(ASTNode node) {
        if (this.fASTRoot == null) {
            this.fASTRoot = (JavaScriptUnit)node.getRoot();
        }
        return this.fASTRoot;
    }

    private boolean isAffected(ASTNode node) {
        if (this.fSubRange == null) {
            return true;
        }
        int nodeStart = node.getStartPosition();
        int offset = this.fSubRange.getOffset();
        return nodeStart + node.getLength() > offset && offset + this.fSubRange.getLength() > nodeStart;
    }

    private void addReference(SimpleName name) {
        if (this.isAffected((ASTNode)name)) {
            this.fTypeImports.add(name);
        }
    }

    private void typeRefFound(Name node) {
        if (node != null) {
            while (node.isQualifiedName()) {
                node = ((QualifiedName)node).getQualifier();
            }
            this.addReference((SimpleName)node);
        }
    }

    private void possibleTypeRefFound(Name node) {
        while (node.isQualifiedName()) {
            node = ((QualifiedName)node).getQualifier();
        }
        IBinding binding = node.resolveBinding();
        if (binding == null || binding.getKind() == 2) {
            this.addReference((SimpleName)node);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void possibleStaticImportFound(Name name) {
        if (this.fStaticImports != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            name = ((QualifiedName)name).getQualifier();
lbl4:
            // 2 sources

            ** while (name.isQualifiedName())
        }
lbl5:
        // 1 sources

        if (!this.isAffected((ASTNode)name)) {
            return;
        }
        binding = name.resolveBinding();
        if (binding == null || binding instanceof ITypeBinding || !Modifier.isStatic((int)binding.getModifiers()) || ((SimpleName)name).isDeclaration()) {
            return;
        }
        if (binding instanceof IVariableBinding) {
            varBinding = (IVariableBinding)binding;
            if (varBinding.isField() && (declaringClass = (varBinding = varBinding.getVariableDeclaration()).getDeclaringClass()) != null && !declaringClass.isLocal()) {
                if (new ScopeAnalyzer(this.getASTRoot((ASTNode)name)).isDeclaredInScope((IBinding)varBinding, (SimpleName)name, 18)) {
                    return;
                }
                this.fStaticImports.add(name);
            }
        } else if (binding instanceof IFunctionBinding && (declaringClass = (methodBinding = ((IFunctionBinding)binding).getMethodDeclaration()).getDeclaringClass()) != null && !declaringClass.isLocal()) {
            if (new ScopeAnalyzer(this.getASTRoot((ASTNode)name)).isDeclaredInScope((IBinding)methodBinding, (SimpleName)name, 17)) {
                return;
            }
            this.fStaticImports.add(name);
        }
    }

    private void doVisitChildren(List elements) {
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            ((ASTNode)elements.get(i)).accept((ASTVisitor)this);
            ++i;
        }
    }

    private void doVisitNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    protected boolean visitNode(ASTNode node) {
        return this.isAffected(node);
    }

    public boolean visit(ArrayType node) {
        this.doVisitNode((ASTNode)node.getElementType());
        return false;
    }

    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        return false;
    }

    public boolean visit(QualifiedType node) {
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.possibleTypeRefFound((Name)node);
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitChildren(node.annotations());
        }
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.typeRefFound(node.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expr, Name selector) {
        if (expr != null) {
            if (expr instanceof Name) {
                Name name = (Name)expr;
                this.possibleTypeRefFound(name);
                this.possibleStaticImportFound(name);
            } else {
                expr.accept((ASTVisitor)this);
            }
        } else if (selector != null) {
            this.possibleStaticImportFound(selector);
        }
    }

    public boolean visit(ClassInstanceCreation node) {
        this.doVisitChildren(node.typeArguments());
        this.doVisitNode((ASTNode)node.getType());
        this.evalQualifyingExpression(node.getExpression(), null);
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(FunctionInvocation node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.evalQualifyingExpression(node.getExpression(), null);
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        return false;
    }

    public boolean visit(SimpleName node) {
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return this.isAffected((ASTNode)node);
    }

    public boolean visit(FunctionDeclaration node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.doVisitNode((ASTNode)node.getJavadoc());
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitChildren(node.modifiers());
            this.doVisitChildren(node.typeParameters());
        }
        if (!node.isConstructor()) {
            this.doVisitNode((ASTNode)node.getReturnType2());
        }
        this.doVisitChildren(node.parameters());
        Iterator iter = node.thrownExceptions().iterator();
        while (iter.hasNext()) {
            this.typeRefFound((Name)iter.next());
        }
        this.doVisitNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(TagElement node) {
        Object first;
        String tagName = node.getTagName();
        List list = node.fragments();
        int idx = 0;
        if (tagName != null && !list.isEmpty() && (first = list.get(0)) instanceof Name) {
            if ("@throws".equals(tagName) || "@exception".equals(tagName)) {
                this.typeRefFound((Name)first);
            } else if ("@see".equals(tagName) || "@link".equals(tagName) || "@linkplain".equals(tagName)) {
                Name name = (Name)first;
                this.possibleTypeRefFound(name);
            }
            ++idx;
        }
        int i = idx;
        while (i < list.size()) {
            this.doVisitNode((ASTNode)list.get(i));
            ++i;
        }
        return false;
    }

    public boolean visit(MemberRef node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        return false;
    }

    public boolean visit(FunctionRef node) {
        List list;
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        if ((list = node.parameters()) != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

