/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.wst.xsl.internal.launching.Messages;

public class XSLLineBreakpoint
extends LineBreakpoint {
    private int lineNumber;

    public XSLLineBreakpoint() {
    }

    public XSLLineBreakpoint(final IResource resource, final int lineNumber, final int charStart, final int charEnd) throws CoreException {
        this.lineNumber = lineNumber;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.wst.xsl.launching.xslLineBreakpointMarker");
                XSLLineBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)XSLLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("message", (Object)(String.valueOf(Messages.XSLLineBreakpoint_0) + resource.getName() + " [line: " + lineNumber + "]"));
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("charStart", (Object)new Integer(charStart));
                marker.setAttribute("charEnd", (Object)new Integer(charEnd));
                XSLLineBreakpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public int getLineNumber() throws CoreException {
        int line = super.getLineNumber();
        return line == -1 ? this.lineNumber : line;
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getModelIdentifier() {
        return "org.eclipse.wst.xsl.launching.XSLDebugModel";
    }
}

