/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.util.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresetsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "presets";
    private static final String OLD_EXTENSION_POINT_ID = "facets";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_DYNAMIC_PRESET = "dynamic-preset";
    private static final String EL_FACET = "facet";
    private static final String EL_FACTORY = "factory";
    private static final String EL_LABEL = "label";
    private static final String EL_PRESET = "preset";
    private static final String EL_STATIC_PRESET = "static-preset";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_EXTENDS = "extends";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private static final String DEFAULT_DESCRIPTION = "";
    private static IndexedSet<String, IPreset> presets = null;

    public static Set<IPreset> getPresets() {
        PresetsExtensionPoint.readExtensions();
        return presets.getUnmodifiable();
    }

    public static IPreset getPreset(String id) {
        PresetsExtensionPoint.readExtensions();
        return presets.get(id);
    }

    private static synchronized void readExtensions() {
        if (presets != null) {
            return;
        }
        presets = new IndexedSet();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            String elName = element.getName();
            if (elName.equals(EL_STATIC_PRESET)) {
                try {
                    PresetsExtensionPoint.readStaticPreset(element);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
                continue;
            }
            if (!elName.equals(EL_DYNAMIC_PRESET)) continue;
            try {
                PresetsExtensionPoint.readDynamicPreset(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", OLD_EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_PRESET)) continue;
            try {
                PresetsExtensionPoint.readStaticPreset(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        HashSet copy = new HashSet(presets);
        for (IPreset preset : copy) {
            if (!presets.contains(preset)) continue;
            PresetsExtensionPoint.resolveBasePreset(preset, new HashSet<IPreset>());
        }
        boolean doAnotherPass = true;
        block9: while (doAnotherPass) {
            doAnotherPass = false;
            for (IPreset preset : presets) {
                IPreset basePreset;
                StaticPreset stPreset;
                String basePresetId;
                if (preset.getType() != IPreset.Type.STATIC || (basePresetId = (stPreset = (StaticPreset)preset).getBasePresetId()) == null || (basePreset = PresetsExtensionPoint.getPreset(basePresetId)).getType() != IPreset.Type.DYNAMIC) continue;
                StaticExtendingDynamicPreset stPresetNew = new StaticExtendingDynamicPreset(stPreset.getId(), stPreset.getPluginId(), stPreset.getLabel(), stPreset.getDescription(), stPreset.getBasePresetId(), stPreset.getProjectFacets());
                presets.add(stPresetNew.getId(), stPresetNew);
                doAnotherPass = true;
                continue block9;
            }
        }
    }

    private static void readStaticPreset(IConfigurationElement el) throws PluginUtil.InvalidExtensionException {
        String pluginId = el.getContributor().getName();
        String id = PluginUtil.findRequiredAttribute(el, ATTR_ID);
        IConfigurationElement elLabel = PluginUtil.findOptionalElement(el, EL_LABEL);
        String label = PluginUtil.getElementValue(elLabel, id);
        IConfigurationElement elDesc = PluginUtil.findOptionalElement(el, EL_DESCRIPTION);
        String description = PluginUtil.getElementValue(elDesc, DEFAULT_DESCRIPTION);
        String basePreset = el.getAttribute(ATTR_EXTENDS);
        if (basePreset != null && (basePreset = basePreset.trim()).length() == 0) {
            basePreset = null;
        }
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String childName = child.getName();
            if (childName.equals(EL_FACET)) {
                String fid = PluginUtil.findRequiredAttribute(child, ATTR_ID);
                String fver = PluginUtil.findRequiredAttribute(child, ATTR_VERSION);
                if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                    String msg = Resources.bind(Resources.presetUsesUnknownFacet, id, pluginId, fid);
                    FacetCorePlugin.logError(msg);
                    return;
                }
                IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                if (!f.hasVersion(fver)) {
                    String msg = Resources.bind(Resources.presetUsesUnknownFacetVersion, id, pluginId, fid, fver);
                    FacetCorePlugin.logError(msg);
                    return;
                }
                IProjectFacetVersion fv = f.getVersion(fver);
                facets.add(fv);
            }
            ++n2;
        }
        StaticPreset preset = new StaticPreset(id, pluginId, label, description, basePreset, facets);
        presets.add(id, preset);
    }

    private static void readDynamicPreset(IConfigurationElement el) throws PluginUtil.InvalidExtensionException {
        String pluginId = el.getContributor().getName();
        String id = PluginUtil.findRequiredAttribute(el, ATTR_ID);
        IConfigurationElement elFactory = PluginUtil.findRequiredElement(el, EL_FACTORY);
        String factoryClassName = PluginUtil.findRequiredAttribute(elFactory, ATTR_CLASS);
        DynamicPreset preset = new DynamicPreset(id, pluginId, factoryClassName);
        presets.add(id, preset);
    }

    private static boolean resolveBasePreset(IPreset preset, Set<IPreset> visitedPresets) {
        StaticPreset stPreset;
        String basePresetId;
        if (preset.getType() == IPreset.Type.STATIC && (basePresetId = (stPreset = (StaticPreset)preset).getBasePresetId()) != null) {
            IPreset basePreset = PresetsExtensionPoint.getPreset(basePresetId);
            boolean problem = false;
            visitedPresets.add(preset);
            if (basePreset == null) {
                String msg = Resources.bind(Resources.basePresetNotFound, stPreset.getId(), stPreset.getPluginId(), basePresetId);
                FacetCorePlugin.logError(msg);
                problem = true;
            } else if (visitedPresets.contains(basePreset)) {
                StringBuilder cycle = new StringBuilder();
                int cycleSize = visitedPresets.size();
                int count = 0;
                for (IPreset vp : visitedPresets) {
                    if (++count > 1) {
                        if (count == cycleSize) {
                            cycle.append(" and ");
                        } else {
                            cycle.append(", ");
                        }
                    }
                    cycle.append('\"');
                    cycle.append(vp.getId());
                    cycle.append('\"');
                }
                String msg = Resources.bind((String)Resources.cycleDetected, (Object)cycle.toString());
                FacetCorePlugin.logError(msg);
                problem = true;
            } else if (!PresetsExtensionPoint.resolveBasePreset(basePreset, visitedPresets)) {
                problem = true;
            }
            if (problem) {
                presets.delete(preset.getId());
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DynamicPreset
    implements IDynamicPreset {
        private final String id;
        private final String pluginId;
        private final String factoryClassName;

        public DynamicPreset(String id, String pluginId, String factoryClassName) {
            this.id = id;
            this.pluginId = pluginId;
            this.factoryClassName = factoryClassName;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public IPreset.Type getType() {
            return IPreset.Type.DYNAMIC;
        }

        @Override
        public String getLabel() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return PresetsExtensionPoint.DEFAULT_DESCRIPTION;
        }

        @Override
        public Set<IProjectFacetVersion> getProjectFacets() {
            return Collections.emptySet();
        }

        @Override
        public boolean isUserDefined() {
            return false;
        }

        @Override
        public IPreset resolve(Map<String, Object> context) {
            IPresetFactory factory = PluginUtil.instantiate(this.pluginId, this.factoryClassName, IPresetFactory.class);
            if (factory != null) {
                PresetDefinition def = null;
                try {
                    def = factory.createPreset(this.id, context);
                }
                catch (Exception e) {
                    String msg = Resources.bind((String)Resources.failedWhileInvokingPresetFactory, (Object)this.pluginId);
                    FacetCorePlugin.log(FacetCorePlugin.createErrorStatus(msg, e));
                }
                if (def != null) {
                    StaticPreset staticPreset = new StaticPreset(this.id, this.pluginId, def.getLabel(), def.getDescription(), null, def.getProjectFacets());
                    return staticPreset;
                }
            }
            return null;
        }

        public String toString() {
            return this.id;
        }
    }

    private static final class Resources
    extends NLS {
        public static String presetUsesUnknownFacet;
        public static String presetUsesUnknownFacetVersion;
        public static String basePresetNotFound;
        public static String cycleDetected;
        public static String failedWhileInvokingPresetFactory;

        static {
            Resources.initializeMessages((String)PresetsExtensionPoint.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StaticExtendingDynamicPreset
    extends StaticPreset
    implements IDynamicPreset {
        public StaticExtendingDynamicPreset(String id, String pluginId, String label, String description, String basePresetId, Set<IProjectFacetVersion> facets) {
            super(id, pluginId, label, description, basePresetId, facets);
        }

        @Override
        public IPreset.Type getType() {
            return IPreset.Type.DYNAMIC;
        }

        @Override
        public Set<IProjectFacetVersion> getProjectFacets() {
            return Collections.emptySet();
        }

        @Override
        public IPreset resolve(Map<String, Object> context) {
            IDynamicPreset basePreset = (IDynamicPreset)PresetsExtensionPoint.getPreset(this.getBasePresetId());
            IPreset resBasePreset = basePreset.resolve(context);
            if (resBasePreset == null) {
                return null;
            }
            Set<IProjectFacetVersion> facets = this.createCombinedFacetSet(resBasePreset);
            return new StaticPreset(this.getId(), this.getPluginId(), this.getLabel(), this.getDescription(), this.getBasePresetId(), facets);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StaticPreset
    implements IPreset {
        private final String id;
        private final String pluginId;
        private final String label;
        private final String description;
        private final String basePresetId;
        private final Set<IProjectFacet> facets;
        private final Set<IProjectFacetVersion> facetVersions;
        private final Set<IProjectFacetVersion> facetVersionsReadOnly;

        public StaticPreset(String id, String pluginId, String label, String description, String basePreset, Set<IProjectFacetVersion> facets) {
            this.id = id;
            this.pluginId = pluginId;
            this.label = label;
            this.description = description;
            this.basePresetId = basePreset;
            this.facetVersions = facets;
            this.facetVersionsReadOnly = Collections.unmodifiableSet(this.facetVersions);
            this.facets = new HashSet<IProjectFacet>(this.facetVersions.size());
            for (IProjectFacetVersion fv : this.facetVersions) {
                this.facets.add(fv.getProjectFacet());
            }
        }

        @Override
        public final String getId() {
            return this.id;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        @Override
        public IPreset.Type getType() {
            return IPreset.Type.STATIC;
        }

        @Override
        public final String getLabel() {
            return this.label;
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        public final String getBasePresetId() {
            return this.basePresetId;
        }

        @Override
        public Set<IProjectFacetVersion> getProjectFacets() {
            if (this.basePresetId == null) {
                return this.facetVersionsReadOnly;
            }
            IPreset basePreset = PresetsExtensionPoint.getPreset(this.basePresetId);
            return this.createCombinedFacetSet(basePreset);
        }

        @Override
        public final boolean isUserDefined() {
            return false;
        }

        public final String toString() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StaticPreset)) {
                return false;
            }
            StaticPreset p = (StaticPreset)obj;
            return this.id.equals(p.id) && this.pluginId.equals(p.pluginId) && this.label.equals(p.label) && this.description.equals(p.description) && this.facetVersions.equals(p.facetVersions);
        }

        protected final Set<IProjectFacetVersion> createCombinedFacetSet(IPreset basePreset) {
            HashSet<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>(this.facetVersions);
            for (IProjectFacetVersion fv : basePreset.getProjectFacets()) {
                if (this.facets.contains(fv.getProjectFacet())) continue;
                result.add(fv);
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

