/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.ui.internal.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateNameAttributeContentAssist
extends AbstractXSLContentAssistRequest {
    private static final String ATTR_NAME = "name";

    public TemplateNameAttributeContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        this.proposals.clear();
        StylesheetModel model = this.getStylesheetModel();
        List templates = model.getCallTemplates();
        for (CallTemplate template : templates) {
            CustomCompletionProposal proposal = this.createProposal(template);
            this.addUniqueProposal(proposal);
        }
        return this.getAllCompletionProposals();
    }

    private void addUniqueProposal(CustomCompletionProposal proposal) {
        if (this.proposals.lastIndexOf(proposal) == -1) {
            if (this.matchString.length() > 0) {
                if (proposal.getDisplayString().startsWith(this.matchString)) {
                    this.addProposal((ICompletionProposal)proposal);
                }
            } else {
                this.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    private CustomCompletionProposal createProposal(CallTemplate template) {
        CustomCompletionProposal proposal = new CustomCompletionProposal(template.getAttributeValue(ATTR_NAME), this.getStartOffset() + 1, 0, template.getAttributeValue(ATTR_NAME).length(), XSLPluginImageHelper.getInstance().getImage("icons/full/template.gif"), template.getAttributeValue(ATTR_NAME), null, null, 0);
        return proposal;
    }
}

