/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.wizards.NewXSLFileTemplatesWizardPage;
import org.eclipse.wst.xsl.ui.internal.wizards.NewXSLFileWizardPage;

public class NewXSLFileWizard
extends Wizard
implements INewWizard {
    private NewXSLFileWizardPage fNewFilePage;
    private NewXSLFileTemplatesWizardPage fNewFileTemplatesPage;
    private IStructuredSelection fSelection;
    private IWorkbench workbench;

    public void addPages() {
        StructuredSelection ssel = new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection));
        this.fNewFilePage = new NewXSLFileWizardPage("NewFileCreationPage", (IStructuredSelection)ssel);
        this.fNewFilePage.setTitle(Messages.NewXSLFilePageTitle);
        this.fNewFilePage.setDescription(Messages.NewXSLFilePageDescription);
        this.addPage((IWizardPage)this.fNewFilePage);
        this.fNewFileTemplatesPage = new NewXSLFileTemplatesWizardPage();
        this.addPage((IWizardPage)this.fNewFileTemplatesPage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.workbench = aWorkbench;
        this.fSelection = aSelection;
        this.setWindowTitle(Messages.NewXSLFilePageWindowTitle);
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        this.fNewFileTemplatesPage.saveLastSavedPreferences();
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.fNewFilePage.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            String templateString = this.fNewFileTemplatesPage.getTemplateString();
            if (templateString != null) {
                Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
                String charSet = preference.getString("outputCodeset");
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                    outputStreamWriter.write(templateString);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    file.setContents((InputStream)inputStream, true, false, null);
                    inputStream.close();
                }
                catch (Exception e) {
                    XSLUIPlugin.log(e);
                }
            }
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        XSLUIPlugin.log((CoreException)((Object)e));
                    }
                }
            });
        }
    }
}

