/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class FileBufferModelManager {
    private static FileBufferModelManager instance = new FileBufferModelManager();
    Map fDocumentMap = null;
    FileBufferMapper fFileBufferListener = new FileBufferMapper();
    static /* synthetic */ Class class$0;

    public static FileBufferModelManager getInstance() {
        return instance;
    }

    static final synchronized void shutdown() {
        FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)FileBufferModelManager.instance.fFileBufferListener);
        if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT || Logger.DEBUG_FILEBUFFERMODELLEAKS) {
            IDocument[] danglingDocuments = FileBufferModelManager.instance.fDocumentMap.keySet().toArray(new IDocument[0]);
            int i = 0;
            while (i < danglingDocuments.length) {
                DocumentInfo info = (DocumentInfo)FileBufferModelManager.instance.fDocumentMap.get(danglingDocuments[i]);
                if (info.modelReferenceCount > 0) {
                    System.err.println("LEAKED MODEL: " + info.buffer.getLocation() + " " + (info.model != null ? info.model.getId() : null));
                }
                if (info.bufferReferenceCount > 0) {
                    System.err.println("LEAKED BUFFER: " + info.buffer.getLocation() + " " + info.buffer.getDocument());
                }
                ++i;
            }
        }
    }

    static final synchronized void startup() {
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)FileBufferModelManager.getInstance().fFileBufferListener);
    }

    FileBufferModelManager() {
        this.fDocumentMap = new Hashtable(4);
    }

    public String calculateId(IFile file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not calculate a model ID without an IFile");
            Logger.logException(iae);
            return null;
        }
        String id = null;
        IPath path = file.getFullPath();
        if (path != null) {
            id = FileBuffers.normalizeLocation((IPath)path).toString();
        }
        return id;
    }

    public String calculateId(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not calculate a model ID without a document reference");
            Logger.logException(iae);
            return null;
        }
        String id = null;
        ITextFileBuffer buffer = this.getBuffer(document);
        if (buffer != null) {
            id = buffer.getLocation().toString();
        }
        return id;
    }

    public boolean connect(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not connect() without a document");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            return false;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath bufferLocation = info.buffer.getLocation();
        boolean isOK = true;
        try {
            bufferManager.connect(bufferLocation, info.locationKind, null);
        }
        catch (CoreException e) {
            Logger.logException(e);
            isOK = false;
        }
        return isOK;
    }

    URIResolver createURIResolver(ITextFileBuffer buffer) {
        IPath location = buffer.getLocation();
        IFile workspaceFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        URIResolver resolver = null;
        if (workspaceFile != null) {
            IProject project = workspaceFile.getProject();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.util.URIResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resolver = (URIResolver)project.getAdapter((Class)clazz)) == null) {
                resolver = new CommonURIResolver(workspaceFile);
            }
            String baseLocation = null;
            if (workspaceFile.getLocation() != null) {
                baseLocation = workspaceFile.getLocation().toString();
            }
            if (baseLocation == null && workspaceFile.getLocationURI() != null) {
                baseLocation = workspaceFile.getLocationURI().toString();
            }
            if (baseLocation == null) {
                baseLocation = workspaceFile.getFullPath().toString();
            }
            resolver.setFileBaseLocation(baseLocation);
        } else {
            resolver = new ExternalURIResolver(location);
        }
        return resolver;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IContentType detectContentType(IPath location) {
        IContentType type;
        block17: {
            File file;
            block15: {
                block16: {
                    type = null;
                    IFile resource = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                    if (resource == null) break block16;
                    if (resource.getType() == 1 && resource.isAccessible()) {
                        IContentDescription d = null;
                        try {
                            d = resource.getContentDescription();
                            if (d != null) {
                                type = d.getContentType();
                            }
                        }
                        catch (CoreException coreException) {}
                        if (type == null) {
                            type = Platform.getContentTypeManager().findContentTypeFor(resource.getName());
                        }
                    }
                    break block17;
                }
                file = FileBuffers.getSystemFileAtLocation((IPath)location);
                if (file == null) break block17;
                FileInputStream input = null;
                try {
                    try {
                        input = new FileInputStream(file);
                        type = Platform.getContentTypeManager().findContentTypeFor((InputStream)input, location.toOSString());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (input == null) throw throwable;
                    try {
                        ((InputStream)input).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                    if (input == null) break block15;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)input).close();
            }
            if (type == null) {
                type = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            }
        }
        if (type != null) return type;
        return Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    }

    public boolean disconnect(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not disconnect() without a document");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            return false;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath bufferLocation = info.buffer.getLocation();
        boolean isOK = true;
        try {
            bufferManager.disconnect(bufferLocation, info.locationKind, null);
        }
        catch (CoreException e) {
            Logger.logException(e);
            isOK = false;
        }
        return isOK;
    }

    public ITextFileBuffer getBuffer(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get a buffer without a document reference");
            Logger.logException(iae);
            return null;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            return info.buffer;
        }
        return null;
    }

    String getContentTypeID(IDocument document) {
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            return info.contentTypeID;
        }
        return null;
    }

    IStructuredModel getModel(File file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a java.io.File");
            Logger.logException(iae);
            return null;
        }
        IStructuredModel model = null;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            Path location = new Path(file.getAbsolutePath());
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager connecting to File " + location);
            }
            bufferManager.connect((IPath)location, LocationKind.LOCATION, this.getProgressMonitor());
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer((IPath)location, LocationKind.LOCATION);
            if (buffer != null) {
                IDocument bufferDocument;
                DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(buffer.getDocument());
                if (info != null) {
                    info.locationKind = LocationKind.LOCATION;
                    info.selfConnected = true;
                }
                if ((bufferDocument = buffer.getDocument()) instanceof IStructuredDocument) {
                    model = this.getModel((IStructuredDocument)bufferDocument);
                } else {
                    bufferManager.disconnect((IPath)location, LocationKind.IFILE, this.getProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error getting model for " + file.getPath(), e);
        }
        return model;
    }

    public IStructuredModel getModel(IFile file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without an IFile");
            Logger.logException(iae);
            return null;
        }
        IStructuredModel model = null;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            IPath location;
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager connecting to IFile " + file.getFullPath());
            }
            if ((location = file.getFullPath()) != null) {
                bufferManager.connect(location, LocationKind.IFILE, this.getProgressMonitor());
                ITextFileBuffer buffer = bufferManager.getTextFileBuffer(location, LocationKind.IFILE);
                if (buffer != null) {
                    IDocument bufferDocument;
                    DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(buffer.getDocument());
                    if (info != null) {
                        info.selfConnected = true;
                        info.locationKind = LocationKind.IFILE;
                    }
                    if ((bufferDocument = buffer.getDocument()) instanceof IStructuredDocument) {
                        model = this.getModel((IStructuredDocument)bufferDocument);
                    } else {
                        bufferManager.disconnect(location, LocationKind.IFILE, this.getProgressMonitor());
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error getting model for " + file.getFullPath(), e);
        }
        return model;
    }

    public IStructuredModel getModel(IStructuredDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            Logger.logException(iae);
            return null;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null && info.model == null) {
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager creating model for " + info.buffer.getLocation() + " " + info.buffer.getDocument());
            }
            ++info.modelReferenceCount;
            IStructuredModel model = null;
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(info.contentTypeID);
            IModelLoader loader = handler.getModelLoader();
            model = loader.createModel(document, info.buffer.getLocation().toString(), handler);
            try {
                info.model = model;
                model.setId(info.buffer.getLocation().toString());
                if (model instanceof AbstractStructuredModel) {
                    ((AbstractStructuredModel)model).setContentTypeIdentifier(info.contentTypeID);
                }
                model.setResolver(this.createURIResolver(this.getBuffer(document)));
                if (info.buffer.isDirty()) {
                    model.setDirtyState(true);
                }
            }
            catch (ResourceInUse e) {
                Logger.logException("attempted to create new model with existing ID", e);
                Object var3_4 = null;
            }
        }
        if (info != null) {
            return info.model;
        }
        return null;
    }

    private IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private void checkReferenceCounts(DocumentInfo info, IDocument document) {
        if (info.bufferReferenceCount == 0 && info.modelReferenceCount == 0) {
            this.fDocumentMap.remove(document);
        }
    }

    public boolean isExistingBuffer(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not check for an existing buffer without a document reference");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        return info != null;
    }

    public void releaseModel(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not release a model without a document reference");
            Logger.logException(iae);
            return;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager noticed full release of model for " + info.buffer.getLocation() + " " + info.buffer.getDocument());
            }
            info.model = null;
            --info.modelReferenceCount;
            if (info.selfConnected) {
                if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                    Logger.log(1, "FileBufferModelManager disconnecting from " + info.buffer.getLocation() + " " + info.buffer.getDocument());
                }
                IPath location = info.buffer.getLocation();
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(location, info.locationKind, this.getProgressMonitor());
                }
                catch (CoreException e) {
                    Logger.logException("Error releasing model for " + location, e);
                }
            }
            this.checkReferenceCounts(info, document);
        }
    }

    public void revert(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not release a model without a document reference");
            Logger.logException(iae);
            return;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            Logger.log(4, "FileBufferModelManager was asked to revert a document but was not being managed");
        } else {
            IPath location = info.buffer.getLocation();
            try {
                info.buffer.revert(this.getProgressMonitor());
            }
            catch (CoreException e) {
                Logger.logException("Error reverting model for " + location, e);
            }
        }
    }

    class CommonURIResolver
    implements URIResolver {
        String fLocation;
        IPath fPath;
        private IProject fProject;
        static final String SEPARATOR = "/";
        static final String FILE_PREFIX = "file://";

        CommonURIResolver(IFile workspaceFile) {
            this.fPath = workspaceFile.getFullPath();
            this.fProject = workspaceFile.getProject();
        }

        public String getFileBaseLocation() {
            return this.fLocation;
        }

        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            boolean baseHasPrefix = baseReference != null && baseReference.startsWith(FILE_PREFIX);
            String reference = null;
            reference = baseHasPrefix ? baseReference : FILE_PREFIX + baseReference;
            String result = URIResolverPlugin.createResolver().resolve(reference, null, uri);
            if (!baseHasPrefix && result.startsWith(FILE_PREFIX) && result.length() > FILE_PREFIX.length()) {
                result = result.substring(FILE_PREFIX.length());
            }
            return result;
        }

        public IProject getProject() {
            return this.fProject;
        }

        public IContainer getRootLocation() {
            String root = URIResolverPlugin.createResolver().resolve(FILE_PREFIX + this.getFileBaseLocation(), null, SEPARATOR);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(root));
            int i = 0;
            while (i < files.length) {
                if ((files[i].getType() & 2) == 2 && this.fPath.isPrefixOf(((IFolder)files[i]).getFullPath())) {
                    return (IFolder)files[i];
                }
                ++i;
            }
            return this.getProject();
        }

        public InputStream getURIStream(String uri) {
            return null;
        }

        public void setFileBaseLocation(String newLocation) {
            this.fLocation = newLocation;
        }

        public void setProject(IProject newProject) {
            this.fProject = newProject;
        }
    }

    static class DocumentInfo {
        ITextFileBuffer buffer = null;
        String contentTypeID = null;
        IStructuredModel model = null;
        boolean selfConnected = false;
        int bufferReferenceCount = 0;
        int modelReferenceCount = 0;
        LocationKind locationKind = LocationKind.NORMALIZE;

        DocumentInfo() {
        }
    }

    class ExternalURIResolver
    implements URIResolver {
        IPath fLocation;

        ExternalURIResolver(IPath location) {
            this.fLocation = location;
        }

        public String getFileBaseLocation() {
            return this.fLocation.toString();
        }

        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            if (uri == null) {
                return null;
            }
            if (uri.startsWith("file:")) {
                try {
                    URL url = new URL(uri);
                    return url.getFile();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return URIHelper.normalize((String)uri, (String)baseReference, (String)Path.ROOT.toString());
        }

        public IProject getProject() {
            return null;
        }

        public IContainer getRootLocation() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        public InputStream getURIStream(String uri) {
            return null;
        }

        public void setFileBaseLocation(String newLocation) {
            this.fLocation = new Path(newLocation);
        }

        public void setProject(IProject newProject) {
        }
    }

    class FileBufferMapper
    implements IFileBufferListener {
        FileBufferMapper() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void bufferCreated(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                IDocument document = textBuffer.getDocument();
                if (!(document instanceof IStructuredDocument)) {
                    return;
                }
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Learned new buffer: " + buffer.getLocation().toString() + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                DocumentInfo info = new DocumentInfo();
                info.buffer = textBuffer;
                info.contentTypeID = FileBufferModelManager.this.detectContentType(buffer.getLocation()).getId();
                ++info.bufferReferenceCount;
                FileBufferModelManager.this.fDocumentMap.put(textBuffer.getDocument(), info);
            }
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                DocumentInfo info;
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                if (!(textBuffer.getDocument() instanceof IStructuredDocument)) {
                    return;
                }
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Discarded buffer: " + buffer.getLocation().toString() + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                if ((info = (DocumentInfo)FileBufferModelManager.this.fDocumentMap.get(textBuffer.getDocument())) != null) {
                    --info.bufferReferenceCount;
                    FileBufferModelManager.this.checkReferenceCounts(info, textBuffer.getDocument());
                }
            }
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (buffer instanceof ITextFileBuffer) {
                ITextFileBuffer textBuffer;
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Buffer dirty state changed: (" + isDirty + ") " + buffer.getLocation().toString() + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                if (!((textBuffer = (ITextFileBuffer)buffer).getDocument() instanceof IStructuredDocument)) {
                    return;
                }
                DocumentInfo info = (DocumentInfo)FileBufferModelManager.this.fDocumentMap.get(textBuffer.getDocument());
                if (info != null && info.model != null) {
                    String msg = "Updating model dirty state for" + info.buffer.getLocation();
                    if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT || Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                        Logger.log(1, msg);
                    }
                    info.model.setDirtyState(isDirty);
                    IFile workspaceFile = FileBuffers.getWorkspaceFileAtLocation((IPath)info.buffer.getLocation());
                    if (!isDirty && workspaceFile != null) {
                        info.model.resetSynchronizationStamp((IResource)workspaceFile);
                    }
                }
            }
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer && Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                Logger.log(1, "Deleted buffer: " + buffer.getLocation().toOSString() + " " + buffer);
            }
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            if (buffer instanceof ITextFileBuffer && Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                Logger.log(1, "Moved buffer from: " + buffer.getLocation().toOSString() + " " + buffer);
                Logger.log(1, "Moved buffer to: " + path.toOSString() + " " + buffer);
            }
        }
    }
}

