/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.IMemento;
import org.eclipse.wst.server.discovery.internal.Messages;
import org.eclipse.wst.server.discovery.internal.ProgressUtil;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.XMLMemento;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.model.ExtensionUpdateSite;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtility {
    private static ExtensionUpdateSite[] getExtensionUpdateSites(URL url) throws CoreException {
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not load URL " + url);
        }
        if (in == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, "Could not load extensions", null));
        }
        try {
            IMemento memento = XMLMemento.loadMemento(in);
            IMemento[] children = memento.getChildren("site");
            int size = children.length;
            ArrayList<ExtensionUpdateSite> list = new ArrayList<ExtensionUpdateSite>(size);
            int i = 0;
            while (i < size) {
                String url2 = children[i].getString("url");
                ExtensionUpdateSite item = new ExtensionUpdateSite(url2, null, null);
                list.add(item);
                ++i;
            }
            ExtensionUpdateSite[] items = new ExtensionUpdateSite[list.size()];
            list.toArray(items);
            return items;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, e.getMessage(), (Throwable)e));
        }
    }

    private static ExtensionUpdateSite[] getExtensionUpdateSites() {
        URL url = Activator.getDefault().getBundle().getEntry("serverAdapterSites.xml");
        try {
            return ExtensionUtility.getExtensionUpdateSites(url);
        }
        catch (CoreException coreException) {
            Trace.trace((byte)3, "Could not get extension items");
            return new ExtensionUpdateSite[0];
        }
    }

    private static boolean alreadyExists(List<Extension> existing, Extension newFeature) {
        if (existing.contains(newFeature)) {
            return true;
        }
        Version newV = newFeature.getVersion();
        for (Extension feature : existing) {
            if (!feature.getId().equals(newFeature.getId()) || feature.getVersion().compareTo((Object)newV) < 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addExtension(List<Extension> list, List<Extension> existing, Extension newFeature, ExtensionListener listener) {
        if (ExtensionUtility.alreadyExists(existing, newFeature)) {
            return;
        }
        List<Extension> list2 = list;
        synchronized (list2) {
            Version newV = newFeature.getVersion();
            Extension remove = null;
            for (Extension feature : list) {
                if (!feature.getId().equals(newFeature.getId())) continue;
                if (feature.getVersion().compareTo((Object)newV) < 0) {
                    remove = feature;
                    continue;
                }
                return;
            }
            if (remove != null) {
                list.remove(remove);
                listener.extensionRemoved(remove);
            }
            list.add(newFeature);
        }
        listener.extensionFound(newFeature);
    }

    protected static void addExtensions(List<Extension> list, List<Extension> existing, List<Extension> newFeatures, ExtensionListener listener) {
        Iterator<Extension> iterator = newFeatures.iterator();
        while (iterator.hasNext()) {
            ExtensionUtility.addExtension(list, existing, iterator.next(), listener);
        }
    }

    private static List<Extension> getExistingFeatures(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.discoverLocalConfiguration, 100);
        IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(Activator.getDefault().getBundle().getBundleContext(), IProfileRegistry.class.getName());
        IProfile profile = profileRegistry.getProfile("_SELF_");
        InstallableUnitQuery query = new InstallableUnitQuery(null);
        Collector collector = new Collector();
        profile.query((Query)query, collector, monitor);
        ArrayList<Extension> list = new ArrayList<Extension>();
        for (IInstallableUnit iu : collector) {
            if (list.contains(iu)) continue;
            list.add(new Extension(iu, null));
        }
        monitor.done();
        return list;
    }

    public static Extension[] getAllExtensions(String id, final ExtensionListener listener, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask("", 1100);
        monitor.subTask(Messages.discoverLocalConfiguration);
        final List<Extension> existing = ExtensionUtility.getExistingFeatures(ProgressUtil.getSubMonitorFor(monitor, 100));
        final ExtensionUpdateSite[] items = ExtensionUtility.getExtensionUpdateSites();
        if (items == null || items.length == 0) {
            return new Extension[0];
        }
        final int x = 1000 / items.length;
        monitor.worked(50);
        final ArrayList list = new ArrayList();
        int size = items.length;
        Thread[] threads = new Thread[size];
        int i = 0;
        while (i < size) {
            block10: {
                if (!monitor.isCanceled()) break block10;
                return null;
            }
            try {
                monitor.subTask(NLS.bind((String)Messages.discoverSearching, (Object)items[i].getUrl()));
                final int ii = i;
                final IProgressMonitor monitor2 = monitor;
                threads[i] = new Thread("Extension Checker for " + items[i].getUrl()){

                    public void run() {
                        try {
                            List<Extension> list2 = items[ii].getExtensions(ProgressUtil.getSubMonitorFor(monitor2, x));
                            ExtensionUtility.addExtensions(list, existing, list2, listener);
                        }
                        catch (CoreException ce) {
                            listener.siteFailure(ce.getLocalizedMessage());
                            Trace.trace((byte)2, "Error downloading extension info", ce);
                        }
                    }
                };
                threads[i].setDaemon(true);
                threads[i].start();
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Error downloading extension info 2", e);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            block11: {
                if (!monitor.isCanceled()) break block11;
                return null;
            }
            try {
                if (threads[i].isAlive()) {
                    threads[i].join();
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Error downloading extension info 3", e);
            }
            ++i;
        }
        Extension[] ef = new Extension[list.size()];
        list.toArray(ef);
        monitor.done();
        return ef;
    }

    public static Object getService(BundleContext context, String name) {
        if (context == null) {
            return null;
        }
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    public static interface ExtensionListener {
        public void extensionFound(Extension var1);

        public void extensionRemoved(Extension var1);

        public void siteFailure(String var1);
    }
}

