/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.hyperlinkdetector;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xsl.core.internal.text.rules.StructuredTextPartitionerForXSL;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;
import org.eclipse.wst.xsl.ui.internal.editor.XSLHyperlinkDetector;
import org.eclipse.wst.xsl.ui.tests.AbstractXSLUITest;

public class TestXSLHyperlinkDetector
extends AbstractXSLUITest {
    protected String projectName = null;
    protected String fileName = null;
    protected IFile file = null;
    protected IEditorPart textEditorPart = null;
    protected ITextEditor editor = null;
    protected XMLDocumentLoader xmlDocumentLoader = null;
    protected IStructuredDocument document = null;
    protected StructuredTextViewer sourceViewer = null;
    protected StructuredTextViewerConfigurationXSL xslConfiguration = new StructuredTextViewerConfigurationXSL();
    protected String Partitioning = "__dftl_partitioning";
    protected StructuredTextPartitionerForXSL defaultPartitioner = new StructuredTextPartitionerForXSL();
    protected Shell shell = null;
    protected Composite parent = null;
    private IStructuredModel model = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.setupProject();
    }

    protected void loadFileForTesting(String xslFilePath) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(xslFilePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + this.fileName + " stylesheet."));
        }
        this.loadXSLFile();
        this.initializeSourceViewer();
    }

    protected void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            this.shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            this.parent = new Composite((Composite)this.shell, 0);
            this.sourceViewer = new StructuredTextViewer(this.parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)this.xslConfiguration);
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void setupProject() {
        this.projectName = "xsltestfiles";
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.parent.dispose();
    }

    private LineStyleProvider[] getLineStyleProviders() {
        LineStyleProvider[] lineStyleProviders = this.xslConfiguration.getLineStyleProviders((ISourceViewer)this.sourceViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        return lineStyleProviders;
    }

    private void setUpTest(String file) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.fileName = file;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        TestXSLHyperlinkDetector.assertNotNull((String)"Missing Document Partitioner", (Object)document.getDocumentPartitioner());
    }

    protected void loadXSLFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.model = modelManager.getNewModelForEdit(this.file, true);
        this.document = this.model.getStructuredDocument();
        IDocumentPartitioner partitioner = this.defaultPartitioner.newInstance();
        partitioner.connect((IDocument)this.document);
        this.document.setDocumentPartitioner(partitioner);
    }

    public void testDetectHyperlinksDocument() throws Exception {
        this.setUpTest("DraftReleaseCRs.xsl");
        try {
            XSLHyperlinkDetector linkDetector = new XSLHyperlinkDetector();
            Region region = new Region(this.sourceViewer.getDocument().getLineOffset(28) + 54, 0);
            boolean canShowMultipleLinks = true;
            IHyperlink[] links = linkDetector.detectHyperlinks((IDocument)this.document, (IRegion)region, canShowMultipleLinks);
            TestXSLHyperlinkDetector.assertNotNull((String)"No links returned", (Object)links);
            TestXSLHyperlinkDetector.assertEquals((String)"Unexpected number of links", (int)1, (int)links.length);
        }
        finally {
            this.model.releaseFromEdit();
        }
    }

    public void testDetectHyperlinksViewer() throws Exception {
        this.setUpTest("DraftReleaseCRs.xsl");
        try {
            XSLHyperlinkDetector linkDetector = new XSLHyperlinkDetector();
            Region region = new Region(this.sourceViewer.getDocument().getLineOffset(28) + 54, 0);
            boolean canShowMultipleLinks = true;
            IHyperlink[] links = linkDetector.detectHyperlinks((ITextViewer)this.sourceViewer, (IRegion)region, canShowMultipleLinks);
            TestXSLHyperlinkDetector.assertNotNull((String)"No links returned", (Object)links);
            TestXSLHyperlinkDetector.assertEquals((String)"Unexpected number of links", (int)1, (int)links.length);
        }
        finally {
            this.model.releaseFromEdit();
        }
    }

    public void testWithParmVariableLink() throws Exception {
        this.setUpTest("DraftReleaseCRs.xsl");
        try {
            XSLHyperlinkDetector linkDetector = new XSLHyperlinkDetector();
            Region region = new Region(this.sourceViewer.getDocument().getLineOffset(74) + 44, 0);
            boolean canShowMultipleLinks = true;
            IHyperlink[] links = linkDetector.detectHyperlinks((ITextViewer)this.sourceViewer, (IRegion)region, canShowMultipleLinks);
            TestXSLHyperlinkDetector.assertNotNull((String)"No links returned", (Object)links);
            TestXSLHyperlinkDetector.assertEquals((String)"Unexpected number of links", (int)1, (int)links.length);
            IHyperlink link = links[0];
            TestXSLHyperlinkDetector.assertTrue((String)"Wrong file returned.", (boolean)link.getHyperlinkText().contains("utils.xsl"));
        }
        finally {
            this.model.releaseFromEdit();
        }
    }
}

