/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.TestSourceElementRequestor;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class GenericDietRecoveryTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public GenericDietRecoveryTest(String testName) {
        super(testName);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyPlusStatementsRecoveryUnitToString, String expectedFullUnitToString, String expectedCompletionDietUnitToString, String testName) {
        int i;
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(true);
        parser.setStatementsRecovery(true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        if (!expectedDietPlusBodyPlusStatementsRecoveryUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid source element diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        GenericDietRecoveryTest.assertEquals("Invalid source element full structure" + testName, expectedFullUnitToString, computedUnitToString);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser2 = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit2 = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult2 = new CompilationResult((ICompilationUnit)sourceUnit2, 0, 0, 0);
        CompilationUnitDeclaration computedUnit2 = parser2.dietParse((ICompilationUnit)sourceUnit2, compilationResult2, Integer.MAX_VALUE);
        String computedUnitToString2 = computedUnit2.toString();
        if (!expectedCompletionDietUnitToString.equals(computedUnitToString2)) {
            System.out.println(Util.displayString(computedUnitToString2));
        }
        GenericDietRecoveryTest.assertEquals("Invalid completion diet structure" + testName, expectedCompletionDietUnitToString, computedUnitToString2);
    }

    public void test0001() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0002() {
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic interface X <A {\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "package a;\npublic interface X<A> {\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0003() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A>\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0004() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0005() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B\t\t\t\t\t\t\t\n   A a;\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B> {\n  A a;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B> {\n  A a;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0006() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A extends String, B\t\t\t\n   A a;\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A extends String, B> {\n  A a;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A extends String, B> {\n  A a;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0007() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A extends\t\t\t\t\t\n   A a;\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A extends A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A extends A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0008() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A exteds\tB>\t\t\t\t\t\n   A a;\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  exteds B;\n  A a;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  exteds B;\n  A a;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0009() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A extends>\t\t\t\t\t\n   A a;\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  A a;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  A a;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0010() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A extends\t\t\t\t\t\n   void foo(){}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0011() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B extends\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0012() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B extends\tZ\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B extends Z> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B extends Z> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0013() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B extends\tZ<\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0014() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B extends\tZ<Y\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0015() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A, B extends\tZ<Y>\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A, B extends Z<Y>> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A, B extends Z<Y>> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0016() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A super int> {\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0017() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A<B super int>> {\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0018() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X <A<B<C super int>>> {\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X<A> {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X<A> {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0019() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\n\t\tvoid foo()[\n\t\t  Object o = (Y<Z>.W<U>)e\n\t\t\n\t\t}\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    Object o = (Y<Z>.W<U>) e;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0020() {
        String expectedDietPlusBodyUnitToString;
        String s = "public class X<T> {\n  public class B<U> {}\n  public static void main (String[] args) {\n    X<?>.B[] b = new X<?>.B[1];\n    X<?>.B<?>[] b = new X<?>.B<?>[1];\n    p.p1.X<?>.q.B<?>[] b = new p.p1.X<?>.q.B<?>[1];\n    p.p1.X<?>.q.B[] b = new p.p1.X<?>.q.B[1];\n    p.p1.X<?>[] b = new p.p1.X<?>[1];\n    p.p1.X<String, Integer>.q.B<?>[] b = new p.p1.X<String, Integer>.q.B<?>[1];\n    X<?>.B<?> b = null;\n    p.p1.X<?>.q.B<?> b = null;\n    p.p1.X<String, Integer>.q.B<?> b = null;\n  }\n}";
        String expectedDietUnitToString = "public class X<T> {\n  public class B<U> {\n    public B() {\n    }\n  }\n  public X() {\n  }\n  public static void main(String[] args) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = "public class X<T> {\n  public class B<U> {\n    public B() {\n      super();\n    }\n  }\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    X<?>.B[] b = new X<?>.B[1];\n    X<?>.B<?>[] b = new X<?>.B<?>[1];\n    p.p1.X<?>.q.B<?>[] b = new p.p1.X<?>.q.B<?>[1];\n    p.p1.X<?>.q.B[] b = new p.p1.X<?>.q.B[1];\n    p.p1.X<?>[] b = new p.p1.X<?>[1];\n    p.p1.X<String, Integer>.q.B<?>[] b = new p.p1.X<String, Integer>.q.B<?>[1];\n    X<?>.B<?> b = null;\n    p.p1.X<?>.q.B<?> b = null;\n    p.p1.X<String, Integer>.q.B<?> b = null;\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0021() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K> List<Map<K,T> foo(Map<T,K> m);\n\t<K,E> List<Map<K,E> bar(Map<T,K> m, Map<T,E> e);\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  <K>Map<K, T> foo(Map<T, K> m);\n  <K, E>Map<K, E> bar(Map<T, K> m, Map<T, E> e);\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0022() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K> List<Map<K,T> foo();\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  <K>Map<K, T> foo();\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0023() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K>\n\tList<Map<K,T> foo();\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  Map<K, T> foo();\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0024() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K> public void foo();\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  public void foo();\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0025() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K> public List<Map<K,T> foo();\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  <K>Map<K, T> foo();\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0026() {
        String expectedDietUnitToString;
        String expectedDietPlusBodyUnitToString;
        String s = "import java.util.*;\npublic interface X<T> {\n\t<K> Map<List<T>,List<K> foo();\n}";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = (expectedDietUnitToString = "import java.util.*;\npublic interface X<T> {\n  <T>List<K> foo();\n}\n");
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<generic type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }
}

