/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SuperTypeTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public SuperTypeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SuperTypeTest.buildAllCompliancesTestSuite(SuperTypeTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.SuperTypeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runConformTest(new String[]{"org/eclipse/curiosity/A.java", "package org.eclipse.curiosity;\npublic abstract class A implements InterfaceA {\n\tprivate void e() {\n\t}\n\tpublic void f() {\n\t\tthis.e();\n\t}\n}", "org/eclipse/curiosity/InterfaceA.java", "package org.eclipse.curiosity;\npublic interface InterfaceA extends InterfaceBase {}\n", "org/eclipse/curiosity/InterfaceBase.java", "package org.eclipse.curiosity;\npublic interface InterfaceBase {\n    public void a();\n    public void b();\n    public void c();\n    public void d();\n}"});
    }

    public void test002() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tclass M { \n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tM m; \n\t\t}; \n\t\tSystem.out.println(\"SUCCESS\");\t\n\t} \n} \nclass Secondary { \n\tclass M {} \n} \n"};
        if (this.complianceLevel.equals("1.3")) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 10)\n\tM m; \n\t^\nThe type M is defined in an inherited type and an enclosing scope\n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test003() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"FAILED\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar(){ return \"SUCCESS\"; } \n} \n"};
        if (this.complianceLevel.equals("1.3")) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 11)\n\tString z = bar();\t\n\t           ^^^\nThe method bar is defined in an inherited type and an enclosing scope\n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test004() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar = \"FAILED\";\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar; \n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar = \"SUCCESS\"; \n} \n"};
        if (this.complianceLevel.equals("1.3")) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 8)\n\tString z = bar; \n\t           ^^^\nThe field bar is defined in an inherited type and an enclosing scope \n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test005() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"SUCCESS\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tprivate String bar(){ return \"FAILED\"; } \n} \n"}, "SUCCESS");
    }

    public void test006() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar = \"SUCCESS\";\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar; \n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tprivate String bar = \"FAILED\"; \n} \n"}, "SUCCESS");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"FAILED\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar(int i){ return \"SUCCESS\"; } \n} \n"}, "----------\n1. ERROR in p1\\Test.java (at line 11)\n\tString z = bar();\t\n\t           ^^^\nThe method bar(int) in the type Secondary is not applicable for the arguments ()\n----------\n");
    }
}

