/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.NullReferenceImplTests;

class TransitiveClosureHolder {
    Map elements = new TreeMap();

    public TransitiveClosureHolder() {
        Element start = new Element(NullReferenceImplTests.State.start);
        this.elements.put(start.value, start);
    }

    void add(NullReferenceImplTests.State value) {
        if (value == null) {
            throw new IllegalArgumentException("not a valid state");
        }
        if (!this.elements.containsKey(value)) {
            this.elements.put(value, new Element(value));
        }
    }

    void add(NullReferenceImplTests.State[] values) {
        if (values == null) {
            throw new IllegalArgumentException("not a valid states set");
        }
        int i = 0;
        int length = values.length;
        while (i < length) {
            this.add(values[i]);
            ++i;
        }
    }

    NullReferenceImplTests.State[] asArray() {
        int length = this.elements.size();
        NullReferenceImplTests.State[] result = new NullReferenceImplTests.State[length];
        Iterator elementsIterator = this.elements.keySet().iterator();
        int j = 0;
        while (j < length) {
            result[j] = (NullReferenceImplTests.State)elementsIterator.next();
            ++j;
        }
        return result;
    }

    NullReferenceImplTests.State[] notAlreadyKnowns() {
        ArrayList<NullReferenceImplTests.State> resultAccumulator = new ArrayList<NullReferenceImplTests.State>(this.elements.size());
        Iterator i = this.elements.values().iterator();
        while (i.hasNext()) {
            Element current = (Element)i.next();
            if (current.alreadyKnown) continue;
            resultAccumulator.add(current.value);
        }
        int length = resultAccumulator.size();
        NullReferenceImplTests.State[] result = new NullReferenceImplTests.State[length];
        int j = 0;
        while (j < length) {
            result[j] = (NullReferenceImplTests.State)resultAccumulator.get(j);
            ++j;
        }
        return result;
    }

    void markAllAsAlreadyKnown() {
        Iterator i = this.elements.values().iterator();
        while (i.hasNext()) {
            ((Element)i.next()).alreadyKnown = true;
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Transitive closure:\n");
        TreeMap sorted = new TreeMap(this.elements);
        Iterator i = sorted.keySet().iterator();
        while (i.hasNext()) {
            output.append(i.next().toString());
            output.append('\n');
        }
        return output.toString();
    }

    static class Element {
        NullReferenceImplTests.State value;
        boolean alreadyKnown;

        Element(NullReferenceImplTests.State value) {
            if (value == null) {
                throw new IllegalArgumentException("not a valid element");
            }
            this.value = value;
        }
    }
}

