/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.future.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class CastTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public CastTest(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        defaultOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        return defaultOptions;
    }

    public static Test suite() {
        return CastTest.buildAllCompliancesTestSuite(CastTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n       Cloneable c1 = new int[0]; \n\t\tCloneable c2 = (Cloneable)c1; \n\t\tSystem.out.print(\"SUCCESS\");\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// standard expressions\n\t\tString s = (String) null;\t// UNnecessary\n\t\tString t = (String) \"hello\";\t// UNnecessary\n\t\tfloat f = (float) 12;\t\t\t// UNnecessary\n\t\tint i = (int)12.0;\t\t\t\t//   necessary\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString s = (String) null;\t// UNnecessary\n\t           ^^^^^^^^^^^^^\nUnnecessary cast from null to String\n----------\n2. ERROR in X.java (at line 5)\n\tString t = (String) \"hello\";\t// UNnecessary\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n3. ERROR in X.java (at line 6)\n\tfloat f = (float) 12;\t\t\t// UNnecessary\n\t          ^^^^^^^^^^\nUnnecessary cast from int to float\n----------\n", null, true, customOptions);
    }

    public void test003() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// message sends\t\t\n\t\tfoo((Object) \"hello\");\t\t//   necessary\n\t\tfoo((String) \"hello\");\t\t\t// UNnecessary\n\t\tfoo((Object) null);\t\t\t//   necessary\n\t\tfoo((String) null);\t\t\t\t// UNnecessary but keep as useful documentation \n\t}\n\tstatic void foo(String s) {\n\t\tSystem.out.println(\"foo(String):\"+s);\n\t}\n\tstatic void foo(Object o) {\n\t\tSystem.out.println(\"foo(Object):\"+o);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tfoo((String) \"hello\");\t\t\t// UNnecessary\n\t    ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", null, true, customOptions);
    }

    public void test004() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// constructors\n\t\tnew X((Object) \"hello\");\t//   necessary\n\t\tnew X((String) \"hello\");\t// UNnecessary\n\t\tnew X((Object) null);\t\t//   necessary\n\t\tnew X((String) null);\t\t// UNnecessary but keep as useful documentation\n\t}\n\tX(){}\n\tX(String s){\n\t\tSystem.out.println(\"new X(String):\"+s);\n\t}\n\tX(Object o){\n\t\tSystem.out.println(\"new X(Object):\"+o);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew X((String) \"hello\");\t// UNnecessary\n\t      ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", null, true, customOptions);
    }

    public void test005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// qualified allocations\n\t\tnew X().new XM3((Object) \"hello\");\t//   necessary\n\t\tnew X().new XM3((String) \"hello\");\t// UNnecessary\n\t\tnew X().new XM3((Object) null);\t\t//   necessary\n\t\tnew X().new XM3((String) null);\t\t// UNnecessary but keep as useful documentation\n\t\tnew X().new XM3((Object) \"hello\"){};\t//   necessary\n\t\tnew X().new XM3((String) \"hello\"){};\t// UNnecessary\n\t\tnew X().new XM3((Object) null){};\t\t//   necessary\n\t\tnew X().new XM3((String) null){};\t\t// UNnecessary but keep as useful documentation\n\t}\n\tX(){}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n\tclass XM3 {\n\t\tXM3(String s){\n\t\t\tSystem.out.println(\"new XM3(String):\"+s);\n\t\t}\n\t\tXM3(Object o){\n\t\t\tSystem.out.println(\"new XM3(Object):\"+o);\n\t\t}\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew X().new XM3((String) \"hello\");\t// UNnecessary\n\t                ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n2. ERROR in X.java (at line 9)\n\tnew X().new XM3((String) \"hello\"){};\t// UNnecessary\n\t                ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", null, true, customOptions);
    }

    public void _test006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// ternary operator\n\t\tString s = null, t = null;\t\n\t\tX x0 = s == t\n\t\t\t? (X)new XM1()\t\t\t// UNnecessary\n\t\t\t: new X();\n\t\tX x1 = s == t \n\t\t\t? (X)new XM1()\t\t\t//   necessary\n\t\t\t: new XM2();\n\t\tX x2 = s == t \n\t\t\t? new XM1()\n\t\t\t: (X)new XM2();\t\t\t//   necessary\n\t\tX x3 = s == t \n\t\t\t? (X)new XM1()\t\t\t//   necessary\n\t\t\t: (X)new XM2();\t\t\t//   necessary\n\t}\n\tX(){}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n}\n"}, "x", null, true, customOptions);
    }

    public void test007() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX(){}\n\tclass XM3 {\n\t\tXM3(String s){\n\t\t\tSystem.out.println(\"new XM3(String):\"+s);\n\t\t}\n\t\tXM3(Object o){\n\t\t\tSystem.out.println(\"new XM3(Object):\"+o);\n\t\t}\n\t}\t\n\t\n\tclass XM4 extends XM3 {\n\t\tXM4(String s){\n\t\t\tsuper((Object) s); // necessary\n\t\t\tSystem.out.println(\"new XM4(String):\"+s);\n\t\t}\n\t\tXM4(Object o){\n\t\t\tsuper((String) o); // necessary\n\t\t\tSystem.out.println(\"new XM4(Object):\"+o);\n\t\t}\n\t\tXM4(Thread t){\n\t\t\tsuper((Object) t); // UNnecessary\n\t\t\tSystem.out.println(\"new XM4(Thread):\"+t);\n\t\t}\n\t\tXM4(){\n\t\t\tsuper((String)null); // UNnecessary but keep as useful documentation\n\t\t\tSystem.out.println(\"new XM4():\");\n\t\t}\n\t\tXM4(int i){\n\t\t\tsuper((Object)null); // necessary\n\t\t\tSystem.out.println(\"new XM4():\");\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 22)\n\tsuper((Object) t); // UNnecessary\n\t      ^^^^^^^^^^\nUnnecessary cast from Thread to Object\n----------\n", null, true, customOptions);
    }

    public void test008() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = new XM1() instanceof X; // UNnecessary\n\t\tboolean b2 = new X() instanceof XM1; // necessary\n\t\tboolean b3 = null instanceof X;\n\t}\n\tstatic class XM1 extends X {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tboolean b1 = new XM1() instanceof X; // UNnecessary\n\t             ^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X.XM1 is already an instance of type X\n----------\n", null, true, customOptions);
    }

    public void test009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = ((X) new XM1()) == new X(); // UNnecessary\n\t\tboolean b2 = ((X) new XM1()) == new XM2(); // necessary\n\t\tboolean b3 = ((X) null) == new X(); // UNnecessary\n\t}\n\tstatic class XM1 extends X {}\n\tstatic class XM2 extends X {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tboolean b1 = ((X) new XM1()) == new X(); // UNnecessary\n\t             ^^^^^^^^^^^^^^^\nUnnecessary cast from X.XM1 to X\n----------\n2. ERROR in X.java (at line 5)\n\tboolean b3 = ((X) null) == new X(); // UNnecessary\n\t             ^^^^^^^^^^\nUnnecessary cast from null to X\n----------\n", null, true, customOptions);
    }

    public void test010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tlong l1 = ((long) 1) + 2L; // UNnecessary\n\t\tlong l2 = ((long)1) + 2; // necessary\n\t\tlong l3 = 0;\t\tl3 += (long)12; // UNnecessary\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tlong l1 = ((long) 1) + 2L; // UNnecessary\n\t          ^^^^^^^^^^\nUnnecessary cast from int to long\n----------\n2. ERROR in X.java (at line 5)\n\tlong l3 = 0;\t\tl3 += (long)12; // UNnecessary\n\t            \t\t      ^^^^^^^^\nUnnecessary cast from int to long\n----------\n", null, true, customOptions);
    }

    public void test011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString s1 = ((long) 1) + \"hello\"; // necessary\n\t\tString s2 = ((String)\"hello\") + 2; // UNnecessary\n\t\tString s3 = ((String)null) + null; // necessary\n\t\tString s4 = ((int) (byte)1) + \"hello\"; // necessary\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString s2 = ((String)\"hello\") + 2; // UNnecessary\n\t            ^^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", null, true, customOptions);
    }

    public void test012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t// message sends\t\t\n\t\tX x = new YM1();\t\n\t\tfoo((X) x);\t\t\t// UNnecessary\n\t\tfoo((XM1) x);\t// UNnecessary\n\t\tfoo((YM1) x);\t// necessary \n\t}\n\tstatic void foo(X x) {}\n\tstatic void foo(YM1 ym1) {}\n  static class XM1 extends X {}\n  static class YM1 extends XM1 {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tfoo((X) x);\t\t\t// UNnecessary\n\t    ^^^^^\nUnnecessary cast from X to X\n----------\n2. ERROR in X.java (at line 6)\n\tfoo((XM1) x);\t// UNnecessary\n\t    ^^^^^^^\nUnnecessary cast from X to X.XM1\n----------\n", null, true, customOptions);
    }

    public void test013() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tint a = 0, b = 1;\n\t\tlong d;\n\t\td = (long)a; \t\t\t\t// unnecessary\n\t\td = (long)a + b; \t\t// necessary \n\t\td = d + a + (long)b; \t// unnecessary\n\t}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 6)\n\td = (long)a; \t\t\t\t// unnecessary\n\t    ^^^^^^^\nUnnecessary cast from int to long\n----------\n2. ERROR in X.java (at line 8)\n\td = d + a + (long)b; \t// unnecessary\n\t            ^^^^^^^\nUnnecessary cast from int to long\n----------\n", null, true, customOptions);
    }

    public void test014() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tboolean b = new Cloneable() {} instanceof Cloneable;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tboolean b = new Cloneable() {} instanceof Cloneable;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type new Cloneable(){} is already an instance of type Cloneable\n----------\n", null, true, customOptions);
    }

    public void test015() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\t\n    int lineCount = 10; \n    long time = 1000; \n    double linePerSeconds1 = ((int) (lineCount * 10000.0 / time)) / 10.0; // necessary \n    double linePerSeconds2 = ((double) (lineCount * 10000.0 / time)) / 10.0; // UNnecessary \n  } \n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tdouble linePerSeconds2 = ((double) (lineCount * 10000.0 / time)) / 10.0; // UNnecessary \n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from double to double\n----------\n", null, true, customOptions);
    }

    public void test016() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\t\n    int lineCount = 10; \n    long time = 1000; \n    print((int) (lineCount * 10000.0 / time)); // necessary \n    print((double) (lineCount * 10000.0 / time)); // UNnecessary \n  } \n  void print(double d) {}  \n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tprint((double) (lineCount * 10000.0 / time)); // UNnecessary \n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from double to double\n----------\n", null, true, customOptions);
    }

    public void test017() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tfoo((X) this);\n\t\tfoo((X) zork());\n\t}\n\tvoid foo(X x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo((X) this);\n\t    ^^^^^^^^\nUnnecessary cast from X to X\n----------\n2. ERROR in X.java (at line 4)\n\tfoo((X) zork());\n\t        ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test018() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tstatic Y[] foo(int[] tab) {\n\t\treturn null;\n\t}\n}\npublic class X extends Y {\n\tY[] bar() {\n\t\treturn (Y[]) Y.foo(new double[] {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\treturn (Y[]) Y.foo(new double[] {});\n\t               ^^^\nThe method foo(int[]) in the type Y is not applicable for the arguments (double[])\n----------\n", null, true, customOptions);
    }

    public void tes019() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tX x1 =(X) this;\n\t\tX x2 = (X) zork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x1 =(X) this;\n\t      ^^^^^^^^\nUnnecessary cast to type X for expression of type X\n----------\n2. ERROR in X.java (at line 4)\n\tX x2 = (X) zork();\n\t           ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test020() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\tlong l = (long)zork() + 2;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tlong l = (long)zork() + 2;\n\t               ^^^^\nThe method zork() is undefined for the type X\n----------\n", null, true, customOptions);
    }

    public void test021() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tpublic class Member1 {}\n\tpublic class Member2 {}\n\tclass Member3 {}\n   public static class Member4 {\n\t   public static class M4Member {}\n   }\n}\n", "p2/B.java", "package p2;\nimport p1.A;\npublic class B extends A {\n\tpublic class Member1 {}\n}\n", "p1/C.java", "package p1;\nimport p2.B;\npublic class C extends B {\n\tvoid baz(B b) {\n\t\t((A)b).new Member1(); // necessary since would bind to B.Member instead\n\t\t((A)b).new Member2(); // UNnecessary\n\t\t((A)b).new Member3(); // necessary since visibility issue\n\t\t((A)b).new Member4().new M4Member(); // fault tolerance\n\t\t((A)zork()).new Member1(); // fault-tolerance\n\t\t// anonymous\n\t\t((A)b).new Member1(){}; // necessary since would bind to B.Member instead\n\t\t((A)b).new Member2(){}; // UNnecessary\n\t\t((A)b).new Member3(){}; // necessary since visibility issue\n\t\t((A)b).new Member4().new M4Member(){}; // fault tolerance\n\t\t((A)zork()).new Member1(){}; // fault-tolerance\n\t}\n}\n"}, "----------\n1. ERROR in p1\\C.java (at line 6)\n\t((A)b).new Member2(); // UNnecessary\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n2. ERROR in p1\\C.java (at line 8)\n\t((A)b).new Member4().new M4Member(); // fault tolerance\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n3. ERROR in p1\\C.java (at line 9)\n\t((A)zork()).new Member1(); // fault-tolerance\n\t    ^^^^\nThe method zork() is undefined for the type C\n----------\n4. ERROR in p1\\C.java (at line 12)\n\t((A)b).new Member2(){}; // UNnecessary\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n5. ERROR in p1\\C.java (at line 14)\n\t((A)b).new Member4().new M4Member(){}; // fault tolerance\n\t^^^^^^\nUnnecessary cast from B to A\n----------\n6. ERROR in p1\\C.java (at line 15)\n\t((A)zork()).new Member1(){}; // fault-tolerance\n\t    ^^^^\nThe method zork() is undefined for the type C\n----------\n", null, true, customOptions);
    }

    public void test022() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n  void foo(java.util.Map map){ \n    int[] fillPattern = new int[0]; \n    if (fillPattern.equals((int[])map.get(\"x\"))) { \n    }  \n  } \n} \n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (fillPattern.equals((int[])map.get(\"x\"))) { \n\t                       ^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to int[]\n----------\n", null, true, customOptions);
    }

    public void test023() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tfinal long lgLow32BitMask1 = ~(~((long) 0) << 32);\t\t// necessary\n\t\tfinal long lgLow32BitMask2 = ~(~0 << 32);\t\t\t\t\t// necessary\n\t\tfinal long lgLow32BitMask3 = ~(~((long) 0L) << 32);\t// unnecessary\n\t\tfinal long lgLow32BitMask4 = ~(~((int) 0L) << 32);\t\t// necessary\n\t\tSystem.out.println(\"lgLow32BitMask1: \"+lgLow32BitMask1);\n\t\tSystem.out.println(\"lgLow32BitMask2: \"+lgLow32BitMask2);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tfinal long lgLow32BitMask3 = ~(~((long) 0L) << 32);\t// unnecessary\n\t                                ^^^^^^^^^^^\nUnnecessary cast from long to long\n----------\n", null, true, customOptions);
    }

    public void test024() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object bar) {\n\t\tSystem.out.println(((Object) bar).toString());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(((Object) bar).toString());\n\t                   ^^^^^^^^^^^^^^\nUnnecessary cast from Object to Object\n----------\n", null, true, customOptions);
    }

    public void test025() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint i;\n\tpublic void foo(X bar) {\n\t\tSystem.out.println(((X) bar).i);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println(((X) bar).i);\n\t                   ^^^^^^^^^\nUnnecessary cast from X to X\n----------\n", null, true, customOptions);
    }

    public void test026() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = (B) a;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tB b = (B) a;\n\t      ^^^^^\nCannot cast from A to B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = (B) a;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test027() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    boolean b = a instanceof B;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tboolean b = a instanceof B;\n\t            ^^^^^^^^^^^^^^\nIncompatible conditional operand types A and B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    boolean b = a instanceof B;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test028() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = null;\n    boolean c = a == b;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tboolean c = a == b;\n\t            ^^^^^^\nIncompatible operand types A and B\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    A a = null;\n    B b = null;\n    boolean c = a == b;\n  }\n}\ninterface A {\n  void doSomething();\n}\ninterface B {\n  int doSomething();\n}"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = (char[][])null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = (char[][])(char[][])(char[][])null;\t\n\t\t\tqName[0] = new char[2];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t    char[][] qName;\t\n\t\t\tqName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tqName[0] = new char[3];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t\tchar[][] qName = null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])null;\t\n\t\t\tqName[0] = new char[1];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])(char[][])(char[][])null;\t\n\t\t\tqName[0] = new char[2];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tqName[0] = new char[3];\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n\t\ttry {\t\n\t\t\tchar[][] qName = null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = (char[][])(char[][])(char[][])null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\ttry {\t\n\t\t\tchar[][] qName = args.length > 1 ? new char[1][2] : null;\t\n\t\t\tsetName(qName[0]);\t\n\t\t} catch(Exception e){\t\n\t\t}\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tstatic void setName(char[] name) {\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\t\ttry {\n\t\t\t\t((int[]) null)[0] = 0;\n\t\t\t\t((int[]) null)[0] += 1;\n\t\t\t\t((int[]) null)[0] ++;\n\t\t\t} catch (NullPointerException e) {\n\t\t\t\tSystem.out.print(\"SUCCESS\");\n\t\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test033() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String [] args) {\n        List list = (List) new ArrayList();\n        list = (List) new ArrayList();\n        \n        String s = (String) \"hello\";\n        s += (List) new ArrayList();\n        \n        ArrayList alist = new ArrayList();\n        List list2 = (List) alist;\n        list2 = (List) alist;\n        \n        String s2 = (String) \"hello\";\n        s2 += (List) alist;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tList list = (List) new ArrayList();\n\t            ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n2. ERROR in X.java (at line 7)\n\tlist = (List) new ArrayList();\n\t       ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n3. ERROR in X.java (at line 9)\n\tString s = (String) \"hello\";\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n4. ERROR in X.java (at line 10)\n\ts += (List) new ArrayList();\n\t     ^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n5. ERROR in X.java (at line 13)\n\tList list2 = (List) alist;\n\t             ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n6. ERROR in X.java (at line 14)\n\tlist2 = (List) alist;\n\t        ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n7. ERROR in X.java (at line 16)\n\tString s2 = (String) \"hello\";\n\t            ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n8. ERROR in X.java (at line 17)\n\ts2 += (List) alist;\n\t      ^^^^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n", null, true, customOptions);
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String [] args) {\n        List list = (List) new ArrayList();\n        list = (List) new ArrayList();\n        \n        ArrayList alist = new ArrayList();\n        List list2 = (List) alist;\n        list2 = (List) alist;\n        \n       System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"Test231.java", "public class Test231 implements Test231i\n{\n\tvoid\tfoo()\n\t{\n\t\tnew Object()\n\t\t{\n\t\t\tTest231i\tbar()\n\t\t\t{\n\t\t\t\treturn\t(Test231i)this;\n\t\t\t}\n\t\t};\n\t}\n}\n\n\ninterface Test231i\n{\n}\n"}, "----------\n1. ERROR in Test231.java (at line 9)\n\treturn\t(Test231i)this;\n\t      \t^^^^^^^^^^^^^^\nCannot cast from new Object(){} to Test231i\n----------\n");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "public final class X {\n\tprivate static final boolean DO_BUG = true;\n\n\t// Workaround: cast null to Base\n\tprivate static Base base = DO_BUG ?\n\t// (Base)null\n\t\t\tnull : new Base() {\n\t\t\t\tpublic final String test() {\n\t\t\t\t\treturn (\"anonymous\");\n\t\t\t\t}\n\t\t\t};\n\n\tprivate X() {\n\t}\n\n\tpublic static void main(String[] argv) {\n\t\tif (base == null)\n\t\t\tSystem.out.println(\"no base\");\n\t\telse\n\t\t\tSystem.out.println(base.test());\n\t}\n\n\tprivate static abstract class Base {\n\t\tpublic Base() {\n\t\t}\n\n\t\tpublic abstract String test();\n\t}\n}\n"}, "no base");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger[] integers = {};\n\t\tint[] ints = (int[]) integers;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint[] ints = (int[]) integers;\n\t             ^^^^^^^^^^^^^^^^\nCannot cast from Integer[] to int[]\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tSystem.out.println(null instanceof Object);\n      Zork z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\r\n\tZork z;\r\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tObject fo = (String) new Object();\n\tvoid foo(ArrayList al) {\n\t\tList l = (List) al;\n\t\tObject o;\n\t\to = (ArrayList) al;\n\t\tObject o2 = (ArrayList) al;\n\t\to = (ArrayList) l;\n\t\tObject o3 = (ArrayList) l;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tObject fo = (String) new Object();\n\t            ^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to String\n----------\n2. WARNING in X.java (at line 5)\n\tList l = (List) al;\n\t         ^^^^^^^^^\nUnnecessary cast from ArrayList to List\n----------\n3. WARNING in X.java (at line 7)\n\to = (ArrayList) al;\n\t    ^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to ArrayList\n----------\n4. WARNING in X.java (at line 8)\n\tObject o2 = (ArrayList) al;\n\t            ^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList to ArrayList\n----------\n5. WARNING in X.java (at line 9)\n\to = (ArrayList) l;\n\t    ^^^^^^^^^^^^^\nUnnecessary cast from List to ArrayList\n----------\n6. WARNING in X.java (at line 10)\n\tObject o3 = (ArrayList) l;\n\t            ^^^^^^^^^^^^^\nUnnecessary cast from List to ArrayList\n----------\n7. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tint i = 12;\n\t\tint j = (byte) i;\n\t\tfloat f = (float) i;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tfloat f = (float) i;\n\t          ^^^^^^^^^\nUnnecessary cast from int to float\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n    class A extends X {\n        public void callMe() {\n        }\n    }\n    public abstract void callMe();\n    class B {\n        public void callSite() {\n            // expect warning not there:\n            ((A) this.getAA()).callMe();\n            Integer max = new Integer(1);\n            // execpted warning there:\n            Integer other = (Integer) max;\n        }\n        public X getAA() {\n            Zork z;\n            return null;\n        }\n    }\n}"}, "----------\n1. WARNING in X.java (at line 13)\n\tInteger other = (Integer) max;\n\t                ^^^^^^^^^^^^^\nUnnecessary cast from Integer to Integer\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\t\n\t}\n\t\n\tpublic static void foo(boolean b, List l) {\n\t\tif (b) {\n\t\t\tString s = (String) l.get(0);\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\t\n\t}\n\t\n\tpublic static void foo(boolean b, List l) {\n\t\tif (b) {\n\t\t\tObject o = (Object) l.get(0);\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static String s;\n    public static void main(String[] args) throws Throwable {\n      if (args.length == 0) {\n        Class c = Class.forName(\"X\");\n        String s = ((X) c.newInstance()).s;\n        System.out.println(s);\n      }\n      System.out.println();\n    }\n}"}, "null");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.future.compiler.regression.CastTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

