/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class ASTConverter15Test
extends ConverterTestSetup {
    IJavaScriptUnit workingCopy;
    static /* synthetic */ Class class$0;

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public ASTConverter15Test(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverter15Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTConverter15Test.buildModelTestSuite(clazz);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
            this.workingCopy = null;
        }
    }

    public void test0001() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0001", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        List types = compilationUnit.types();
        ASTConverter15Test.assertEquals((String)"Wrong number of types", (int)1, (int)types.size());
        AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)types.get(0);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)55, (int)typeDeclaration.getNodeType());
        TypeDeclaration typeDeclaration2 = (TypeDeclaration)typeDeclaration;
        List modifiers = typeDeclaration2.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)1, (int)modifiers.size());
        Modifier modifier = (Modifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "public", source);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        modifiers = fieldDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)3, (int)modifiers.size());
        modifier = (Modifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "public", source);
        modifier = (Modifier)modifiers.get(1);
        this.checkSourceRange((ASTNode)modifier, "static", source);
        modifier = (Modifier)modifiers.get(2);
        this.checkSourceRange((ASTNode)modifier, "final", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        modifiers = methodDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)2, (int)modifiers.size());
        modifier = (Modifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "private", source);
        modifier = (Modifier)modifiers.get(1);
        this.checkSourceRange((ASTNode)modifier, "static", source);
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong number of parameters", (int)1, (int)parameters.size());
        SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        modifiers = variableDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)1, (int)modifiers.size());
        modifier = (Modifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "final", source);
        node = this.getASTNode(compilationUnit, 0, 2);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)31, (int)node.getNodeType());
        methodDeclaration = (FunctionDeclaration)node;
        modifiers = methodDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)2, (int)modifiers.size());
        modifier = (Modifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "public", source);
        modifier = (Modifier)modifiers.get(1);
        this.checkSourceRange((ASTNode)modifier, "static", source);
    }

    public void test0002() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0002", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0007() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0007", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        List imports = compilationUnit.imports();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        this.checkSourceRange((ASTNode)importDeclaration, "import java.util.*;", source);
        ASTConverter15Test.assertFalse((String)"is static", (boolean)importDeclaration.isStatic());
        importDeclaration = (ImportDeclaration)imports.get(1);
        this.checkSourceRange((ASTNode)importDeclaration, "import static java.io.File.*;", source);
        ASTConverter15Test.assertTrue((String)"not static", (boolean)importDeclaration.isStatic());
    }

    public void test0008() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0008", "X.js");
        ASTNode result = this.runConversion(2, sourceUnit, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        List imports = compilationUnit.imports();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(1);
        ASTConverter15Test.assertTrue((String)"Not malformed", (boolean)this.isMalformed((ASTNode)importDeclaration));
    }

    public void test0009() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0009", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a foreach statement", (node.getNodeType() == 70 ? 1 : 0) != 0);
        EnhancedForStatement enhancedForStatement = (EnhancedForStatement)node;
        this.checkSourceRange((ASTNode)enhancedForStatement, "for (String s : args) {System.out.println(s);}", source);
        SingleVariableDeclaration singleVariableDeclaration = enhancedForStatement.getParameter();
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "String s", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", source);
        SimpleName simpleName = singleVariableDeclaration.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"s", (String)simpleName.getIdentifier());
        this.checkSourceRange((ASTNode)simpleName, "s", source);
        Expression expression = enhancedForStatement.getExpression();
        this.checkSourceRange((ASTNode)expression, "args", source);
        Statement body = enhancedForStatement.getBody();
        this.checkSourceRange((ASTNode)body, "{System.out.println(s);}", source);
    }

    public void test0010() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0010", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a foreach statement", (node.getNodeType() == 70 ? 1 : 0) != 0);
        EnhancedForStatement enhancedForStatement = (EnhancedForStatement)node;
        this.checkSourceRange((ASTNode)enhancedForStatement, "for (@Foo final String s : args) {System.out.println(s);}", source);
        SingleVariableDeclaration singleVariableDeclaration = enhancedForStatement.getParameter();
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "@Foo final String s", source);
        SimpleName simpleName = singleVariableDeclaration.getName();
        List modifiers = singleVariableDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)2, (int)modifiers.size());
        IExtendedModifier modifier = (IExtendedModifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "@Foo", source);
        modifier = (IExtendedModifier)modifiers.get(1);
        this.checkSourceRange((ASTNode)modifier, "final", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"s", (String)simpleName.getIdentifier());
        this.checkSourceRange((ASTNode)simpleName, "s", source);
        Expression expression = enhancedForStatement.getExpression();
        this.checkSourceRange((ASTNode)expression, "args", source);
        Statement body = enhancedForStatement.getBody();
        this.checkSourceRange((ASTNode)body, "{System.out.println(s);}", source);
    }

    public void test0011() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0011", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a foreach statement", (node.getNodeType() == 70 ? 1 : 0) != 0);
        EnhancedForStatement enhancedForStatement = (EnhancedForStatement)node;
        this.checkSourceRange((ASTNode)enhancedForStatement, "for (@Foo final String s[] : args) {System.out.println(s);}", source);
        SingleVariableDeclaration singleVariableDeclaration = enhancedForStatement.getParameter();
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "@Foo final String s[]", source);
        SimpleName simpleName = singleVariableDeclaration.getName();
        List modifiers = singleVariableDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)2, (int)modifiers.size());
        IExtendedModifier modifier = (IExtendedModifier)modifiers.get(0);
        this.checkSourceRange((ASTNode)modifier, "@Foo", source);
        modifier = (IExtendedModifier)modifiers.get(1);
        this.checkSourceRange((ASTNode)modifier, "final", source);
        ASTConverter15Test.assertEquals((String)"Wrong dimension", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"s", (String)simpleName.getIdentifier());
        this.checkSourceRange((ASTNode)simpleName, "s", source);
        Expression expression = enhancedForStatement.getExpression();
        this.checkSourceRange((ASTNode)expression, "args", source);
        Statement body = enhancedForStatement.getBody();
        this.checkSourceRange((ASTNode)body, "{System.out.println(s);}", source);
    }

    public void test0012() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0012", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0);
        ASTConverter15Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)parameter, "@Foo final String[][]... args", source);
        List modifiers = parameter.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong number of modifiers", (int)2, (int)modifiers.size());
        ASTNode modifier = (ASTNode)modifiers.get(0);
        this.checkSourceRange(modifier, "@Foo", source);
        modifier = (ASTNode)modifiers.get(1);
        this.checkSourceRange(modifier, "final", source);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"args", (String)parameter.getName().getIdentifier());
        ASTConverter15Test.assertTrue((String)"Not a variable argument", (boolean)parameter.isVarargs());
    }

    public void test0013() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0013", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Convertible", (String)name.getIdentifier());
        this.checkSourceRange((ASTNode)name, "Convertible", source);
        List typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        this.checkSourceRange((ASTNode)typeParameter, "T", source);
        this.checkSourceRange((ASTNode)typeParameter.getName(), "T", source);
        node = this.getASTNode(compilationUnit, 1);
        ASTConverter15Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        typeDeclaration = (TypeDeclaration)node;
        name = typeDeclaration.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"X", (String)name.getIdentifier());
        this.checkSourceRange((ASTNode)name, "X", source);
        typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)typeParameters.size());
        typeParameter = (TypeParameter)typeParameters.get(0);
        this.checkSourceRange((ASTNode)typeParameter.getName(), "A", source);
        this.checkSourceRange((ASTNode)typeParameter, "A extends Convertible<B>", source);
        typeParameter = (TypeParameter)typeParameters.get(1);
        this.checkSourceRange((ASTNode)typeParameter.getName(), "B", source);
        this.checkSourceRange((ASTNode)typeParameter, "B extends Convertible<A>", source);
        List typeBounds = typeParameter.typeBounds();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeBounds.size());
        Type typeBound = (Type)typeBounds.get(0);
        this.checkSourceRange((ASTNode)typeBound, "Convertible<A>", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)74, (int)typeBound.getNodeType());
        ParameterizedType parameterizedType = (ParameterizedType)typeBound;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "A", source);
    }

    public void test0014() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0014", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1);
        ASTConverter15Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"X", (String)name.getIdentifier());
        this.checkSourceRange((ASTNode)name, "X", source);
        List typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        this.checkSourceRange((ASTNode)typeParameter.getName(), "A", source);
        this.checkSourceRange((ASTNode)typeParameter, "A extends Convertible<Convertible<A>>", source);
        List typeBounds = typeParameter.typeBounds();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeBounds.size());
        Type typeBound = (Type)typeBounds.get(0);
        this.checkSourceRange((ASTNode)typeBound, "Convertible<Convertible<A>>", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)74, (int)typeBound.getNodeType());
        ParameterizedType parameterizedType = (ParameterizedType)typeBound;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "Convertible<A>", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)74, (int)typeArgument.getNodeType());
        parameterizedType = (ParameterizedType)typeArgument;
        typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "A", source);
    }

    public void test0015() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0015", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"X", (String)name.getIdentifier());
        this.checkSourceRange((ASTNode)name, "X", source);
        List typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        this.checkSourceRange((ASTNode)typeParameter.getName(), "A", source);
        this.checkSourceRange((ASTNode)typeParameter, "A extends Object & java.io.Serializable & Comparable<?>", source);
        List typeBounds = typeParameter.typeBounds();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)3, (int)typeBounds.size());
        Type typeBound = (Type)typeBounds.get(0);
        this.checkSourceRange((ASTNode)typeBound, "Object", source);
        typeBound = (Type)typeBounds.get(1);
        this.checkSourceRange((ASTNode)typeBound, "java.io.Serializable", source);
        typeBound = (Type)typeBounds.get(2);
        this.checkSourceRange((ASTNode)typeBound, "Comparable<?>", source);
    }

    public void test0016() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0016", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedProblems = "Pair is a raw type. References to generic type Pair<A,B> should be parameterized\nPair is a raw type. References to generic type Pair<A,B> should be parameterized";
        this.assertProblemsSize(compilationUnit, 2, expectedProblems);
        ASTNode node = this.getASTNode(compilationUnit, 0, 5);
        ASTConverter15Test.assertEquals((String)"Wrong first character", (char)'<', (char)source[node.getStartPosition()]);
    }

    public void test0017() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0017", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initializer = fragment.getInitializer();
        ASTConverter15Test.assertNotNull((String)"No initializer", (Object)initializer);
        ITypeBinding binding = initializer.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (type.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "Integer", source);
        Type innerType = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (innerType.getNodeType() == 75 ? 1 : 0) != 0);
        QualifiedType qualifiedType = (QualifiedType)innerType;
        this.checkSourceRange((ASTNode)qualifiedType.getName(), "B", source);
        Type qualifier = qualifiedType.getQualifier();
        this.checkSourceRange((ASTNode)qualifier, "test0017.A<String>", source);
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (qualifier.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType2 = (ParameterizedType)qualifier;
        typeArguments = parameterizedType2.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "String", source);
        innerType = parameterizedType2.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (innerType.getNodeType() == 43 ? 1 : 0) != 0);
        SimpleType simpleType = (SimpleType)innerType;
        this.checkSourceRange((ASTNode)simpleType, "test0017.A", source);
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (name.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName qualifiedName = (QualifiedName)name;
        this.checkSourceRange((ASTNode)qualifiedName.getQualifier(), "test0017", source);
        this.checkSourceRange((ASTNode)qualifiedName.getName(), "A", source);
    }

    public void test0018() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0018", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (type.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "Float", source);
        Type innerType = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (innerType.getNodeType() == 75 ? 1 : 0) != 0);
        QualifiedType qualifiedType = (QualifiedType)innerType;
        this.checkSourceRange((ASTNode)qualifiedType.getName(), "C", source);
        Type qualifier = qualifiedType.getQualifier();
        this.checkSourceRange((ASTNode)qualifier, "test0018.A<String>.B", source);
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (qualifier.getNodeType() == 75 ? 1 : 0) != 0);
        qualifiedType = (QualifiedType)qualifier;
        this.checkSourceRange((ASTNode)qualifiedType.getName(), "B", source);
        qualifier = qualifiedType.getQualifier();
        this.checkSourceRange((ASTNode)qualifier, "test0018.A<String>", source);
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (qualifier.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType2 = (ParameterizedType)qualifier;
        typeArguments = parameterizedType2.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "String", source);
        innerType = parameterizedType2.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (innerType.getNodeType() == 43 ? 1 : 0) != 0);
        SimpleType simpleType = (SimpleType)innerType;
        this.checkSourceRange((ASTNode)simpleType, "test0018.A", source);
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (name.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName qualifiedName = (QualifiedName)name;
        this.checkSourceRange((ASTNode)qualifiedName.getQualifier(), "test0018", source);
        this.checkSourceRange((ASTNode)qualifiedName.getName(), "A", source);
    }

    public void test0019() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0019", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (type.getNodeType() == 75 ? 1 : 0) != 0);
        QualifiedType qualifiedType = (QualifiedType)type;
        this.checkSourceRange((ASTNode)qualifiedType.getName(), "C", source);
        Type qualifier = qualifiedType.getQualifier();
        this.checkSourceRange((ASTNode)qualifier, "test0019.A<String>.B<Integer>", source);
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (qualifier.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)qualifier;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "Integer", source);
        Type innerType = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (innerType.getNodeType() == 75 ? 1 : 0) != 0);
        qualifiedType = (QualifiedType)innerType;
        this.checkSourceRange((ASTNode)qualifiedType.getName(), "B", source);
        qualifier = qualifiedType.getQualifier();
        this.checkSourceRange((ASTNode)qualifier, "test0019.A<String>", source);
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (qualifier.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType2 = (ParameterizedType)qualifier;
        typeArguments = parameterizedType2.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "String", source);
        innerType = parameterizedType2.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (innerType.getNodeType() == 43 ? 1 : 0) != 0);
        SimpleType simpleType = (SimpleType)innerType;
        this.checkSourceRange((ASTNode)simpleType, "test0019.A", source);
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (name.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName qualifiedName = (QualifiedName)name;
        this.checkSourceRange((ASTNode)qualifiedName.getQualifier(), "test0019", source);
        this.checkSourceRange((ASTNode)qualifiedName.getName(), "A", source);
    }

    public void test0020() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0020", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        List parameters = declaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (type.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "?", source);
    }

    public void test0021() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0021", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        List parameters = declaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (type.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "? extends E", source);
        ASTConverter15Test.assertTrue((String)"Not a wildcard type", (typeArgument.getNodeType() == 76 ? 1 : 0) != 0);
        WildcardType wildcardType = (WildcardType)typeArgument;
        Type bound = wildcardType.getBound();
        this.checkSourceRange((ASTNode)bound, "E", source);
        ASTConverter15Test.assertTrue((String)"Not an upper bound", (boolean)wildcardType.isUpperBound());
    }

    public void test0022() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0022", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        List parameters = declaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (type.getNodeType() == 74 ? 1 : 0) != 0);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "? super E", source);
        ASTConverter15Test.assertTrue((String)"Not a wildcard type", (typeArgument.getNodeType() == 76 ? 1 : 0) != 0);
        WildcardType wildcardType = (WildcardType)typeArgument;
        Type bound = wildcardType.getBound();
        this.checkSourceRange((ASTNode)bound, "E", source);
        ASTConverter15Test.assertFalse((String)"Is an upper bound", (boolean)wildcardType.isUpperBound());
    }

    public void test0023() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0023", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedProblems = "Pair is a raw type. References to generic type Pair<A,B> should be parameterized\nPair is a raw type. References to generic type Pair<A,B> should be parameterized";
        this.assertProblemsSize(compilationUnit, 2, expectedProblems);
        ASTNode node = this.getASTNode(compilationUnit, 0, 5);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"zip", (String)methodDeclaration.getName().getIdentifier());
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertNotNull((String)"No type parameters", (Object)typeParameters);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        this.checkSourceRange((ASTNode)typeParameter, "T", source);
    }

    public void test0024() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0024", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement declarationStatement = (VariableDeclarationStatement)node;
        List fragments = declarationStatement.fragments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a class instance creation", (int)14, (int)expression.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        List typeArguments = classInstanceCreation.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        Type type = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)type, "String", source);
    }

    public void test0025() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0025", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a constructor invocation", (int)17, (int)node.getNodeType());
        ConstructorInvocation constructorInvocation = (ConstructorInvocation)node;
        List typeArguments = constructorInvocation.typeArguments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeArguments.size());
        Type type = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)type, "E", source);
    }

    public void test0028() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0028", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        this.checkSourceRange((ASTNode)methodDeclaration.getName(), "foo", source);
        this.checkSourceRange((ASTNode)methodDeclaration, "void foo(String[] args) {\n    \tif (args.length < 2) {\n    \t\tSystem.out.println(\"Usage: X <double> <double>\");\n    \t\treturn;\n    \t}\n        double x = Double.parseDouble(args[0]);\n        double y = Double.parseDouble(args[1]);\n\n        for (X op : X.values())\n            System.out.println(x + \" \" + op + \" \" + y + \" = \" + op.eval(x, y));\n\t}", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        methodDeclaration = (FunctionDeclaration)node;
        this.checkSourceRange((ASTNode)methodDeclaration.getName(), "bar", source);
        this.checkSourceRange((ASTNode)methodDeclaration, "abstract double bar(double x, double y);", source);
    }

    public void test0029() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0029", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0030() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0030", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a constructor invocation", (int)17, (int)node.getNodeType());
        this.checkSourceRange(node, "<T>this();", source);
    }

    public void test0031() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0031", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0032() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0032", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List superInterfaces = typeDeclaration.superInterfaceTypes();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)superInterfaces.size());
        Type type = (Type)superInterfaces.get(0);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)74, (int)type.getNodeType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getType();
        this.checkSourceRange((ASTNode)type2, "C", source);
    }

    public void test0033() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0033", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0034() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0034", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0035() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0035", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0036() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0036", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        this.checkSourceRange((ASTNode)expressionStatement, "this.<T>foo();", source);
        Expression expression = expressionStatement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "this.<T>foo()", source);
        List typeArguments = methodInvocation.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
    }

    public void test0037() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0037", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = typeParameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = binding;
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"T", (String)typeBinding.getName());
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverter15Test.assertEquals((String)"Wrong key", (String)"Ltest0037/X;:TT;", (String)typeBinding.getKey());
        SimpleName simpleName = typeParameter.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"T", (String)simpleName.getIdentifier());
        IBinding binding2 = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding2.getKind());
        ITypeBinding typeBinding2 = (ITypeBinding)binding2;
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"T", (String)typeBinding2.getName());
        ITypeBinding typeBinding3 = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding3);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)typeBinding3.getKind());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"T", (String)typeBinding3.getName());
        typeParameter = (TypeParameter)typeParameters.get(1);
        binding = typeParameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        typeBinding = binding;
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"U", (String)typeBinding.getName());
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverter15Test.assertEquals((String)"Wrong key", (String)"Ltest0037/X;:TU;", (String)typeBinding.getKey());
        simpleName = typeParameter.getName();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"U", (String)simpleName.getIdentifier());
        binding2 = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding2.getKind());
        typeBinding2 = (ITypeBinding)binding2;
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"U", (String)typeBinding2.getName());
        typeBinding3 = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding3);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)typeBinding3.getKind());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"U", (String)typeBinding3.getName());
    }

    public void test0038() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0038", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        this.checkSourceRange((ASTNode)typeArgument, "T", source);
        ITypeBinding typeBinding = typeArgument.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"T", (String)typeBinding.getName());
        ITypeBinding[] typeParameters = typeBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeParameters.length);
        ASTConverter15Test.assertEquals((String)"Wrong isArray", (boolean)false, (boolean)typeBinding.isArray());
        ASTConverter15Test.assertEquals((String)"Wrong isAnnotation", (boolean)false, (boolean)typeBinding.isAnnotation());
        ASTConverter15Test.assertEquals((String)"Wrong isAnonymous", (boolean)false, (boolean)typeBinding.isAnonymous());
        ASTConverter15Test.assertEquals((String)"Wrong isClass", (boolean)false, (boolean)typeBinding.isClass());
        ASTConverter15Test.assertEquals((String)"Wrong isEnum", (boolean)false, (boolean)typeBinding.isEnum());
        ASTConverter15Test.assertEquals((String)"Wrong isInterface", (boolean)false, (boolean)typeBinding.isInterface());
        ASTConverter15Test.assertEquals((String)"Wrong isGenericType", (boolean)false, (boolean)typeBinding.isGenericType());
        ASTConverter15Test.assertEquals((String)"Wrong isLocal", (boolean)false, (boolean)typeBinding.isLocal());
        ASTConverter15Test.assertEquals((String)"Wrong isMember", (boolean)false, (boolean)typeBinding.isMember());
        ASTConverter15Test.assertEquals((String)"Wrong isNested", (boolean)false, (boolean)typeBinding.isNested());
        ASTConverter15Test.assertEquals((String)"Wrong isNullType", (boolean)false, (boolean)typeBinding.isNullType());
        ASTConverter15Test.assertEquals((String)"Wrong isParameterizedType", (boolean)false, (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertEquals((String)"Wrong isPrimitive", (boolean)false, (boolean)typeBinding.isPrimitive());
        ASTConverter15Test.assertEquals((String)"Wrong isRawType", (boolean)false, (boolean)typeBinding.isRawType());
        ASTConverter15Test.assertEquals((String)"Wrong isTopLevel", (boolean)false, (boolean)typeBinding.isTopLevel());
        ASTConverter15Test.assertEquals((String)"Wrong isUpperbound", (boolean)false, (boolean)typeBinding.isUpperbound());
        ASTConverter15Test.assertEquals((String)"Wrong isTypeVariable", (boolean)true, (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverter15Test.assertEquals((String)"Wrong isWildcardType", (boolean)false, (boolean)typeBinding.isWildcardType());
        ITypeBinding typeBinding2 = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"X<T>", (String)typeBinding2.getName());
        ASTConverter15Test.assertEquals((String)"Wrong isArray", (boolean)false, (boolean)typeBinding2.isArray());
        ASTConverter15Test.assertEquals((String)"Wrong isAnnotation", (boolean)false, (boolean)typeBinding2.isAnnotation());
        ASTConverter15Test.assertEquals((String)"Wrong isAnonymous", (boolean)false, (boolean)typeBinding2.isAnonymous());
        ASTConverter15Test.assertEquals((String)"Wrong isClass", (boolean)true, (boolean)typeBinding2.isClass());
        ASTConverter15Test.assertEquals((String)"Wrong isEnum", (boolean)false, (boolean)typeBinding2.isEnum());
        ASTConverter15Test.assertEquals((String)"Wrong isInterface", (boolean)false, (boolean)typeBinding2.isInterface());
        ASTConverter15Test.assertEquals((String)"Wrong isGenericType", (boolean)false, (boolean)typeBinding2.isGenericType());
        ASTConverter15Test.assertEquals((String)"Wrong isLocal", (boolean)false, (boolean)typeBinding2.isLocal());
        ASTConverter15Test.assertEquals((String)"Wrong isMember", (boolean)false, (boolean)typeBinding2.isMember());
        ASTConverter15Test.assertEquals((String)"Wrong isNested", (boolean)false, (boolean)typeBinding2.isNested());
        ASTConverter15Test.assertEquals((String)"Wrong isNullType", (boolean)false, (boolean)typeBinding2.isNullType());
        ASTConverter15Test.assertEquals((String)"Wrong isParameterizedType", (boolean)true, (boolean)typeBinding2.isParameterizedType());
        ASTConverter15Test.assertEquals((String)"Wrong isPrimitive", (boolean)false, (boolean)typeBinding2.isPrimitive());
        ASTConverter15Test.assertEquals((String)"Wrong isRawType", (boolean)false, (boolean)typeBinding2.isRawType());
        ASTConverter15Test.assertEquals((String)"Wrong isTopLevel", (boolean)true, (boolean)typeBinding2.isTopLevel());
        ASTConverter15Test.assertEquals((String)"Wrong isUpperbound", (boolean)false, (boolean)typeBinding2.isUpperbound());
        ASTConverter15Test.assertEquals((String)"Wrong isTypeVariable", (boolean)false, (boolean)typeBinding2.isTypeVariable());
        ASTConverter15Test.assertEquals((String)"Wrong isWildcardType", (boolean)false, (boolean)typeBinding2.isWildcardType());
        typeParameters = typeBinding2.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeParameters.length);
    }

    public void test0039() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0039", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0040() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0040", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        TypeParameter parameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = parameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"wrong key", (String)"Ltest0040/X;.foo<T:Ljava/lang/Object;>()TT;:TT;", (String)binding.getKey());
        Type returnType = methodDeclaration.getReturnType2();
        ITypeBinding binding2 = returnType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding2.getKind());
        ASTConverter15Test.assertEquals((String)"wrong key", (String)"Ltest0040/X;.foo<T:Ljava/lang/Object;>()TT;:TT;", (String)binding2.getKey());
    }

    public void test0041() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0041", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0042() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0042", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        TypeParameter parameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = parameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"wrong key", (String)"Ltest0042/X;.foo<T:Ljava/lang/Object;>()[TT;:TT;", (String)binding.getKey());
        Type returnType = methodDeclaration.getReturnType2();
        ITypeBinding binding2 = returnType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding2.getKind());
        ASTConverter15Test.assertEquals((String)"wrong key", (String)"[Ltest0042/X;.foo<T:Ljava/lang/Object;>()[TT;:TT;", (String)binding2.getKey());
    }

    public void test0043() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0043", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List typeParameters = typeDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = typeParameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = binding;
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"T", (String)typeBinding.getQualifiedName());
    }

    public void test0044() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0044", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        TypeParameter parameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = parameter.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"wrong key", (String)"Ltest0044/X;.foo<Z:Ljava/lang/Object;>(TZ;)V:TZ;", (String)binding.getKey());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"no binding", (Object)methodBinding);
        ASTConverter15Test.assertEquals((String)"Wrong isConstructor", (boolean)false, (boolean)methodBinding.isConstructor());
        ASTConverter15Test.assertEquals((String)"Wrong isDefaultConstructor", (boolean)false, (boolean)methodBinding.isDefaultConstructor());
        ASTConverter15Test.assertEquals((String)"Wrong isDeprecated", (boolean)false, (boolean)methodBinding.isDeprecated());
        ASTConverter15Test.assertEquals((String)"Wrong isGenericMethod", (boolean)true, (boolean)methodBinding.isGenericMethod());
        ASTConverter15Test.assertEquals((String)"Wrong isParameterizedMethod", (boolean)false, (boolean)methodBinding.isParameterizedMethod());
        ASTConverter15Test.assertEquals((String)"Wrong isRawMethod", (boolean)false, (boolean)methodBinding.isRawMethod());
        ASTConverter15Test.assertEquals((String)"Wrong isSynthetic", (boolean)false, (boolean)methodBinding.isSynthetic());
        ASTConverter15Test.assertEquals((String)"Wrong isVarargs", (boolean)false, (boolean)methodBinding.isVarargs());
        ITypeBinding[] typeParametersBindings = methodBinding.getTypeParameters();
        ASTConverter15Test.assertNotNull((String)"No type parameters", (Object)typeParametersBindings);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParametersBindings.length);
        ITypeBinding typeBinding = typeParametersBindings[0];
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverter15Test.assertEquals((String)"Wrong fully qualified name", (String)"Z", (String)typeBinding.getQualifiedName());
    }

    public void test0045() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0045", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a expression statement", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
        ASTConverter15Test.assertTrue((String)"Not parameterized", (boolean)methodBinding.isParameterizedMethod());
        ITypeBinding[] typeArguments = methodBinding.getTypeArguments();
        ASTConverter15Test.assertNotNull((String)"No type arguments", (Object)typeArguments);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.length);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String", (String)typeArguments[0].getQualifiedName());
        IFunctionBinding genericMethod = methodBinding.getMethodDeclaration();
        ASTConverter15Test.assertNotNull((String)"No generic method", (Object)genericMethod);
        ASTConverter15Test.assertFalse((String)"Not a parameterized method", (boolean)genericMethod.isParameterizedMethod());
    }

    public void test0046() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0046", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        Type superclassType = typeDeclaration.getSuperclassType();
        ITypeBinding typeBinding = superclassType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        String key1 = typeBinding.getKey();
        node = this.getASTNode(compilationUnit, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        String key2 = typeBinding.getKey();
        ASTConverter15Test.assertFalse((String)"Same keys", (boolean)key1.equals(key2));
    }

    public void test0047() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0047", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0050() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0050", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "Extended dimensions are illegal for a variable argument");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        ASTConverter15Test.assertTrue((String)"Not a varargs", (boolean)singleVariableDeclaration.isVarargs());
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ASTConverter15Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        this.checkSourceRange((ASTNode)arrayType.getComponentType(), "String", source);
        ASTConverter15Test.assertEquals((String)"Wrong extra dimensions", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
    }

    public void test0051() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0051", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a varargs", (boolean)methodBinding.isVarargs());
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        ASTConverter15Test.assertTrue((String)"Not a varargs", (boolean)singleVariableDeclaration.isVarargs());
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ASTConverter15Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        this.checkSourceRange((ASTNode)arrayType.getComponentType(), "String", source);
        ASTConverter15Test.assertEquals((String)"Wrong extra dimensions", (int)0, (int)singleVariableDeclaration.getExtraDimensions());
    }

    public void test0052() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0052", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0056() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0056", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "Zork1 cannot be resolved to a type");
    }

    public void test0058() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0058", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, false, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ASTConverter15Test.assertTrue((String)"Not public type declaration", (boolean)Modifier.isPublic((int)typeDeclaration.getModifiers()));
    }

    public void test0059() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0059", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0060() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\n/*start*/public class X {\n  <T> void foo(T t) {\n  }\n  <T extends X> void foo(T t) {\n  }\n  <T extends Class> void foo(T t) {\n  }\n  <T extends Exception & Runnable> void foo(T t) {\n  }\n}/*end*/", this.workingCopy, false);
        FunctionDeclaration[] methods = ((TypeDeclaration)node).getMethods();
        int length = methods.length;
        String[] keys = new String[length];
        int i = 0;
        while (i < length) {
            keys[i] = methods[i].resolveBinding().getKey();
            ++i;
        }
        this.assertBindingKeysEqual("Lp/X;.foo<T:Ljava/lang/Object;>(TT;)V\nLp/X;.foo<T:Lp/X;>(TT;)V\nLp/X;.foo<T:Ljava/lang/Class;>(TT;)V\nLp/X;.foo<T:Ljava/lang/Exception;:Ljava/lang/Runnable;>(TT;)V", keys);
    }

    public void test0061() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\n/*start*/public class X<T> {\n}/*end*/", this.workingCopy);
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        this.assertBindingKeyEquals("Lp/X<TT;>;", binding.getKey());
    }

    public void test0062() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X<T> {\n  /*start*/X<Class>/*end*/ f;\n}", this.workingCopy, false);
        ITypeBinding binding = ((Type)node).resolveBinding();
        this.assertBindingKeyEquals("Lp/X<Ljava/lang/Class<>;>;", binding.getKey());
    }

    public void test0063() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0063", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0063.X", (String)typeBinding.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)41, (int)node.getNodeType());
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        typeBinding = expression.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not parameterized", (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0063.X<java.lang.String>", (String)typeBinding.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration declaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = declaration.getType();
        typeBinding = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"java.util.List<? extends test0063.X<?>>", (String)typeBinding.getQualifiedName());
    }

    public void test0064() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0064", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0064.X", (String)typeBinding.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)41, (int)node.getNodeType());
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        typeBinding = expression.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not parameterized", (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0064.X<java.lang.String,java.lang.Integer>", (String)typeBinding.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration declaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = declaration.getType();
        typeBinding = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"java.util.List<? extends test0064.X<?,?>>", (String)typeBinding.getQualifiedName());
    }

    public void test0065() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0065", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0065.X", (String)typeBinding.getQualifiedName());
        ITypeBinding genericType = typeBinding.getTypeDeclaration();
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0065.X", (String)genericType.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)41, (int)node.getNodeType());
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        typeBinding = expression.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not parameterized", (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"test0065.X<java.lang.String,java.util.List<?>>", (String)typeBinding.getQualifiedName());
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration declaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = declaration.getType();
        typeBinding = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong qualified name", (String)"java.util.List<? extends test0065.X<?,?>>", (String)typeBinding.getQualifiedName());
    }

    public void test0066() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X<T> {\n  /*start*/X/*end*/ field;}", this.workingCopy, false);
        ITypeBinding binding = ((Type)node).resolveBinding();
        this.assertBindingKeyEquals("Lp/X<>;", binding.getKey());
    }

    public void test0067() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0067", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type type2 = (Type)typeArguments.get(0);
        ASTConverter15Test.assertTrue((String)"Not a wildcard type", (boolean)type2.isWildcardType());
        WildcardType wildcardType = (WildcardType)type2;
        ASTConverter15Test.assertTrue((String)"Not an upperbound type", (boolean)wildcardType.isUpperBound());
        ITypeBinding typeBinding = wildcardType.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not an upperbound type binding", (boolean)typeBinding.isUpperbound());
    }

    public void test0068() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0068", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type type2 = (Type)typeArguments.get(0);
        ASTConverter15Test.assertTrue((String)"Not a wildcard type", (boolean)type2.isWildcardType());
        WildcardType wildcardType = (WildcardType)type2;
        ASTConverter15Test.assertFalse((String)"An upperbound type", (boolean)wildcardType.isUpperBound());
        ITypeBinding typeBinding = wildcardType.resolveBinding();
        ASTConverter15Test.assertFalse((String)"An upperbound type binding", (boolean)typeBinding.isUpperbound());
    }

    public void test0069() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0069", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)parameterizedType.resolveBinding());
        Type type2 = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (boolean)type2.isQualifiedType());
        QualifiedType qualifiedType = (QualifiedType)type2;
        ITypeBinding typeBinding = qualifiedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 1", (String)"test0069.Outer<java.lang.String>.Inner<java.lang.Integer>", (String)typeBinding.getQualifiedName());
        SimpleName simpleName = qualifiedType.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)simpleName.resolveBinding());
        ASTConverter15Test.assertEquals((String)"Wrong name 2", (String)"test0069.Outer<java.lang.String>.Inner<java.lang.Integer>", (String)typeBinding.getQualifiedName());
        Type type3 = qualifiedType.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type3.isParameterizedType());
        ParameterizedType parameterizedType2 = (ParameterizedType)type3;
        typeBinding = parameterizedType2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 3", (String)"test0069.Outer<java.lang.String>", (String)typeBinding.getQualifiedName());
        Type type4 = parameterizedType2.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type4.isSimpleType());
        SimpleType simpleType = (SimpleType)type4;
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)simpleType.resolveBinding());
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (boolean)name.isQualifiedName());
        QualifiedName qualifiedName = (QualifiedName)name;
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)qualifiedName.resolveBinding());
        Name name2 = qualifiedName.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a simpleName", (boolean)name2.isSimpleName());
        SimpleName simpleName2 = (SimpleName)name2;
        binding = simpleName2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)1, (int)binding.getKind());
        SimpleName simpleName3 = qualifiedName.getName();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)simpleName3.resolveBinding());
    }

    public void test0070() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0070", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)parameterizedType.resolveBinding());
        Type type2 = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (boolean)type2.isQualifiedType());
        QualifiedType qualifiedType = (QualifiedType)type2;
        ITypeBinding typeBinding = qualifiedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 1", (String)"test0070.Outer<java.lang.String>.Inner<java.lang.Number>", (String)typeBinding.getQualifiedName());
        SimpleName simpleName = qualifiedType.getName();
        typeBinding = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 2", (String)"test0070.Outer<java.lang.String>.Inner<java.lang.Number>", (String)typeBinding.getQualifiedName());
        Type type3 = qualifiedType.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type3.isParameterizedType());
        ParameterizedType parameterizedType2 = (ParameterizedType)type3;
        typeBinding = parameterizedType2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 3", (String)"test0070.Outer<java.lang.String>", (String)typeBinding.getQualifiedName());
        Type type4 = parameterizedType2.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type4.isSimpleType());
        SimpleType simpleType = (SimpleType)type4;
        typeBinding = simpleType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 3", (String)"test0070.Outer<java.lang.String>", (String)typeBinding.getQualifiedName());
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a simpleName", (boolean)name.isSimpleName());
        SimpleName simpleName2 = (SimpleName)name;
        typeBinding = simpleName2.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name 3", (String)"test0070.Outer", (String)typeBinding.getQualifiedName());
    }

    public void test0071() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0071", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ITypeBinding[] typeBindings = methodBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeBindings.length);
        ITypeBinding typeBinding = typeBindings[0];
        IJavaScriptElement javaElement = typeBinding.getJavaElement();
        ASTConverter15Test.assertNotNull((String)"No java element", (Object)javaElement);
    }

    public void test0072() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0072", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverter15Test.assertEquals((String)"not a compilation unit", (int)15, (int)result.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)result;
        this.assertProblemsSize(unit, 0);
        unit.accept(new ASTVisitor(){

            public boolean visit(SingleVariableDeclaration node) {
                IVariableBinding binding = node.resolveBinding();
                ASTConverter15Test.assertNotNull((String)"No method", (Object)binding.getDeclaringMethod());
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                IVariableBinding binding = node.resolveBinding();
                ASTNode parent = node.getParent();
                if (parent != null && binding != null) {
                    IFunctionBinding declaringMethod = binding.getDeclaringMethod();
                    String variableBindingName = binding.getName();
                    switch (parent.getNodeType()) {
                        case 23: {
                            ASTConverter15Test.assertNull((String)"Got a method", (Object)declaringMethod);
                            break;
                        }
                        default: {
                            if (variableBindingName.equals("var1") || variableBindingName.equals("var2")) {
                                ASTConverter15Test.assertNull((String)"Got a method", (Object)declaringMethod);
                                break;
                            }
                            ASTConverter15Test.assertNotNull((String)"No method", (Object)declaringMethod);
                            String methodName = declaringMethod.getName();
                            if (variableBindingName.equals("var4")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"foo", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var5")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"foo2", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var7")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"foo3", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var8")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"X", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var9")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"bar3", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var10")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"bar3", (String)methodName);
                                break;
                            }
                            if (variableBindingName.equals("var11")) {
                                ASTConverter15Test.assertEquals((String)"Wrong method", (String)"bar3", (String)methodName);
                                break;
                            }
                            if (!variableBindingName.equals("var12")) break;
                            ASTConverter15Test.assertEquals((String)"Wrong method", (String)"X", (String)methodName);
                        }
                    }
                }
                return false;
            }

            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                ASTConverter15Test.assertNull((String)"No method", (Object)binding.getDeclaringMethod());
                return false;
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                ASTConverter15Test.assertNull((String)"No method", (Object)binding.getDeclaringMethod());
                return false;
            }
        });
    }

    public void test0073() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0073", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)type.resolveBinding());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        ITypeBinding binding = parameterizedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        Type type2 = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        ITypeBinding binding2 = type2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        SimpleType simpleType = (SimpleType)type2;
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a simpleName", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        ITypeBinding binding3 = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding3);
        ASTConverter15Test.assertTrue((String)"Different binding", (boolean)binding3.isEqualTo((IBinding)binding));
        ASTConverter15Test.assertTrue((String)"Different binding", (boolean)binding2.isEqualTo((IBinding)binding));
    }

    public void test0074() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0074", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)type.resolveBinding());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        ITypeBinding binding = type2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        SimpleType simpleType = (SimpleType)type2;
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (boolean)name.isQualifiedName());
        QualifiedName qualifiedName = (QualifiedName)name;
        SimpleName simpleName = qualifiedName.getName();
        ITypeBinding binding2 = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverter15Test.assertTrue((String)"Different binding", (boolean)binding2.isEqualTo((IBinding)binding));
        ASTConverter15Test.assertEquals((String)"wrong name", (String)"java.util.List<java.lang.String>", (String)binding2.getQualifiedName());
        Name name2 = qualifiedName.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (boolean)name2.isQualifiedName());
        QualifiedName qualifiedName2 = (QualifiedName)name2;
        IBinding binding3 = qualifiedName2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding3);
        ASTConverter15Test.assertEquals((String)"wrong kind", (int)1, (int)binding3.getKind());
        ASTConverter15Test.assertEquals((String)"wrong name2", (String)"java.util", (String)binding3.getName());
        simpleName = qualifiedName2.getName();
        binding3 = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding3);
        ASTConverter15Test.assertEquals((String)"wrong kind", (int)1, (int)binding3.getKind());
        ASTConverter15Test.assertEquals((String)"wrong name2", (String)"java.util", (String)binding3.getName());
        name2 = qualifiedName2.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a simple name", (boolean)name2.isSimpleName());
        simpleName = (SimpleName)name2;
        binding3 = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding3);
        ASTConverter15Test.assertEquals((String)"wrong kind", (int)1, (int)binding3.getKind());
        ASTConverter15Test.assertEquals((String)"wrong name2", (String)"java", (String)binding3.getName());
    }

    public void test0075() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\nimport java.util.ArrayList;\npublic class X {\n  /*start*/ArrayList<Integer>/*end*/ field;}", this.workingCopy);
        ITypeBinding binding = ((Type)node).resolveBinding();
        ITypeBinding genericType = binding.getTypeDeclaration();
        ASTConverter15Test.assertFalse((String)"Equals", (boolean)binding.isEqualTo((IBinding)genericType));
    }

    public void test0076() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0076", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedOutput = "Type mismatch: cannot convert from Map[] to Map<String,Double>[][]";
        this.assertProblemsSize(compilationUnit, 1, expectedOutput);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "Map<String, Double>[][]", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)5, (int)type.getNodeType());
        ArrayType arrayType = (ArrayType)type;
        type = arrayType.getComponentType();
        this.checkSourceRange((ASTNode)type, "Map<String, Double>[]", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)5, (int)type.getNodeType());
        arrayType = (ArrayType)type;
        type = arrayType.getComponentType();
        this.checkSourceRange((ASTNode)type, "Map<String, Double>", source);
    }

    public void test0077() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0077", "X.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedOutput = "Type mismatch: cannot convert from Map[] to Map<String,Double>[][]";
        this.assertProblemsSize(compilationUnit, 1, expectedOutput);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "java.util.Map<String, Double>[][]", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)5, (int)type.getNodeType());
        ArrayType arrayType = (ArrayType)type;
        type = arrayType.getComponentType();
        this.checkSourceRange((ASTNode)type, "java.util.Map<String, Double>[]", source);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)5, (int)type.getNodeType());
        arrayType = (ArrayType)type;
        type = arrayType.getComponentType();
        this.checkSourceRange((ASTNode)type, "java.util.Map<String, Double>", source);
    }

    public void test0078() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X<T> {\n  String foo(int i) { return /*start*/Integer.toString(i)/*end*/;}}", this.workingCopy);
        IFunctionBinding methodBinding = ((FunctionInvocation)node).resolveMethodBinding();
        ASTConverter15Test.assertFalse((String)"Is a raw method", (boolean)methodBinding.isRawMethod());
        ASTConverter15Test.assertFalse((String)"Is a parameterized method", (boolean)methodBinding.isParameterizedMethod());
        ASTConverter15Test.assertFalse((String)"Is a generic method", (boolean)methodBinding.isGenericMethod());
    }

    public void test0079() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X {\n\t\n\t/*start*/<T extends A> T foo(T t) {\n\t\treturn t;\n\t}/*end*/\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n\tvoid bar() {\n\t\tB b = foo(new B());\n\t}\n}\n\nclass A {}\nclass B extends A {}\n", this.workingCopy);
        IFunctionBinding methodBinding = ((FunctionDeclaration)node).resolveBinding();
        ASTConverter15Test.assertFalse((String)"Is a raw method", (boolean)methodBinding.isRawMethod());
        ASTConverter15Test.assertFalse((String)"Is a parameterized method", (boolean)methodBinding.isParameterizedMethod());
        ASTConverter15Test.assertTrue((String)"Not a generic method", (boolean)methodBinding.isGenericMethod());
    }

    public void test0080() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X {\n\t\n\t<T extends A> T foo(T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n\tvoid bar() {\n\t\tB b = /*start*/foo(new B())/*end*/;\n\t}\n}\n\nclass A {}\nclass B extends A {}\n", this.workingCopy);
        IFunctionBinding methodBinding = ((FunctionInvocation)node).resolveMethodBinding();
        ASTConverter15Test.assertFalse((String)"Is a raw method", (boolean)methodBinding.isRawMethod());
        ASTConverter15Test.assertTrue((String)"Not a parameterized method", (boolean)methodBinding.isParameterizedMethod());
        ASTConverter15Test.assertFalse((String)"Is a generic method", (boolean)methodBinding.isGenericMethod());
    }

    public void test0081() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0081", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedOutput = "Class is a raw type. References to generic type Class<T> should be parameterized\nClass is a raw type. References to generic type Class<T> should be parameterized\nType safety: The method foo(Object) belongs to the raw type Y. References to generic type Y<T> should be parameterized\nY is a raw type. References to generic type Y<T> should be parameterized";
        this.assertProblemsSize(compilationUnit, 4, expectedOutput);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not an method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"foo", (String)methodBinding.getName());
        ASTConverter15Test.assertTrue((String)"Not a raw method", (boolean)methodBinding.isRawMethod());
        ASTConverter15Test.assertFalse((String)"Is a parameterized method", (boolean)methodBinding.isParameterizedMethod());
        ASTConverter15Test.assertFalse((String)"Is a generic method", (boolean)methodBinding.isGenericMethod());
        ASTConverter15Test.assertFalse((String)"Doesn't override itself", (boolean)methodBinding.overrides(methodBinding));
    }

    public void test0082() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0082", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        String expectedOutput = "Gen is a raw type. References to generic type Gen<X> should be parameterized\nGen.Inn is a raw type. References to generic type Gen<X>.Inn should be parameterized";
        this.assertProblemsSize(compilationUnit, 2, expectedOutput);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Gen", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a generic type", (boolean)typeBinding.isGenericType());
        ASTConverter15Test.assertTrue((String)"Not a top level", (boolean)typeBinding.isTopLevel());
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a member type declaration", (int)55, (int)node.getNodeType());
        typeDeclaration = (TypeDeclaration)node;
        typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Inn", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen.Inn", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a member", (boolean)typeBinding.isMember());
        ASTConverter15Test.assertTrue((String)"Not a nested class", (boolean)typeBinding.isNested());
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        typeBinding = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Gen<String>", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen<java.lang.String>", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertTrue((String)"Not a toplevel", (boolean)typeBinding.isTopLevel());
        node = this.getASTNode(compilationUnit, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        typeBinding = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Inn", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen<java.lang.String>.Inn", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a member", (boolean)typeBinding.isMember());
        ASTConverter15Test.assertTrue((String)"Not a nested class", (boolean)typeBinding.isNested());
        ASTConverter15Test.assertFalse((String)"Is parameterized", (boolean)typeBinding.isParameterizedType());
        node = this.getASTNode(compilationUnit, 0, 3);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        typeBinding = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Gen", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a raw type", (boolean)typeBinding.isRawType());
        ASTConverter15Test.assertTrue((String)"Not a toplevel", (boolean)typeBinding.isTopLevel());
        node = this.getASTNode(compilationUnit, 0, 4);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        typeBinding = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Inn", (String)typeBinding.getName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0082.Gen.Inn", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertTrue((String)"Not a member", (boolean)typeBinding.isMember());
        ASTConverter15Test.assertTrue((String)"Not a nested type", (boolean)typeBinding.isNested());
        ASTConverter15Test.assertFalse((String)"Is parameterized", (boolean)typeBinding.isParameterizedType());
    }

    public void test0083() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0083", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding = fieldDeclaration.getType().resolveBinding();
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding2 = fieldDeclaration.getType().resolveBinding();
        node = this.getASTNode(compilationUnit, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding3 = fieldDeclaration.getType().resolveBinding();
        node = this.getASTNode(compilationUnit, 0, 3);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding4 = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding2));
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding3));
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding4));
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding2.isEqualTo((IBinding)typeBinding3));
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding2.isEqualTo((IBinding)typeBinding4));
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding3.isEqualTo((IBinding)typeBinding4));
    }

    public void test0084() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0084", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding = fieldDeclaration.getType().resolveBinding();
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        ITypeBinding typeBinding2 = fieldDeclaration.getType().resolveBinding();
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding2));
    }

    public void test0085() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0085", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        ITypeBinding binding = typeParameter.resolveBinding();
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = binding;
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        methodDeclaration = (FunctionDeclaration)node;
        typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeParameters.size());
        typeParameter = (TypeParameter)typeParameters.get(0);
        binding = typeParameter.resolveBinding();
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding2 = binding;
        ASTConverter15Test.assertFalse((String)"Binding are equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding2));
    }

    public void test0086() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X {\n\t\npublic Object foo() {\n\t\treturn /*start*/X.class/*end*/;\n\t}}\n\nclass A {}\nclass B extends A {}\n", this.workingCopy);
        TypeLiteral typeLiteral = (TypeLiteral)node;
        ITypeBinding typeBinding = typeLiteral.resolveTypeBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"java.lang.Class<p.X>", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"Class<X>", (String)typeBinding.getName());
    }

    public void test0087() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        this.buildAST("package p;\npublic class X<T1> {\n\tpublic <M1> X() {\n\t}\n\tclass Y<T2> {\n\t\tpublic <M2> Y() {\n\t\t}\n\t}\n\tvoid foo() {\n\t\tnew <Object>X<Object>().new <Object>Y<Object>();\n\t}\n}\n", this.workingCopy);
    }

    public void test0088() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0088", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"E", (String)typeBinding.getName());
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTNode node2 = compilationUnit.findDeclaringNode((IBinding)typeBinding);
        ASTConverter15Test.assertNotNull((String)"No declaring node", (Object)node2);
        ASTNode node3 = compilationUnit.findDeclaringNode(typeBinding.getKey());
        ASTConverter15Test.assertNotNull((String)"No declaring node", (Object)node3);
        ASTConverter15Test.assertTrue((String)"Nodes don't match", (boolean)node2.subtreeMatch(new ASTMatcher(), (Object)node3));
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List typeParameters = methodDeclaration.typeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.size());
        TypeParameter typeParameter = (TypeParameter)typeParameters.get(0);
        ASTConverter15Test.assertTrue((String)"Nodes don't match", (boolean)typeParameter.subtreeMatch(new ASTMatcher(), (Object)node3));
        ASTConverter15Test.assertTrue((String)"Nodes don't match", (boolean)typeParameter.subtreeMatch(new ASTMatcher(), (Object)node2));
    }

    public void test0089() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("package p;\npublic class X<T> {\n  void foo() {\n  }\n  void bar(X<?> x) {\n    /*start*/x.foo()/*end*/;\n  }\n}", this.workingCopy);
        IFunctionBinding binding = ((FunctionInvocation)node).resolveMethodBinding();
        this.assertBindingKeyEquals("Lp/X<!Lp/X;*75;>;.foo()V", binding.getKey());
    }

    public void test0090() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode result = this.buildAST("package p;\npublic class X {\n\tpublic void foo() {}\n\tpublic void bar(X x, int f) {\n\t\tx.foo();\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)result.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(SingleVariableDeclaration node) {
                IVariableBinding binding = node.resolveBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
                IJavaScriptElement javaElement = binding.getJavaElement();
                ASTConverter15Test.assertNotNull((String)"No java element", (Object)javaElement);
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                IVariableBinding binding = node.resolveBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
                IJavaScriptElement javaElement = binding.getJavaElement();
                ASTConverter15Test.assertNotNull((String)"No java element", (Object)javaElement);
                return false;
            }

            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
                IJavaScriptElement javaElement = binding.getJavaElement();
                ASTConverter15Test.assertNotNull((String)"No java element", (Object)javaElement);
                return false;
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
                IJavaScriptElement javaElement = binding.getJavaElement();
                ASTConverter15Test.assertNotNull((String)"No java element", (Object)javaElement);
                return false;
            }
        });
    }

    public void test0092() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        ASTNode node = this.buildAST("import java.util.*;\npublic class X {\n  public enum Rank { DEUCE, THREE, FOUR, FIVE, SIX,\n    SEVEN, EIGHT, NINE, TEN, JACK, QUEEN, KING, ACE }\n\n  //public enum Suit { CLUBS, DIAMONDS, HEARTS, SPADES }\n  public enum Suit{\n\n  private X(int rank, int suit) {  \n  }\n  \n  private static final List<X> protoDeck = new ArrayList<X>();\n  \n  public static ArrayList<X> newDeck() {\n      return new ArrayList<X>(protoDeck); // Return copy of prototype deck\n  }\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
    }

    public void test0093() throws JavaScriptModelException {
        String contents = "public class Test {\n    public <U> Test(U u) {\n    }\n\n    void bar() {\n        new <String> Test(null) {};\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/Test.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        this.checkSourceRange((ASTNode)expression, "new <String> Test(null) {}", contents.toCharArray());
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        IJavaScriptElement element = typeBinding.getJavaElement();
        ASTConverter15Test.assertNotNull((String)"No java element", (Object)element);
    }

    public void test0095() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n   /*start*/<T> void foo(NonExisting arg) {\n   }/*end*/\n}", this.workingCopy, false);
        IFunctionBinding binding = ((FunctionDeclaration)node).resolveBinding();
        ASTConverter15Test.assertEquals(null, (Object)binding);
    }

    public void test0098() throws JavaScriptModelException {
        String contents = "class X {\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List modifiers = typeDeclaration.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)modifiers.size());
    }

    public void test0101() throws JavaScriptModelException {
        String contents = "public class X{\n\tpublic void foo() {\n\t\tassert (true): (\"hello\");\n\t}\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an assert statement", (int)6, (int)node.getNodeType());
        AssertStatement assertStatement = (AssertStatement)node;
        char[] source = contents.toCharArray();
        this.checkSourceRange((ASTNode)assertStatement.getExpression(), "(true)", source);
        this.checkSourceRange((ASTNode)assertStatement.getMessage(), "(\"hello\")", source);
        this.checkSourceRange((ASTNode)assertStatement, "assert (true): (\"hello\");", source);
    }

    public void test0102() throws JavaScriptModelException {
        String contents = "import java.util.HashMap;\n\npublic class X {\n    Object o= new HashMap<?, ?>[0];\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)fragment, "o= new HashMap<?, ?>[0]", contents.toCharArray());
    }

    public void test0103() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0103", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        List imports = compilationUnit.imports();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        IBinding binding = importDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)3, (int)binding.getKind());
        Name name = importDeclaration.getName();
        binding = name.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)3, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)name.getNodeType());
        QualifiedName qualifiedName = (QualifiedName)name;
        SimpleName simpleName = qualifiedName.getName();
        binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)3, (int)binding.getKind());
        Name name2 = qualifiedName.getQualifier();
        binding = name2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)name2.getNodeType());
        qualifiedName = (QualifiedName)name2;
        simpleName = qualifiedName.getName();
        binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        Name name3 = qualifiedName.getQualifier();
        binding = name3.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)1, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a simple name", (int)42, (int)name3.getNodeType());
        importDeclaration = (ImportDeclaration)imports.get(1);
        binding = importDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertFalse((String)"Not a single name import", (boolean)importDeclaration.isOnDemand());
        name = importDeclaration.getName();
        binding = name.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)4, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)name.getNodeType());
        qualifiedName = (QualifiedName)name;
        simpleName = qualifiedName.getName();
        binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)4, (int)binding.getKind());
        name2 = qualifiedName.getQualifier();
        binding = name2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)name2.getNodeType());
        qualifiedName = (QualifiedName)name2;
        simpleName = qualifiedName.getName();
        binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        name2 = qualifiedName.getQualifier();
        binding = name2.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"Wrong type", (int)1, (int)binding.getKind());
        ASTConverter15Test.assertEquals((String)"Not a simple name", (int)42, (int)name2.getNodeType());
    }

    public void test0104() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0104", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        List imports = compilationUnit.imports();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        IBinding binding = importDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        int kind = binding.getKind();
        ASTConverter15Test.assertTrue((String)"Wrong type", (kind == 3 || kind == 4 ? 1 : 0) != 0);
    }

    public void test0110() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeDeclaration type = (TypeDeclaration)this.buildAST("/*start*/public class X {\n}/*end*/", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX;", (IBinding)binding);
    }

    public void test0111() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeDeclaration type = (TypeDeclaration)this.buildAST("/*start*/public class X<E> {\n}/*end*/", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0112() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  /*start*/X<String>/*end*/ field;\n}", this.workingCopy, false);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0113() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  /*start*/X/*end*/ field;\n}", this.workingCopy, false);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0114() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  X</*start*/? extends String/*end*/> field;\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX;+Ljava/lang/String;", (IBinding)binding);
    }

    public void test0115() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeParameter type = (TypeParameter)this.buildAST("public class X</*start*/E/*end*/> {\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getTypeDeclaration();
        this.assertBindingEquals("LX;:TE;", (IBinding)binding);
    }

    public void test0116() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeDeclaration type = (TypeDeclaration)this.buildAST("/*start*/public class X {\n}/*end*/", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("LX;", (IBinding)binding);
    }

    public void test0117() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeDeclaration type = (TypeDeclaration)this.buildAST("/*start*/public class X<E> {\n}/*end*/", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0118() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  /*start*/X<String>/*end*/ field;\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0119() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  /*start*/X/*end*/ field;\n}", this.workingCopy, false);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("LX<TE;>;", (IBinding)binding);
    }

    public void test0120() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  X</*start*/? extends String/*end*/> field;\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("Ljava/lang/String;", (IBinding)binding);
    }

    public void test0121() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        TypeParameter type = (TypeParameter)this.buildAST("public class X</*start*/E/*end*/> {\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding().getErasure();
        this.assertBindingEquals("Ljava/lang/Object;", (IBinding)binding);
    }

    public void test0122() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        FunctionDeclaration method = (FunctionDeclaration)this.buildAST("public class X {\n  /*start*/void foo() {\n  }/*end*/\n}", this.workingCopy);
        IFunctionBinding binding = method.resolveBinding().getMethodDeclaration();
        this.assertBindingEquals("LX;.foo()V", (IBinding)binding);
    }

    public void test0123() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        FunctionDeclaration method = (FunctionDeclaration)this.buildAST("public class X {\n  /*start*/<E> void foo() {\n  }/*end*/\n}", this.workingCopy);
        IFunctionBinding binding = method.resolveBinding().getMethodDeclaration();
        this.assertBindingEquals("LX;.foo<E:Ljava/lang/Object;>()V", (IBinding)binding);
    }

    public void test0124() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        FunctionInvocation method = (FunctionInvocation)this.buildAST("public class X {\n  <E> void foo() {\n  }\n  void bar() {\n    /*start*/this.<String>foo()/*end*/;\n  }\n}", this.workingCopy);
        IFunctionBinding binding = method.resolveMethodBinding().getMethodDeclaration();
        this.assertBindingEquals("LX;.foo<E:Ljava/lang/Object;>()V", (IBinding)binding);
    }

    public void test0125() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        FunctionInvocation method = (FunctionInvocation)this.buildAST("public class X {\n  <E> void foo() {\n  }\n  void bar() {\n    /*start*/this.foo()/*end*/;\n  }\n}", this.workingCopy);
        IFunctionBinding binding = method.resolveMethodBinding().getMethodDeclaration();
        this.assertBindingEquals("LX;.foo<E:Ljava/lang/Object;>()V", (IBinding)binding);
    }

    public void test0126() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        Type type = (Type)this.buildAST("public class X<E> {\n  /*start*/Class<? extends E>/*end*/ field;\n}", this.workingCopy);
        ITypeBinding binding = type.resolveBinding();
        this.assertBindingEquals("Ljava/lang/Class<Ljava/lang/Class;+LX;:TE;>;", (IBinding)binding);
    }

    public void test0127() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("class X<T> {\n    public void method(Number num) {}\n}\n\nclass Z {\n\tvoid test() {\n\t\tnew X<String>().method(0);\n\t\tnew X<Integer>().method(1);\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
        node = this.getASTNode(compilationUnit, 1, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        methodInvocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding2 = methodInvocation.resolveMethodBinding();
        ASTConverter15Test.assertFalse((String)"Keys are equals", (boolean)methodBinding.getKey().equals(methodBinding2.getKey()));
        ASTConverter15Test.assertFalse((String)"bindings are equals", (boolean)methodBinding.isEqualTo((IBinding)methodBinding2));
    }

    public void test0128() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        char[] source = "class X {\n\tstatic X x;\n\n\tstatic class G extends E {\n\t\tpublic G() {\n\t\t\tx.<String> super();\n\t\t}\n\t}\n\n\tclass E {\n\t\tpublic <T> E() {\n\t\t}\n\t}\n}".toCharArray();
        ASTNode node = this.buildAST("class X {\n\tstatic X x;\n\n\tstatic class G extends E {\n\t\tpublic G() {\n\t\t\tx.<String> super();\n\t\t}\n\t}\n\n\tclass E {\n\t\tpublic <T> E() {\n\t\t}\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverter15Test.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block body = methodDeclaration.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)body);
        List statements = body.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not a super constructor invocation", (int)46, (int)statement.getNodeType());
        SuperConstructorInvocation constructorInvocation = (SuperConstructorInvocation)statement;
        this.checkSourceRange((ASTNode)constructorInvocation, "x.<String> super();", source);
    }

    public void test0129() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        char[] source = "class X {\n\tstatic X x;\n\tstatic class G extends E {\n\t\tpublic <T> G() {\n\t\t\tx.<String> this();\n\t\t}\n\t}\n\tstatic class E {\n\t\tpublic <T> E() {\n\t\t}\n\t}\n}".toCharArray();
        ASTNode node = this.buildAST("class X {\n\tstatic X x;\n\tstatic class G extends E {\n\t\tpublic <T> G() {\n\t\t\tx.<String> this();\n\t\t}\n\t}\n\tstatic class E {\n\t\tpublic <T> E() {\n\t\t}\n\t}\n}", this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        String expectedProblem = "Illegal enclosing instance specification for type X.G";
        this.assertProblemsSize(compilationUnit, 1, expectedProblem);
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverter15Test.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block body = methodDeclaration.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)body);
        List statements = body.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not a constructor invocation", (int)17, (int)statement.getNodeType());
        ConstructorInvocation constructorInvocation = (ConstructorInvocation)statement;
        this.checkSourceRange((ASTNode)constructorInvocation, "x.<String> this();", source);
        ASTConverter15Test.assertTrue((String)"Node is not malformed", (boolean)this.isMalformed((ASTNode)constructorInvocation));
    }

    public void test0130() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("class Outer<A> {\n\tclass Inner {\n\t\tclass InnerInner<C> {\n\t\t}\n\t}\n}\n\npublic class X {\n\tvoid foo() {\n\t\tOuter<String>.Inner.InnerInner<Integer> in = new Outer<String>().new Inner(). new InnerInner<Integer>();\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        ITypeBinding typeBinding = parameterizedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 1", (String)"Outer<java.lang.String>.Inner.InnerInner<java.lang.Integer>", (String)typeBinding.getQualifiedName());
        type = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (boolean)type.isQualifiedType());
        QualifiedType qualifiedType = (QualifiedType)type;
        typeBinding = qualifiedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 2", (String)"Outer<java.lang.String>.Inner.InnerInner<java.lang.Integer>", (String)typeBinding.getQualifiedName());
        SimpleName simpleName = qualifiedType.getName();
        typeBinding = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 3", (String)"Outer<java.lang.String>.Inner.InnerInner<java.lang.Integer>", (String)typeBinding.getQualifiedName());
        type = qualifiedType.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a qualified type", (boolean)type.isQualifiedType());
        qualifiedType = (QualifiedType)type;
        typeBinding = qualifiedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 4", (String)"Outer<java.lang.String>.Inner", (String)typeBinding.getQualifiedName());
        simpleName = qualifiedType.getName();
        typeBinding = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 5", (String)"Outer.Inner", (String)typeBinding.getQualifiedName());
        type = qualifiedType.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        parameterizedType = (ParameterizedType)type;
        typeBinding = parameterizedType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 6", (String)"Outer<java.lang.String>", (String)typeBinding.getQualifiedName());
        type = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        typeBinding = simpleType.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 7", (String)"Outer<java.lang.String>", (String)typeBinding.getQualifiedName());
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a simple name", (boolean)name.isSimpleName());
        simpleName = (SimpleName)name;
        typeBinding = simpleName.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertEquals((String)"Wrong qualified name 8", (String)"Outer", (String)typeBinding.getQualifiedName());
    }

    public void test0131() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic void bar(String... args){\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        ASTConverter15Test.assertTrue((String)"Not a var args", (boolean)singleVariableDeclaration.isVarargs());
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", contents);
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        this.checkSourceRange((ASTNode)type, "String", contents);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertFalse((String)"An array", (boolean)typeBinding.isArray());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        ITypeBinding parameterType = parameterTypes[0];
        ASTConverter15Test.assertTrue((String)"Not an array binding", (boolean)parameterType.isArray());
        ASTConverter15Test.assertTrue((String)"Not equals", (parameterType.getComponentType() == parameterType.getElementType() ? 1 : 0) != 0);
        ASTConverter15Test.assertEquals((String)"wrong dimension", (int)1, (int)parameterType.getDimensions());
    }

    public void test0132() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic void bar(String[]... args[]){\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 1, "Extended dimensions are illegal for a variable argument");
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        ASTConverter15Test.assertTrue((String)"Not a var args", (boolean)singleVariableDeclaration.isVarargs());
        ASTConverter15Test.assertTrue((String)"Not a malformed node", (boolean)this.isMalformed((ASTNode)singleVariableDeclaration));
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", contents);
        ASTConverter15Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertTrue((String)"Not an array", (boolean)typeBinding.isArray());
        ASTConverter15Test.assertEquals((String)"wrong dimensions", (int)1, (int)typeBinding.getDimensions());
        ArrayType arrayType = (ArrayType)type;
        ASTConverter15Test.assertEquals((String)"Wrong dimension", (int)1, (int)arrayType.getDimensions());
        type = arrayType.getComponentType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        this.checkSourceRange((ASTNode)type, "String", contents);
        ASTConverter15Test.assertEquals((String)"Wrong extra dimension", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        ITypeBinding parameterType = parameterTypes[0];
        ASTConverter15Test.assertTrue((String)"Not an array binding", (boolean)parameterType.isArray());
        ASTConverter15Test.assertEquals((String)"wrong dimension", (int)3, (int)parameterType.getDimensions());
        ITypeBinding componentType = parameterType.getComponentType();
        ASTConverter15Test.assertEquals((String)"wrong dimension", (int)2, (int)componentType.getDimensions());
        ASTConverter15Test.assertTrue((String)"Not equal", (parameterType.getElementType() == componentType.getElementType() ? 1 : 0) != 0);
        ITypeBinding componentType2 = componentType.getComponentType();
        ASTConverter15Test.assertEquals((String)"wrong dimension", (int)1, (int)componentType2.getDimensions());
        ASTConverter15Test.assertTrue((String)"Not equal", (parameterType.getElementType() == componentType2.getElementType() ? 1 : 0) != 0);
    }

    public void test0133() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.Vector;\n\npublic class X {\n  void k() {\n    Vector v2 = /*start*/new Vector()/*end*/;\n    Vector v3 = new Vector();\n\n    v3.add(\"fff\");\n    v2.add(v3);\n   }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a class instance creation unit", (int)14, (int)node.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
        ITypeBinding typeBinding = classInstanceCreation.resolveTypeBinding();
        ASTConverter15Test.assertEquals((String)"wrong qualified name", (String)"java.util.Vector", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a raw type", (boolean)typeBinding.isRawType());
        ASTConverter15Test.assertFalse((String)"From source", (boolean)typeBinding.isFromSource());
    }

    public void test0134() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.Vector;\n\npublic class X {\n  void k() {\n    Vector v2 = /*start*/new Vector<String>()/*end*/;\n\n    v2.add(\"\");\n   }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a class instance creation unit", (int)14, (int)node.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
        ITypeBinding typeBinding = classInstanceCreation.resolveTypeBinding();
        ASTConverter15Test.assertEquals((String)"wrong qualified name", (String)"java.util.Vector<java.lang.String>", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)typeBinding.isParameterizedType());
        ASTConverter15Test.assertFalse((String)"From source", (boolean)typeBinding.isFromSource());
    }

    public void test0135() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class X {\n\tpublic static X instance= new X();\n\n\tint s;\n\n\tint f() {\n\t\tSystem.out.println(X.instance.s + 1);\n\t\treturn 1;\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                ITypeBinding typeBinding = qualifiedName.resolveTypeBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
                return true;
            }
        });
    }

    public void test0136() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class X {\n\tpublic static X instance= new X();\n\tpublic X instance2 = new X();\n\tint s;\n\tint f() {\n\t\tSystem.out.println(X.instance.instance2.s + 1);\n\t\treturn 1;\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                ITypeBinding typeBinding = qualifiedName.resolveTypeBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
                return true;
            }
        });
    }

    public void test0137() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0137", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        type = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (boolean)name.isQualifiedName());
        QualifiedName qualifiedName = (QualifiedName)name;
        name = qualifiedName.getQualifier();
        ASTConverter15Test.assertTrue((String)"Not a simple name", (boolean)name.isSimpleName());
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"test0137.Source", (String)typeBinding.getQualifiedName());
    }

    public void test0138() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("class X {\n\tjava.util.List<URL> method(java.util.List<URL> list) {\n\t\tjava.util.List<URL> url= new java.util.List<URL>();\n\t\treturn url;\n\t}\n}", this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 4, "URL cannot be resolved to a type\nURL cannot be resolved to a type\nURL cannot be resolved to a type\nURL cannot be resolved to a type");
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(ParameterizedType type) {
                ASTConverter15Test.this.checkSourceRange((ASTNode)type, "java.util.List<URL>", "class X {\n\tjava.util.List<URL> method(java.util.List<URL> list) {\n\t\tjava.util.List<URL> url= new java.util.List<URL>();\n\t\treturn url;\n\t}\n}");
                ITypeBinding typeBinding = type.resolveBinding();
                ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
                return true;
            }
        });
    }

    public void test0139() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0139", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, false);
        ASTConverter15Test.assertNotNull((Object)result);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "The type test0139a.C is not visible");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Wrong node", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isParameterizedType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        type = parameterizedType.getType();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverter15Test.assertTrue((String)"Not a qualified name", (boolean)name.isQualifiedName());
        QualifiedName qualifiedName = (QualifiedName)name;
        IBinding binding = qualifiedName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = (ITypeBinding)binding;
        ASTConverter15Test.assertEquals((String)"wrong qualified name", (String)"test0139a.C", (String)typeBinding.getQualifiedName());
        SimpleName simpleName = qualifiedName.getName();
        binding = simpleName.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        typeBinding = (ITypeBinding)binding;
        ASTConverter15Test.assertEquals((String)"wrong qualified name", (String)"test0139a.C", (String)typeBinding.getQualifiedName());
        name = qualifiedName.getQualifier();
        ASTConverter15Test.assertEquals((String)"Not a simpleName", (int)42, (int)name.getNodeType());
        binding = name.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverter15Test.assertEquals((String)"wrong type", (int)1, (int)binding.getKind());
        IPackageBinding packageBinding = (IPackageBinding)binding;
        ASTConverter15Test.assertEquals((String)"wrong name", (String)"test0139a", (String)packageBinding.getName());
    }

    public void test0141() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X<T> {\n\tint x;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X<String>().x);\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverter15Test.assertFalse((String)"Not a parameter", (boolean)variableBinding.isParameter());
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)arguments.size());
        Expression expression2 = (Expression)arguments.get(0);
        ASTConverter15Test.assertEquals((String)"Not a field access", (int)22, (int)expression2.getNodeType());
        FieldAccess fieldAccess = (FieldAccess)expression2;
        IVariableBinding variableBinding2 = fieldAccess.resolveFieldBinding();
        ASTConverter15Test.assertFalse((String)"Not a parameter", (boolean)variableBinding2.isParameter());
        ASTConverter15Test.assertFalse((String)"Bindings are not equals", (boolean)variableBinding.isEqualTo((IBinding)variableBinding2));
        IVariableBinding variableBinding3 = variableBinding2.getVariableDeclaration();
        ASTConverter15Test.assertTrue((String)"Bindings are equals", (boolean)variableBinding.isEqualTo((IBinding)variableBinding3));
        node = compilationUnit.findDeclaringNode((IBinding)variableBinding2);
        ASTConverter15Test.assertNotNull((String)"No declaring node", (Object)node);
    }

    public void test0142() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tint x = 0;\n\t\tSystem.out.println(x);\n\t}\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"x", (String)fragment.getName().getIdentifier());
        IVariableBinding variableBinding = fragment.resolveBinding();
        IVariableBinding variableBinding2 = variableBinding.getVariableDeclaration();
        ASTConverter15Test.assertFalse((String)"Not a parameter", (boolean)variableBinding.isParameter());
        ASTConverter15Test.assertFalse((String)"Not a parameter", (boolean)variableBinding2.isParameter());
        ASTConverter15Test.assertTrue((String)"Bindings are equals", (boolean)variableBinding.isEqualTo((IBinding)variableBinding2));
    }

    public void test0143() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic void bar(String[]... args){\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        ASTConverter15Test.assertTrue((String)"Not a var args", (boolean)singleVariableDeclaration.isVarargs());
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", contents);
        ASTConverter15Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertTrue((String)"Not an array", (boolean)typeBinding.isArray());
        ASTConverter15Test.assertEquals((String)"wrong dimensions", (int)1, (int)typeBinding.getDimensions());
        ArrayType arrayType = (ArrayType)type;
        ASTConverter15Test.assertEquals((String)"Wrong dimension", (int)1, (int)arrayType.getDimensions());
        type = arrayType.getComponentType();
        ASTConverter15Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        this.checkSourceRange((ASTNode)type, "String", contents);
        ASTConverter15Test.assertEquals((String)"Wrong extra dimension", (int)0, (int)singleVariableDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        ITypeBinding parameterType = parameterTypes[0];
        ASTConverter15Test.assertTrue((String)"Not an array binding", (boolean)parameterType.isArray());
        ASTConverter15Test.assertEquals((String)"wrong dimension", (int)2, (int)parameterType.getDimensions());
    }

    public void test0144() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T> {\n\tvoid foo(T t) {\n\t\tSystem.out.println(t);\n\t}\n}\n\nclass Use {\n\tpublic static void main(String[] args) {\n\t\tX<String> i= null;\n\t\ti.foo(\"Eclipse\");\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 1, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
        node = compilationUnit.findDeclaringNode((IBinding)methodBinding);
        ASTConverter15Test.assertNotNull((String)"No declaring node", (Object)node);
    }

    public void test0145() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public enum X {\n    RED, GREEN(), BLUE(17), PINK(1) {/*anon*};\n    Color() {}\n    Color(int i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        String expectedErrors = "The constructor X(int) is undefined\nThe constructor X(int) is undefined\nUnexpected end of comment";
        this.assertProblemsSize(compilationUnit, 3, expectedErrors);
    }

    public void test0146() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.Iterator;\npublic class X {\n    void doit() {\n\t\t\tIterator iter= (Iterator) null;\n\t\t\tSystem.out.println(iter);\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        String expectedProblems = "Iterator is a raw type. References to generic type Iterator<E> should be parameterized\nIterator is a raw type. References to generic type Iterator<E> should be parameterized";
        this.assertProblemsSize(compilationUnit, 2, expectedProblems);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertNotNull((String)"No initializer", (Object)expression);
        ASTConverter15Test.assertEquals((String)"Not a cast expression", (int)11, (int)expression.getNodeType());
        CastExpression castExpression = (CastExpression)expression;
        Type type = castExpression.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Wrong type", (String)"java.util.Iterator", (String)typeBinding.getQualifiedName());
        ASTConverter15Test.assertTrue((String)"Not a raw type", (boolean)typeBinding.isRawType());
        ASTConverter15Test.assertFalse((String)"Is a generic type", (boolean)typeBinding.isGenericType());
        ASTConverter15Test.assertFalse((String)"Is a parameterized type", (boolean)typeBinding.isParameterizedType());
    }

    public void test0147() throws CoreException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0147", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0152() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static final int CONST1 = 1;\n\tpublic static final int CONST2 = 2;\n\tpublic static void main(String[] args) {\n\t\tint[] intTab = new int[] {2, 3};\n\t\tfor (int i : intTab) {\n\t\t\tswitch(i) {\n\t\t\t\tcase CONST1 :\n\t\t\t\t\tSystem.out.println(\"1\");\n\t\t\t\t\tbreak;\n\t\t\t\tcase CONST2 :\n\t\t\t\t\tSystem.out.println(\"2\");\n\t\t\t\t\tbreak;\n\t\t\t\tdefault :\n\t\t\t\t\tSystem.out.println(\"default\");\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n   }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)3, (int)bodyDeclarations.size());
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(2);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)bodyDeclaration.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
        Block block = methodDeclaration.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)block);
        List statements = block.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)statements.size());
        Statement statement = (Statement)statements.get(1);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)statement.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)statement;
        Statement statement2 = forStatement.getBody();
        ASTConverter15Test.assertEquals((String)"Not a block", (int)8, (int)statement2.getNodeType());
        Block block2 = (Block)statement2;
        statements = block2.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not a switch statement", (int)50, (int)statement.getNodeType());
        SwitchStatement switchStatement = (SwitchStatement)statement;
        statements = switchStatement.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)9, (int)statements.size());
        statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not a switch case statement", (int)49, (int)statement.getNodeType());
        SwitchCase switchCase = (SwitchCase)statement;
        Expression expression = switchCase.getExpression();
        Object constant = expression.resolveConstantExpressionValue();
        ASTConverter15Test.assertNotNull((String)"No constant", (Object)constant);
        ASTConverter15Test.assertEquals((String)"Wrong value", (String)"1", (String)String.valueOf(constant));
    }

    public void test0153() throws CoreException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0153", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0154() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(/*start*/1/*end*/);\n\t}\n\tpublic static void test(Integer i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a number literal", (int)34, (int)node.getNodeType());
        NumberLiteral literal = (NumberLiteral)node;
        ASTConverter15Test.assertTrue((String)"Not boxed", (boolean)literal.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)literal.resolveUnboxing());
    }

    public void test0155() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static int bar() {return 1;}\n\tpublic static void main(String[] s) {\n\t\ttest(/*start*/bar()/*end*/);\n\t}\n\tpublic static void test(Integer i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)node.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)node;
        ASTConverter15Test.assertTrue((String)"Not boxed", (boolean)methodInvocation.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)methodInvocation.resolveUnboxing());
    }

    public void test0156() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(/*start*/new Integer(1)/*end*/);\n\t}\n\tpublic static void test(int i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a class instance creation", (int)14, (int)node.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)classInstanceCreation.resolveBoxing());
        ASTConverter15Test.assertTrue((String)"Not unboxed", (boolean)classInstanceCreation.resolveUnboxing());
    }

    public void test0157() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(/*start*/null/*end*/);\n\t}\n\tpublic static void test(Object o) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a null literal", (int)33, (int)node.getNodeType());
        NullLiteral nullLiteral = (NullLiteral)node;
        ASTConverter15Test.assertNull((String)"Got a constant", (Object)nullLiteral.resolveConstantExpressionValue());
    }

    public void test0158() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tprivate static final String CONST = \"Hello World\";\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(/*start*/CONST/*end*/);\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a simple name", (int)42, (int)node.getNodeType());
        SimpleName name = (SimpleName)node;
        ASTConverter15Test.assertNotNull((String)"No constant", (Object)name.resolveConstantExpressionValue());
    }

    public void test0159() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(/*start*/new Integer(1)/*end*/);\n\t}\n\tpublic static void test(Integer i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a class instance creation", (int)14, (int)node.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)classInstanceCreation.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)classInstanceCreation.resolveUnboxing());
    }

    public void test0160() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.test(1, new Integer(2), -3);\n\t}\n}\nclass Y {\n\tpublic static void test(int ... i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)3, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
        argument = (Expression)arguments.get(1);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertTrue((String)"Not unboxed", (boolean)argument.resolveUnboxing());
        argument = (Expression)arguments.get(2);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
    }

    public void test0161() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(new Integer(1), 1);\n\t\tnew Y().test(1, new Integer(1));\n\t}\n}\nclass Y {\n\tvoid test(Integer i, int j) { System.out.print(1); }\n\tvoid test(int i, Integer j) { System.out.print(2); }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
        argument = (Expression)arguments.get(1);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
        this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        expressionStatement = (ExpressionStatement)node;
        expression = expressionStatement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not method invocation", (int)32, (int)expression.getNodeType());
        methodInvocation = (FunctionInvocation)expression;
        arguments = methodInvocation.arguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)arguments.size());
        argument = (Expression)arguments.get(0);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
        argument = (Expression)arguments.get(1);
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)argument.resolveBoxing());
        ASTConverter15Test.assertFalse((String)"Is unboxed", (boolean)argument.resolveUnboxing());
    }

    public void test0162() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tpublic static void main(String[] s) {\n\t\tint i = Y.test();\n\t\tSystem.out.print(i);\n\t}\n}\nclass Y {\n\tpublic static Byte test() { return new Byte((byte) 1); }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertFalse((String)"Is boxed", (boolean)expression.resolveBoxing());
        ASTConverter15Test.assertTrue((String)"Not unboxed", (boolean)expression.resolveUnboxing());
    }

    public void test0163() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T>{\n  void f(T t){}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        ASTConverter15Test.assertNotNull((String)"No declaring class", (Object)declaringClass);
        ASTConverter15Test.assertTrue((String)"Not a generic class", (boolean)declaringClass.isGenericType());
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"X", (String)declaringClass.getName());
    }

    public void test0164() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class X {\n  <U> void foo(U u) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        Type type = singleVariableDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        IFunctionBinding methodBinding = typeBinding.getDeclaringMethod();
        ASTConverter15Test.assertNotNull((String)"No declaring method", (Object)methodBinding);
        ASTConverter15Test.assertEquals((String)"Wrong name", (String)"foo", (String)methodBinding.getName());
        ASTConverter15Test.assertTrue((String)"Not a generic method", (boolean)methodBinding.isGenericMethod());
    }

    public void test0165() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class X {\n   <U> void foo(U u) {\n\t\tclass C {}\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration statement", (int)56, (int)node.getNodeType());
        TypeDeclarationStatement statement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDeclaration = statement.getDeclaration();
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertTrue((String)"Not a local type", (boolean)typeBinding.isLocal());
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        ASTConverter15Test.assertNotNull((String)"No declaring class", (Object)declaringClass);
        IFunctionBinding declaringMethod = typeBinding.getDeclaringMethod();
        ASTConverter15Test.assertNotNull((String)"No declaring method", (Object)declaringMethod);
    }

    public void test0166() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class X {\n   {\n\t\tclass C {}\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration statement", (int)56, (int)node.getNodeType());
        TypeDeclarationStatement statement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDeclaration = statement.getDeclaration();
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertTrue((String)"Not a local type", (boolean)typeBinding.isLocal());
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        ASTConverter15Test.assertNotNull((String)"No declaring class", (Object)declaringClass);
        IFunctionBinding declaringMethod = typeBinding.getDeclaringMethod();
        ASTConverter15Test.assertNull((String)"No declaring method", (Object)declaringMethod);
    }

    public void test0167() throws CoreException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0167", "X.js");
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
        ASTNode node = this.getASTNode(compilationUnit, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)4, (int)parameters.size());
        SingleVariableDeclaration param = (SingleVariableDeclaration)parameters.get(3);
        Type t = param.getType();
        String typeName = ((SimpleType)t).getName().getFullyQualifiedName();
        IType[] types = sourceUnit.getTypes();
        ASTConverter15Test.assertEquals((String)"wrong size", (int)2, (int)types.length);
        IType mainType = types[1];
        String[][] typeMatches = mainType.resolveType(typeName);
        ASTConverter15Test.assertNotNull((Object)typeMatches);
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)typeMatches.length);
        String[] typesNames = typeMatches[0];
        ASTConverter15Test.assertEquals((String)"wrong size", (int)2, (int)typesNames.length);
        ASTConverter15Test.assertEquals((String)"Wrong part 1", (String)"java.lang", (String)typesNames[0]);
        ASTConverter15Test.assertEquals((String)"Wrong part 2", (String)"Object", (String)typesNames[1]);
    }

    public void test0168() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.List;\npublic class X {\n\tvoid f() {\n\t\tList<?> list = null;\n\t\tSystem.out.println(list);\n    }\n}", this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ITypeBinding typeBinding = argument.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverter15Test.assertTrue((String)"Not a parameterized binding", (boolean)typeBinding.isParameterizedType());
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.length);
        ITypeBinding typeBinding2 = typeArguments[0];
        ASTConverter15Test.assertTrue((String)"Not a capture binding", (boolean)typeBinding2.isCapture());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding2.isFromSource());
        ASTConverter15Test.assertNotNull((String)"No wildcard", (Object)typeBinding2.getWildcard());
    }

    public void test0169() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n    static class BB<T, S> { }\n    static class BD<T> extends BB<T, T> { }\n    void f() {\n        BB<? extends Number, ? super Integer> bb = null;\n        Object o = (BD<Number>) bb;\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 1, "Type safety: Unchecked cast from X.BB<capture#1-of ? extends Number,capture#2-of ? super Integer> to X.BD<Number>");
        node = this.getASTNode(compilationUnit, 0, 2, 1);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a cast expression", (int)11, (int)expression.getNodeType());
        CastExpression castExpression = (CastExpression)expression;
        Expression expression2 = castExpression.getExpression();
        ITypeBinding typeBinding = expression2.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)typeBinding.isParameterizedType());
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)typeArguments.length);
        ITypeBinding typeBinding2 = typeArguments[0];
        ASTConverter15Test.assertTrue((String)"Not a capture binding", (boolean)typeBinding2.isCapture());
        ITypeBinding wildcardBinding = typeBinding2.getWildcard();
        ASTConverter15Test.assertNotNull((String)"No wildcard binding", (Object)wildcardBinding);
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding2.isFromSource());
        ASTConverter15Test.assertTrue((String)"Not a wildcard", (boolean)wildcardBinding.isWildcardType());
    }

    public void test0170() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n    static class BB<T, S> { }\n    static class BD<T> extends BB<T, T> { }\n    static BB<? extends Number, ? super Integer> bb = null;\n    public static void main(String[] args) {\n        System.out.println(/*start*/X.bb/*end*/);\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)node.getNodeType());
        QualifiedName qualifiedName = (QualifiedName)node;
        ITypeBinding typeBinding = qualifiedName.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not a parameterized type", (boolean)typeBinding.isParameterizedType());
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)typeArguments.length);
        ITypeBinding typeBinding2 = typeArguments[0];
        ASTConverter15Test.assertTrue((String)"Not a capture binding", (boolean)typeBinding2.isCapture());
        ITypeBinding wildcardBinding = typeBinding2.getWildcard();
        ASTConverter15Test.assertNotNull((String)"No wildcard binding", (Object)wildcardBinding);
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding2.isFromSource());
        ASTConverter15Test.assertTrue((String)"Not a wildcard", (boolean)wildcardBinding.isWildcardType());
    }

    public void test0171() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\n    java.util.List<? extends Runnable> list;\n    Object o= /*start*/list/*end*/;\n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a simple name", (int)42, (int)node.getNodeType());
        ITypeBinding type = ((SimpleName)node).resolveTypeBinding();
        ASTConverter15Test.assertNull((String)"Unexpected element", (Object)type.getTypeArguments()[0].getJavaElement());
    }

    public void test0172() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T> {\n  private static X<? super Number> num() {\n\t\treturn null;\n\t}\n  void add(T t) {\n  }\n  void foo() {\n    Number n= null;\n    /*start1*/num().add(null)/*end1*/;\n    /*start2*/num().add(n)/*end2*/;\n  }\n}\n";
        IBinding[] bindings = this.resolveBindings(contents, this.workingCopy);
        ASTConverter15Test.assertTrue((String)"2 different capture bindings should not be equals", (!bindings[0].isEqualTo(bindings[1]) ? 1 : 0) != 0);
    }

    public void test0173() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.Vector;\n\npublic class X {\n\tvoid test1() {\n\t\tVector<? extends Number[]> v = null;\n\t\t /*start*/v.get(0)/*end*/;\n\t}\n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ITypeBinding type = ((Expression)node).resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Should be one bound", (type.getTypeBounds().length == 1 ? 1 : 0) != 0);
        ASTConverter15Test.assertEquals((String)"Invalid bound", (String)"[Ljava.lang.Number;", (String)type.getTypeBounds()[0].getBinaryName());
    }

    public void test0174() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.*;\n\npublic class X {\n\tvoid test1() {\n\t\tList<? extends Collection> l = null;\n\t\t /*start*/l.get(0)/*end*/;\n\t}\n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ITypeBinding type = ((Expression)node).resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Should be one bound", (type.getTypeBounds().length == 1 ? 1 : 0) != 0);
        ASTConverter15Test.assertEquals((String)"Invalid bound", (String)"java.util.Collection", (String)type.getTypeBounds()[0].getBinaryName());
    }

    public void test0175() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.*;\n\npublic class X {\n\tvoid test1() {\n\t\tList<?> l = null;\n\t\t /*start*/l.get(0)/*end*/;\n\t}\n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ITypeBinding type = ((Expression)node).resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Should be no bound", (type.getTypeBounds().length == 0 ? 1 : 0) != 0);
    }

    public void test0176() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.*;\n\npublic class X<T extends Collection> {\n\tvoid test1() {\n\t\tList<T> l = null;\n\t\t /*start*/l.get(0)/*end*/;\n\t}\n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ITypeBinding type = ((Expression)node).resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Should be one bound", (type.getTypeBounds().length == 1 ? 1 : 0) != 0);
        ASTConverter15Test.assertEquals((String)"Invalid bound", (String)"java.util.Collection", (String)type.getTypeBounds()[0].getBinaryName());
    }

    public void test0177() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T> {\n    Object foo(X<?> list) {\n       return /*start*/list.get()/*end*/;\n    }\n    T get() {\n    \treturn null;\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        FunctionInvocation methodInvocation = (FunctionInvocation)node;
        ITypeBinding capture = methodInvocation.resolveTypeBinding();
        ITypeBinding declaringClass = capture.getDeclaringClass();
        this.assertBindingEquals("LX<TT;>;", (IBinding)declaringClass);
    }

    public void test0178() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.Vector;\n\npublic class X {\n\tvoid foo() {\n\t\tVector< ? super java.util.Collection<? super java.lang.Number> > lhs= null;\t\t\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        node = this.getASTNode(unit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        Type type = statement.getType();
        this.checkSourceRange((ASTNode)type, "Vector< ? super java.util.Collection<? super java.lang.Number> >", contents);
        ASTConverter15Test.assertEquals((String)"Not a parameterized type", (int)74, (int)type.getNodeType());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List typeArguments = parameterizedType.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        Type typeArgument = (Type)typeArguments.get(0);
        ASTConverter15Test.assertEquals((String)"Not a wildcard type", (int)76, (int)typeArgument.getNodeType());
        WildcardType wildcardType = (WildcardType)typeArgument;
        this.checkSourceRange((ASTNode)wildcardType, "? super java.util.Collection<? super java.lang.Number>", contents);
        Type bound = wildcardType.getBound();
        ASTConverter15Test.assertEquals((String)"Not a parameterized type", (int)74, (int)bound.getNodeType());
        ParameterizedType parameterizedType2 = (ParameterizedType)bound;
        this.checkSourceRange((ASTNode)bound, "java.util.Collection<? super java.lang.Number>", contents);
        typeArguments = parameterizedType2.typeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeArguments.size());
        typeArgument = (Type)typeArguments.get(0);
        ASTConverter15Test.assertEquals((String)"Not a wildcard type", (int)76, (int)typeArgument.getNodeType());
        wildcardType = (WildcardType)typeArgument;
        this.checkSourceRange((ASTNode)wildcardType, "? super java.lang.Number", contents);
    }

    public void test0180() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import java.util.List;\npublic class X {\n    List</*start*/? extends Runnable/*end*/> list;\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a wildcard type", (int)76, (int)node.getNodeType());
        WildcardType wildcardType = (WildcardType)node;
        ITypeBinding typeBinding = wildcardType.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a wildcard type", (boolean)typeBinding.isWildcardType());
        ASTConverter15Test.assertFalse((String)"Not an class", (boolean)typeBinding.isClass());
    }

    public void test0181() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<E> {\n\t/*start1*/Y<E>/*end1*/ y;\n\tstatic class Other<E> {\n\t\t/*start2*/Y<E>/*end2*/ y;\n\t}\n}\nclass Y<E> {\n}";
        IBinding[] bindings = this.resolveBindings(contents, this.workingCopy);
        ASTConverter15Test.assertTrue((String)"2 different parameterized type bindings should not be equals", (!bindings[0].isEqualTo(bindings[1]) ? 1 : 0) != 0);
    }

    public void test0182() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.Map;\n\npublic class X {\n\tpublic void foo() {\n\t\tMap<String, Number> map= new Map<String, Number>() {\n\t\t};\n\t}\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        String expectedSource = "map= new Map<String, Number>() {\n\t\t}";
        this.checkSourceRange((ASTNode)fragment, expectedSource, "import java.util.Map;\n\npublic class X {\n\tpublic void foo() {\n\t\tMap<String, Number> map= new Map<String, Number>() {\n\t\t};\n\t}\n}");
    }

    public void test0183() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.Map;\n\npublic class X {\n\tMap<String, Number> map= new Map<String, Number>() {\n\t};\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        String expectedSource = "map= new Map<String, Number>() {\n\t}";
        this.checkSourceRange((ASTNode)fragment, expectedSource, "import java.util.Map;\n\npublic class X {\n\tMap<String, Number> map= new Map<String, Number>() {\n\t};\n}");
    }

    public void test0184() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n\tjava.util.Map<String, Number> map= new java.util.Map<String, Number>() {\n\t};\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initializer = fragment.getInitializer();
        ASTConverter15Test.assertNotNull((String)"No initializer", (Object)initializer);
        ITypeBinding binding = initializer.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0185() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0185", "X.js");
        ASTConverter15Test.assertEquals((String)"Wrong setting", (String)"warning", (String)sourceUnit.getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.compiler.problem.uncheckedTypeOperation", true));
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 0);
    }

    public void test0186() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0186", "X.js");
        ASTConverter15Test.assertEquals((String)"Wrong setting", (String)"warning", (String)sourceUnit.getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.compiler.problem.uncheckedTypeOperation", true));
        ASTNode result = this.runJLS3Conversion(sourceUnit, true, true);
        ASTConverter15Test.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 2, "Type safety: The expression of type ArrayList needs unchecked conversion to conform to List<String>\nArrayList is a raw type. References to generic type ArrayList<T> should be parameterized");
    }

    public void test0187() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n\t<T> /*start*/Y<T>/*end*/ foo() {\n      return null;\t};\n}\nclass Y<E> {\n}", this.workingCopy, false);
        ParameterizedType type = (ParameterizedType)node;
        this.assertBindingEquals("LX~Y<LX;:1TT;>;", (IBinding)type.resolveBinding());
    }

    public void test0188() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.List;\n\npublic class X {\n\tclass Counter<T, /*start*/L extends List<T>/*end*/> {\n\t\tprivate L _attribute;\n\t}\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a type parameter", (int)73, (int)node.getNodeType());
        ITypeBinding typeBinding = ((TypeParameter)node).resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverter15Test.assertFalse((String)"Cannot be top level", (boolean)typeBinding.isTopLevel());
        ASTConverter15Test.assertFalse((String)"A class", (boolean)typeBinding.isClass());
        ASTConverter15Test.assertFalse((String)"An interface", (boolean)typeBinding.isInterface());
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeBinding.isTypeVariable());
        ASTConverter15Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0189() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{""}, new String[]{"CONVERTER_JCL15_LIB"}, "", "1.5");
            this.addLibrary(project, "lib.jar", "src.zip", new String[]{"/P1/p/I1.js", "package p;\npublic class I1<E> {\n}", "/P1/p/I2.js", "package p;\npublic interface I2<K, V> {\n\tinterface I3<K,V> {}\n\tI1<I2.I3<K, V>> foo();\n}", "/P1/p/X.js", "package p;\npublic class X<K,V>  implements I2<K,V> {\n\tpublic I1<I2.I3<K,V>> foo() {\n\t\treturn null;\n\t}\t\n}"}, "1.5");
            this.workingCopy = this.getWorkingCopy("/P1/p1/Y.js", true);
            ASTNode node = this.buildAST("package p1;\nimport p.*;\npublic abstract class Y implements I2 {\n\tpublic I1 foo() {\n\t\treturn /*start*/bar().foo()/*end*/;\n\t}\n\tprivate X bar() {\n\t\treturn null;\n\t}\n}", this.workingCopy, false);
            FunctionInvocation method = (FunctionInvocation)node;
            IFunctionBinding methodBinding = method.resolveMethodBinding();
            this.assertBindingEquals("Lp/X;.foo()Lp/I1<Lp/I2$I3<TK;TV;>;>;", (IBinding)methodBinding.getMethodDeclaration());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
    }

    public void test0190() throws CoreException, IOException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("class Container<T> {\n\tprivate final T m_t;\n\n\tpublic Container(T t) {\n\t\tm_t = t;\n\t}\n\n\tT get() {\n\t\treturn m_t;\n\t}\n}\n\nclass GenericContainer {\n\tprivate final Container<?> m_c;\n\n\tpublic GenericContainer(Container<?> c) {\n\t\tm_c = c;\n\t}\n\n\tpublic Container<?> getC() {\n\t\treturn m_c;\n\t}\n}\n\npublic class X {\n\tGenericContainer createContainer() {\n\t\tfinal Container<String> innerContainer = new Container<String>(\"hello\");\n\t\tfinal Container<Container<String>> outerContainer = new Container<Container<String>>(\n\t\t\t\tinnerContainer);\n\t\treturn new GenericContainer(outerContainer);\n\t}\n\n\tvoid method() {\n\t\tfinal GenericContainer createContainer = createContainer();\n\t\t/*start*/@SuppressWarnings(\"unchecked\")\n\t\tfinal Container<Container<String>> c = (Container<Container<String>>) createContainer.getC();/*end*/\n\t\tfinal Container<String> container = c.get();\n\t\tfinal String string = container.get();\n\t}\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List modifiers = statement.modifiers();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)modifiers.size());
    }

    public void test0191() throws CoreException, IOException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter15", "src", "test0191", "X.js");
        ASTNode node = this.runConversion(3, sourceUnit, true);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 1, "Type safety: Unchecked cast from Collection<capture#1-of ? extends Number> to Vector<Object>");
        node = this.getASTNode(unit, 0, 0, 0);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initializer = fragment.getInitializer();
        ASTConverter15Test.assertNotNull((String)"No initializer", (Object)initializer);
        ASTConverter15Test.assertEquals((String)"Not a cast expression", (int)11, (int)initializer.getNodeType());
        CastExpression castExpression = (CastExpression)initializer;
        Type type = castExpression.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        Expression expression = castExpression.getExpression();
        ITypeBinding typeBinding2 = expression.resolveTypeBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding2);
        ASTConverter15Test.assertTrue((String)"Not cast compatible", (boolean)typeBinding2.isCastCompatible(typeBinding));
    }

    public void test0192() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<E> {\n\tpublic static class InnerClass {\n\t\tstatic class InnerInnerClass {\n\t\t\t/*start*/X.WrongInnerClass/*end*/.InnerInnerClass m;\n\t\t}\n\t}\n}";
        IBinding[] bindings = this.resolveBindings(contents, this.workingCopy, false);
        if (bindings[0] != null) {
            try {
                bindings[0].toString();
                ASTConverter15Test.fail((String)"should get an exception if bug 100584 present");
            }
            catch (Throwable throwable) {}
        }
        ASTConverter15Test.assertTrue((String)"should yield a null, not a malformed binding", (bindings[0] == null ? 1 : 0) != 0);
    }

    public void test0193() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs : new byte[][] { b1, b2 }) {}\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        node = this.getASTNode(unit, 0, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)node.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)node;
        SingleVariableDeclaration singleVariableDeclaration = forStatement.getParameter();
        ASTConverter15Test.assertEquals((String)"Should be 0", (int)0, (int)singleVariableDeclaration.getExtraDimensions());
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertEquals((String)"Not an array type", (int)5, (int)type.getNodeType());
        ArrayType arrayType = (ArrayType)type;
        ASTConverter15Test.assertEquals((String)"Should be 1", (int)1, (int)arrayType.getDimensions());
    }

    public void test0194() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs/*comment*/ [ /*comment*/ ]: new byte[][][] { new byte[][] { b1, b2 }}) {}\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        node = this.getASTNode(unit, 0, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)node.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)node;
        SingleVariableDeclaration singleVariableDeclaration = forStatement.getParameter();
        ASTConverter15Test.assertEquals((String)"Should be 1", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
        Type type = singleVariableDeclaration.getType();
        ASTConverter15Test.assertEquals((String)"Not an array type", (int)5, (int)type.getNodeType());
        ArrayType arrayType = (ArrayType)type;
        ASTConverter15Test.assertEquals((String)"Should be 1", (int)1, (int)arrayType.getDimensions());
    }

    public void test0195() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\t<S extends Number, T> void take(S e, T f) {}\n\t<S extends Number, T> void take(T e, S f) {}\n\t<S extends Number, T extends S> void take(T e, S f) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        node = this.getASTNode(unit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration2 = (FunctionDeclaration)node;
        IFunctionBinding methodBinding2 = methodDeclaration2.resolveBinding();
        node = this.getASTNode(unit, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration3 = (FunctionDeclaration)node;
        IFunctionBinding methodBinding3 = methodDeclaration3.resolveBinding();
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding.isEqualTo((IBinding)methodBinding2));
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding2.isEqualTo((IBinding)methodBinding));
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding3.isEqualTo((IBinding)methodBinding));
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding3.isEqualTo((IBinding)methodBinding2));
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding2.isEqualTo((IBinding)methodBinding3));
        ASTConverter15Test.assertFalse((String)"Bindings are equals", (boolean)methodBinding.isEqualTo((IBinding)methodBinding3));
        ASTConverter15Test.assertTrue((String)"Bindings are not equals", (boolean)methodBinding3.isEqualTo((IBinding)methodBinding3));
        ASTConverter15Test.assertTrue((String)"Bindings are not equals", (boolean)methodBinding2.isEqualTo((IBinding)methodBinding2));
        ASTConverter15Test.assertTrue((String)"Bindings are not equals", (boolean)methodBinding.isEqualTo((IBinding)methodBinding));
    }

    public void test0196() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n  void foo() {\n    /*start*/class Y {\n    }/*end*/\n  }\n}", this.workingCopy);
        ITypeBinding binding = ((TypeDeclarationStatement)node).resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)binding);
        String key = binding.getKey();
        String signature = new BindingKey(key).toSignature();
        String simpleName = Signature.getSimpleName((String)Signature.toString((String)signature));
        ASTConverter15Test.assertEquals((String)"Unexpected simple name", (String)"Y", (String)simpleName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0197() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"CONVERTER_JCL15_LIB", "/P/lib"}, "bin", "1.5");
            IFolder folder = this.createFolder("/P/lib");
            String classesPath = folder.getLocation().toOSString();
            HashMap options = new HashMap();
            String[] pathsAndContents = new String[]{"p/Bin.js", "package p;\npublic class Bin {\n}", "p/BinSub.js", "package p;\npublic class BinSub extends Bin {\n}"};
            Util.compile((String[])pathsAndContents, options, (String)classesPath);
            folder.refreshLocal(2, null);
            Util.delete((IResource)folder.getFolder("p").getFile("Bin.class"));
            this.workingCopy = this.getWorkingCopy("/P/src/X.js", true);
            String contents = "public class X {\n\tvoid bar() throws p.BinSub {\n\t}\n\t</*start*/T/*end*/> void foo() {\n\t}\n}";
            IBinding[] bindings = this.resolveBindings(contents, this.workingCopy, false);
            this.assertBindingsEqual("LX;.foo<T:Ljava/lang/Object;>()V:TT;", bindings);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P");
    }

    public void test0198() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X<E> {\n    class B { }\n    {\n        X<String>.B b;\n    }\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a initializer", (int)28, (int)node.getNodeType());
        Initializer initializer = (Initializer)node;
        Block block = initializer.getBody();
        ASTConverter15Test.assertNotNull((String)"No block", (Object)block);
        List statements = block.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)statement.getNodeType());
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
        Type type = variableDeclarationStatement.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding2 = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a member type", (boolean)typeDeclaration.isMemberTypeDeclaration());
        ASTConverter15Test.assertFalse((String)"Binding should not be equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding2));
        ASTConverter15Test.assertFalse((String)"Binding should not be equals", (boolean)typeBinding2.isEqualTo((IBinding)typeBinding));
        ITypeBinding typeBinding3 = typeBinding.getTypeDeclaration();
        ASTConverter15Test.assertFalse((String)"Binding should not be equals", (boolean)typeBinding.isEqualTo((IBinding)typeBinding3));
        ASTConverter15Test.assertFalse((String)"Binding should not be equals", (boolean)typeBinding3.isEqualTo((IBinding)typeBinding));
    }

    public void test0199() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)node.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)node;
        SingleVariableDeclaration parameter = forStatement.getParameter();
        Type type = parameter.getType();
        this.checkSourceRange((ASTNode)type, "byte[]", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
        this.checkSourceRange((ASTNode)parameter, "byte[] bs", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
        ASTConverter15Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type elementType = arrayType.getElementType();
        ASTConverter15Test.assertTrue((String)"not a primitive type", (boolean)elementType.isPrimitiveType());
        this.checkSourceRange((ASTNode)elementType, "byte", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
    }

    public void test0200() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)node.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)node;
        SingleVariableDeclaration parameter = forStatement.getParameter();
        Type type = parameter.getType();
        this.checkSourceRange((ASTNode)type, "byte[]", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
        this.checkSourceRange((ASTNode)parameter, "final byte[] bs", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte[] bs : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
    }

    public void test0201() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte bs[] : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 2);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)node.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)node;
        SingleVariableDeclaration parameter = forStatement.getParameter();
        Type type = parameter.getType();
        ASTConverter15Test.assertEquals((String)"Wrong extended dimension", (int)1, (int)parameter.getExtraDimensions());
        this.checkSourceRange((ASTNode)type, "byte", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte bs[] : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
        this.checkSourceRange((ASTNode)parameter, "final byte bs[]", "public class X {\n    public static void main(String[] args) {\n        byte[] b1 = new byte[0];\n        byte[] b2 = new byte[0];\n        for (final byte bs[] : new byte[][] { b1, b2 }) {\n\t\t\tSystem.out.println(bs);\n        }\n    }\n}");
        ASTConverter15Test.assertTrue((String)"not a primitive type", (boolean)type.isPrimitiveType());
    }

    public void test0203() throws CoreException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("class X<T> {\n        X<T> list= this;\n        X<? super T> list2= this;\n}", this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initializer = fragment.getInitializer();
        ITypeBinding typeBinding = initializer.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not a parameterized binding", (boolean)typeBinding.isParameterizedType());
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        fragment = (VariableDeclarationFragment)fragments.get(0);
        initializer = fragment.getInitializer();
        typeBinding = initializer.resolveTypeBinding();
        ASTConverter15Test.assertTrue((String)"Not a parameterized binding", (boolean)typeBinding.isParameterizedType());
    }

    public void test0204() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T> {\n\tstatic class Y {\n\t\t/*start*/Y/*end*/ y;\n\t}\n}";
        IBinding[] bindings = this.resolveBindings(contents, this.workingCopy);
        this.assertBindingsEqual("LX<>.Y;", bindings);
    }

    public void test0205() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<E> {\n    @I(12)\n    @interface I {\n        @I(/*start1*/value/*end1*/=13)\n        int /*start2*/value/*end2*/();\n    }\n}";
        IBinding[] bindings = this.resolveBindings(contents, this.workingCopy);
        ASTConverter15Test.assertFalse((String)"Declaration and reference keys should not be the same", (boolean)bindings[0].getKey().equals(bindings[1].getKey()));
    }

    public void test0207() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n    void m() {\n        new Object() {};\n    }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        Expression expression = ((ExpressionStatement)node).getExpression();
        ASTConverter15Test.assertEquals((String)"Not a class instance creation", (int)14, (int)expression.getNodeType());
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        IFunctionBinding binding = classInstanceCreation.resolveConstructorBinding();
        ASTConverter15Test.assertNotNull((String)"Should not be null", (Object)binding);
    }

    public void test0210() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", false);
        String contents = "public class X {\n\tvoid foo(Object r) {\n\t\tif (r instanceof Future<?>) {\n\t\t\tSystem.out.println(\"TRUE\");\n\t\t} else {\n\t\t\tSystem.out.println(\"FALSE\");\n\t\t}\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertNotNull((String)"No node", (Object)node);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.assertProblemsSize(compilationUnit, 0);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not an if statement", (int)25, (int)node.getNodeType());
        IfStatement ifStatement = (IfStatement)node;
        Expression expression = ifStatement.getExpression();
        this.checkSourceRange((ASTNode)expression, "r instanceof Future<?>", contents);
        ASTConverter15Test.assertEquals((String)"Not an instanceof expression", (int)62, (int)expression.getNodeType());
        InstanceofExpression instanceofExpression = (InstanceofExpression)expression;
        Type type = instanceofExpression.getRightOperand();
        this.checkSourceRange((ASTNode)type, "Future<?>", contents);
    }

    public void test0211() throws JavaScriptModelException {
        String contents = "public class X {\n\tvoid foo(java.util.List<?> tab[]) {\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        List parameters = declaration.parameters();
        ASTConverter15Test.assertEquals((String)"wrong number", (int)1, (int)parameters.size());
        SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)variableDeclaration, "java.util.List<?> tab[]", contents);
        this.checkSourceRange((ASTNode)variableDeclaration.getType(), "java.util.List<?>", contents);
        this.checkSourceRange((ASTNode)variableDeclaration.getName(), "tab", contents);
        ASTConverter15Test.assertEquals((String)"wrong number of extra dimensions", (int)1, (int)variableDeclaration.getExtraDimensions());
    }

    public void test0212() throws JavaScriptModelException {
        String contents = "public class X {\n\tvoid foo(java.util.List<?> tab[][]) {\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        List parameters = declaration.parameters();
        ASTConverter15Test.assertEquals((String)"wrong number", (int)1, (int)parameters.size());
        SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)variableDeclaration, "java.util.List<?> tab[][]", contents);
        this.checkSourceRange((ASTNode)variableDeclaration.getType(), "java.util.List<?>", contents);
        this.checkSourceRange((ASTNode)variableDeclaration.getName(), "tab", contents);
        ASTConverter15Test.assertEquals((String)"wrong number of extra dimensions", (int)2, (int)variableDeclaration.getExtraDimensions());
    }

    public void test0213() throws JavaScriptModelException {
        String contents = "public class X {\n    int test(String[] strings) {\n        return strings.length;\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a return statement", (int)41, (int)node.getNodeType());
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverter15Test.assertNotNull((String)"No expression", (Object)expression);
        ASTConverter15Test.assertEquals((String)"Not a qualified name", (int)40, (int)expression.getNodeType());
        QualifiedName name = (QualifiedName)expression;
        SimpleName simpleName = name.getName();
        this.checkSourceRange((ASTNode)simpleName, "length", contents);
        IBinding binding = simpleName.resolveBinding();
        ASTConverter15Test.assertEquals((String)"Not a field", (int)3, (int)binding.getKind());
    }

    public void test0214() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\t\n\t<T extends A> T foo(T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n\tvoid bar() {\n\t\tB b1 = foo(new B());\n\t\tB b2 = foo(new B());\n\t}\n}\n\nclass A {}\nclass B extends A {}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 2, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 2, 1);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)60, (int)node.getNodeType());
        statement = (VariableDeclarationStatement)node;
        fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        fragment = (VariableDeclarationFragment)fragments.get(0);
        expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding2 = invocation.resolveMethodBinding();
        ASTConverter15Test.assertTrue((String)"Not identical", (methodBinding == methodBinding2 ? 1 : 0) != 0);
    }

    public void test0215() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\tstatic <T> T identity(T t) { return t; }\n\n\tpublic static void main(String[] args) {\n\t\tString s = \"aaa\";\n\t\tidentity(s);\n\t\tidentity(s);\n\t\tidentity(s);\n\n\t\tObject o = new Object();\n\t\tidentity(o);\n\t\tidentity(o);\n\t\tidentity(o);\n\n\t\tThrowable t = null;\n\t\tidentity(t);\n\t\tidentity(t);\n\t\tidentity(t);\n\n\t\tException e = null;\n\t\tidentity(e);\n\t\tidentity(e);\n\t\tidentity(e);\n\n\t\tNullPointerException npe = null;\n\t\tidentity(npe);\n\t\tidentity(npe);\n\t\tidentity(npe);\n\n\t\tCloneable c = null;\n\t\tidentity(c);\n\t\tidentity(c);\n\t\tidentity(c);\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 1, 1);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        ExpressionStatement statement = (ExpressionStatement)node;
        Expression expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 2);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding2 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 3);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding3 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 5);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding4 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 6);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding5 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 9);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding6 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 10);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding7 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 11);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding8 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 13);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding9 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 14);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding10 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 15);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding11 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 17);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding12 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 18);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding13 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 19);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding14 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 21);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding15 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 22);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding16 = invocation.resolveMethodBinding();
        node = this.getASTNode(unit, 0, 1, 23);
        ASTConverter15Test.assertEquals((String)"Not an expression statement", (int)21, (int)node.getNodeType());
        statement = (ExpressionStatement)node;
        expression = statement.getExpression();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding17 = invocation.resolveMethodBinding();
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding == methodBinding2 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding2 == methodBinding3 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding4 == methodBinding5 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding6 == methodBinding7 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding7 == methodBinding8 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding9 == methodBinding10 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding9 == methodBinding11 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding12 == methodBinding13 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding14 == methodBinding13 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding15 == methodBinding16 ? 1 : 0) != 0);
        ASTConverter15Test.assertTrue((String)"method bindings are not equals", (methodBinding17 == methodBinding16 ? 1 : 0) != 0);
    }

    public void test0216() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class Y<T> {\n\t<T> Class foo(T t) {\n\t\treturn t.getClass();\n\t}\n}\npublic class X { \n\t \n\tpublic static void main(String[] args) { \n\t\tClass c = new Y().foo(null);\n\t\tClass c2 = new Y().foo(null);\n\t} \n}\n";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        String expectedOutput = "Class is a raw type. References to generic type Class<T> should be parameterized\nClass is a raw type. References to generic type Class<T> should be parameterized\nType safety: The method foo(Object) belongs to the raw type Y. References to generic type Y<T> should be parameterized\nY is a raw type. References to generic type Y<T> should be parameterized\nClass is a raw type. References to generic type Class<T> should be parameterized\nType safety: The method foo(Object) belongs to the raw type Y. References to generic type Y<T> should be parameterized\nY is a raw type. References to generic type Y<T> should be parameterized";
        this.assertProblemsSize(unit, 7, expectedOutput);
        node = this.getASTNode(unit, 1, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
        List fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        FunctionInvocation invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding = invocation.resolveMethodBinding();
        ASTConverter15Test.assertTrue((String)"Not a raw method", (boolean)methodBinding.isRawMethod());
        node = this.getASTNode(unit, 1, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a variable declaration statement", (int)60, (int)node.getNodeType());
        statement = (VariableDeclarationStatement)node;
        fragments = statement.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        fragment = (VariableDeclarationFragment)fragments.get(0);
        expression = fragment.getInitializer();
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
        invocation = (FunctionInvocation)expression;
        IFunctionBinding methodBinding2 = invocation.resolveMethodBinding();
        ASTConverter15Test.assertTrue((String)"Not a raw method", (boolean)methodBinding2.isRawMethod());
        ASTConverter15Test.assertTrue((String)"Method bindings are not identical", (methodBinding == methodBinding2 ? 1 : 0) != 0);
    }

    public void test0217() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class Generic<E> {\n}\npublic class X {\n    Generic raw;\n    java.util.Collection rawCollection;\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        String expectedOutput = "Generic is a raw type. References to generic type Generic<E> should be parameterized\nCollection is a raw type. References to generic type Collection<T> should be parameterized";
        this.assertProblemsSize(unit, 2, expectedOutput);
        node = this.getASTNode(unit, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"isRaw", (boolean)typeBinding.isRawType());
        node = this.getASTNode(unit, 1, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        fieldDeclaration = (FieldDeclaration)node;
        type = fieldDeclaration.getType();
        ITypeBinding typeBinding2 = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"isRaw", (boolean)typeBinding2.isRawType());
        ITypeBinding[] typeParameters = typeBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeParameters.length);
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeArguments.length);
        typeParameters = typeBinding2.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeParameters.length);
        typeArguments = typeBinding2.getTypeArguments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)typeArguments.length);
    }

    public void test0220() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n        void bar(String[] c) {\n                for(String s: c) {\n                        try {\n                        }\n                }\n        }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 1, "Syntax error, insert \"Finally\" to complete BlockStatements");
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block body = methodDeclaration.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)body);
        List statements = body.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        ASTConverter15Test.assertTrue((String)"Recovered", (!this.isRecovered((ASTNode)body) ? 1 : 0) != 0);
        ASTConverter15Test.assertFalse((String)"Malformed", (boolean)this.isMalformed((ASTNode)body));
        Statement statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)statement.getNodeType());
        EnhancedForStatement enhancedForStatement = (EnhancedForStatement)statement;
        Statement forBody = enhancedForStatement.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)forBody);
        ASTConverter15Test.assertEquals((String)"Not a block", (int)8, (int)forBody.getNodeType());
        statements = ((Block)forBody).statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        statement = (Statement)statements.get(0);
        ASTConverter15Test.assertEquals((String)"Not an try statement", (int)54, (int)statement.getNodeType());
        TryStatement tryStatement = (TryStatement)statement;
        Block finallyBlock = tryStatement.getFinally();
        ASTConverter15Test.assertNotNull((String)"No finally block", (Object)finallyBlock);
        ASTConverter15Test.assertTrue((String)"Not recovered", (boolean)this.isRecovered((ASTNode)finallyBlock));
    }

    public void test0221() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "import p1.p2.MyEnum;\npublic class X {\n\tMyEnum foo() {\n\t\treturn null;\n\t}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
    }

    public void test0222() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n   public void a() {\n      Object a = null;\n      for (Object o : a.getClass()()) {\n      }\n   }\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 2, "Syntax error on token \")\", invalid Name\nSyntax error, insert \")\" to complete EnhancedForStatementHeader");
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block body = methodDeclaration.getBody();
        ASTConverter15Test.assertNotNull((String)"No body", (Object)body);
        List statements = body.statements();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)2, (int)statements.size());
        Statement statement = (Statement)statements.get(1);
        ASTConverter15Test.assertEquals((String)"Not an enhanced for statement", (int)70, (int)statement.getNodeType());
        EnhancedForStatement forStatement = (EnhancedForStatement)statement;
        Expression expression = forStatement.getExpression();
        ASTConverter15Test.assertNotNull((String)"No expression", (Object)expression);
        ASTConverter15Test.assertEquals((String)"Not a method invocation", (int)32, (int)expression.getNodeType());
    }

    public void test0232() throws JavaScriptModelException {
        String contents = "import test0232.X;\npublic class A {\n    X test() {\n        return null;\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/A.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        Type type = declaration.getReturnType2();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a binary type binding", (!typeBinding.isFromSource() ? 1 : 0) != 0);
    }

    public void test0233() throws JavaScriptModelException {
        String contents = "import test0233.X;\npublic class A {\n    X test() {\n        return null;\n    }\n}";
        this.workingCopy = this.getWorkingCopy("/Converter15/src/A.js", true);
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration declaration = (FunctionDeclaration)node;
        Type type = declaration.getReturnType2();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertTrue((String)"Not a binary type binding", (!typeBinding.isFromSource() ? 1 : 0) != 0);
    }

    public void test0234() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "class B {\n\t<T> int m() {\n\t\treturn 0;\n\t}\n}\npublic class X<T> extends B {\n\tint i = super.<T> m();\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 1, 0);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "super.<T> m()", contents);
    }

    public void test0235() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/test0235/X.js", true);
        String contents = "package test0235;\npublic class X implements I {\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        String expectedProblems = "The hierarchy of the type X is inconsistent\nThe type test0235.Zork cannot be resolved. It is indirectly referenced from required .class files";
        this.assertProblemsSize(unit, 2, expectedProblems);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ITypeBinding[] interfaces = typeBinding.getInterfaces();
        ASTConverter15Test.assertNotNull((String)"No interfaces", (Object)interfaces);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)interfaces.length);
        ASTConverter15Test.assertNotNull((String)"Should not be null", (Object)interfaces[0]);
        ITypeBinding typeBinding2 = interfaces[0];
        interfaces = typeBinding2.getInterfaces();
        ASTConverter15Test.assertNotNull((String)"No interfaces", (Object)interfaces);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)0, (int)interfaces.length);
    }

    public void test0236() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X implements Runnable, Zork {\n\tpublic void run() {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        String expectedProblems = "Zork cannot be resolved to a type";
        this.assertProblemsSize(unit, 1, expectedProblems);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ITypeBinding[] interfaces = typeBinding.getInterfaces();
        ASTConverter15Test.assertNotNull((String)"No interfaces", (Object)interfaces);
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)interfaces.length);
        ASTConverter15Test.assertNotNull((String)"Should not be null", (Object)interfaces[0]);
    }

    public void test0237() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/test0237/X.js", true);
        String contents = "package test0237;\npublic class X {\n\tZork foo() {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        String expectedProblems = "Zork cannot be resolved to a type";
        this.assertProblemsSize(unit, 1, expectedProblems);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        IFunctionBinding[] methodBindings = typeBinding.getDeclaredMethods();
        ASTConverter15Test.assertNotNull((String)"No method bindings", (Object)methodBindings);
        ASTConverter15Test.assertEquals((String)"wrong size", (int)1, (int)methodBindings.length);
        ASTConverter15Test.assertFalse((String)"Method is not the method foo", (boolean)"foo".equals(methodBindings[0].getName()));
        ASTConverter15Test.assertNotNull((String)"No return type", (Object)methodBindings[0].getReturnType());
    }

    public void test0238() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/test0238/X.js", true);
        String contents = "package test0238;\npublic class X extends A {\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        typeBinding = typeBinding.getSuperclass();
        IFunctionBinding[] methodBindings = typeBinding.getDeclaredMethods();
        ASTConverter15Test.assertNotNull((String)"No method bindings", (Object)methodBindings);
        ASTConverter15Test.assertEquals((String)"wrong size", (int)0, (int)methodBindings.length);
    }

    public void test0239() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/test0239/X.js", true);
        String contents = "package test0239;\npublic class X extends A {\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        typeBinding = typeBinding.getSuperclass();
        IVariableBinding[] variableBindings = typeBinding.getDeclaredFields();
        ASTConverter15Test.assertNotNull((String)"No variable bindings", (Object)variableBindings);
        ASTConverter15Test.assertEquals((String)"wrong size", (int)0, (int)variableBindings.length);
    }

    public void test0240() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X<T> {}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0);
        ASTConverter15Test.assertEquals((String)"Not a type declaration", (int)55, (int)node.getNodeType());
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ITypeBinding[] typeParameters = typeBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.length);
        ITypeBinding typeParameter = typeParameters[0];
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeParameter.isTypeVariable());
        ASTConverter15Test.assertEquals((String)"Wrong binary name", (String)"X$T", (String)typeParameter.getBinaryName());
    }

    public void test0241() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\t<T> void foo() {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)methodBinding);
        ITypeBinding[] typeParameters = methodBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.length);
        ITypeBinding typeParameter = typeParameters[0];
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeParameter.isTypeVariable());
        ASTConverter15Test.assertEquals((String)"Wrong binary name", (String)"X$()V$T", (String)typeParameter.getBinaryName());
    }

    public void test0242() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "public class X {\n\t<T> X() {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)methodBinding);
        ITypeBinding[] typeParameters = methodBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.length);
        ITypeBinding typeParameter = typeParameters[0];
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeParameter.isTypeVariable());
        ASTConverter15Test.assertEquals((String)"Wrong binary name", (String)"X$()V$T", (String)typeParameter.getBinaryName());
    }

    public void test0243() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/p/X.js", true);
        String contents = "package p;\npublic class X<U,V> {\n\t<T> X(Integer i) {}\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 0);
        ASTConverter15Test.assertEquals((String)"Not a method declaration", (int)31, (int)node.getNodeType());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)methodBinding);
        ITypeBinding[] typeParameters = methodBinding.getTypeParameters();
        ASTConverter15Test.assertEquals((String)"Wrong size", (int)1, (int)typeParameters.length);
        ITypeBinding typeParameter = typeParameters[0];
        ASTConverter15Test.assertTrue((String)"Not a type variable", (boolean)typeParameter.isTypeVariable());
        ASTConverter15Test.assertEquals((String)"Wrong binary name", (String)"p.X$(Ljava/lang/Integer;)V$T", (String)typeParameter.getBinaryName());
    }

    public void test0244() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/xy/X.js", true);
        String contents = "package xy;\n\npublic class X {\n\tprotected class Inner {\n\t}\n\n\tInner[] i;\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        IJavaScriptElement element = typeBinding.getJavaElement();
        ASTConverter15Test.assertNotNull((String)"No element", (Object)element);
        ASTConverter15Test.assertTrue((String)"Doesn't exist", (boolean)element.exists());
        ASTConverter15Test.assertEquals((String)"Wrong handle identifier", (String)"=Converter15/src<xy{X.java[X[Inner", (String)element.getHandleIdentifier());
    }

    public void test0245() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/xy/X.js", true);
        String contents = "package xy;\n\npublic class X {\n\tprotected class Inner {\n\t}\n\n\tInner i;\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        IJavaScriptElement element = typeBinding.getJavaElement();
        ASTConverter15Test.assertNotNull((String)"No element", (Object)element);
        ASTConverter15Test.assertTrue((String)"Doesn't exist", (boolean)element.exists());
        ASTConverter15Test.assertEquals((String)"Wrong handle identifier", (String)"=Converter15/src<xy{X.java[X[Inner", (String)element.getHandleIdentifier());
    }

    public void test0246() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/xy/X.js", true);
        String contents = "package xy;\n\npublic class X {\n\tprotected class Inner {\n\t}\n\n\tInner[][] i;\n}";
        ASTNode node = this.buildAST(contents, this.workingCopy, true);
        ASTConverter15Test.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)node;
        this.assertProblemsSize(unit, 0);
        node = this.getASTNode(unit, 0, 1);
        ASTConverter15Test.assertEquals((String)"Not a field declaration", (int)23, (int)node.getNodeType());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverter15Test.assertNotNull((String)"No binding", (Object)typeBinding);
        IJavaScriptElement element = typeBinding.getJavaElement();
        ASTConverter15Test.assertNotNull((String)"No element", (Object)element);
        ASTConverter15Test.assertTrue((String)"Doesn't exist", (boolean)element.exists());
        ASTConverter15Test.assertEquals((String)"Wrong handle identifier", (String)"=Converter15/src<xy{X.java[X[Inner", (String)element.getHandleIdentifier());
    }
}

