/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.JavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.SearchTests;

public class WorkingCopySearchTests
extends JavaSearchTests {
    IJavaScriptUnit workingCopy;
    static /* synthetic */ Class class$0;

    public WorkingCopySearchTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.WorkingCopySearchTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return WorkingCopySearchTests.buildModelTestSuite(clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.workingCopy = this.getCompilationUnit("JavaSearch", "src", "wc", "X.js").getWorkingCopy(null);
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchyScopeOnWorkingCopy() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch", "src", "a9", "A.js");
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        try {
            IType type = copy.getType("A");
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            WorkingCopySearchTests.assertTrue((String)"a9.A should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)type));
            WorkingCopySearchTests.assertTrue((String)"a9.C should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)copy.getType("C")));
            WorkingCopySearchTests.assertTrue((String)"a9.B should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)copy.getType("B")));
            IPath path = unit.getUnderlyingResource().getFullPath();
            WorkingCopySearchTests.assertTrue((String)"a9/A.java should be included in hierarchy scope", (boolean)scope.encloses(path.toString()));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            copy.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        copy.discardWorkingCopy();
    }

    public void testAddNewType() throws CoreException {
        this.workingCopy.createType("class NewType {\n}", null, false, null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchPattern pattern = SearchPattern.createPattern((String)"NewType", (int)0, (int)0, (int)8);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/wc/X.java wc.NewType [NewType]", this.resultCollector);
    }

    public void testAllTypeNames1() throws CoreException {
        this.workingCopy.getBuffer().setContents("package wc;\npublic class Y {\n  interface I {\n  }\n}");
        this.workingCopy.makeConsistent(null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, null, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "wc.Y\nwc.Y$I", (Object)requestor);
    }

    public void testAllTypeNames2() throws CoreException {
        this.workingCopy.getBuffer().setContents("package wc;\npublic class Y {\n  interface I {\n  }\n}");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, null, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "wc.Y\nwc.Y$I", (Object)requestor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAllTypeNames3() throws CoreException {
        IJavaScriptUnit wc = this.getCompilationUnit("/JavaSearch/wc3/X44884.js");
        try {
            wc.becomeWorkingCopy(null, null);
            wc.getBuffer().setContents("package wc3;\npublic class X44884 {\n}\ninterface I {\n}");
            wc.makeConsistent(null);
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{wc.getParent()});
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            new SearchEngine().searchAllTypeNames("wc3".toCharArray(), 0, "X".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "wc3.X44884", (Object)requestor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            wc.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        wc.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAllTypeNames4() throws CoreException {
        IJavaScriptUnit wc = this.getCompilationUnit("/JavaSearch/wc3/X44884.js");
        try {
            wc.becomeWorkingCopy(null, null);
            wc.getBuffer().setContents("package wc3;\npublic class X44884 {\n}\ninterface I {\n}");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{wc.getParent()});
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            new SearchEngine().searchAllTypeNames("wc3".toCharArray(), 0, "X".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "wc3.X44884", (Object)requestor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            wc.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        wc.discardWorkingCopy();
    }

    public void testAllTypeNamesBug99915() throws CoreException {
        this.workingCopy.getBuffer().setContents("package wc;\npublic class X {\n}\n class AAABBB {}\n class BBBCCC {}\n");
        this.workingCopy.makeConsistent(null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, "A*".toCharArray(), 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "wc.AAABBB", (Object)requestor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAllTypeNamesBug98684() throws CoreException {
        try {
            IJavaScriptProject[] projects = new IJavaScriptProject[]{this.createJavaProject("P1"), this.createJavaProject("P2")};
            this.workingCopies = new IJavaScriptUnit[2];
            this.workingCopies[0] = this.getWorkingCopy("/P1/p1/A1.js", "package p1;\npublic class A1 {\n\tpublic static class A1Inner1 {}\tpublic static class A1Inner2 {}}");
            this.workingCopies[1] = this.getWorkingCopy("/P2/p2/A2.js", "package p2;\npublic class A2 {\n\tpublic static class A2Inner1 {}\tpublic static class A2Inner2 {}}");
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{projects[1]});
            new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "A".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "p2.A2\np2.A2$A2Inner1\np2.A2$A2Inner2", (Object)requestor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    public void testDeclarationOfReferencedTypes() throws CoreException {
        IFunction method = this.workingCopy.getType("X").createMethod("public void foo() {\n  X x = new X();\n}", null, true, null);
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("src/wc/X.java wc.X [X]", this.resultCollector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveType() throws CoreException {
        IJavaScriptUnit workingCopy1 = this.getCompilationUnit("JavaSearch", "src", "wc1", "X.js").getWorkingCopy(null);
        IJavaScriptUnit workingCopy2 = this.getCompilationUnit("JavaSearch", "src", "wc2", "Y.js").getWorkingCopy(null);
        try {
            workingCopy1.getType("X").move((IJavaScriptElement)workingCopy2, null, null, true, null);
            SearchEngine searchEngine = new SearchEngine(new IJavaScriptUnit[]{workingCopy1, workingCopy2});
            IJavaScriptSearchScope scope1 = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{workingCopy1.getParent()});
            SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)0, (int)8);
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope1, (SearchRequestor)this.resultCollector, null);
            WorkingCopySearchTests.assertEquals((String)"", (String)this.resultCollector.toString());
            IJavaScriptSearchScope scope2 = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{workingCopy2.getParent()});
            this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope2, (SearchRequestor)this.resultCollector, null);
            this.assertSearchResults("src/wc2/Y.java wc2.X [X]", this.resultCollector);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            workingCopy1.discardWorkingCopy();
            workingCopy2.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        workingCopy1.discardWorkingCopy();
        workingCopy2.discardWorkingCopy();
    }

    public void testRemoveType() throws CoreException {
        this.workingCopy.getType("X").delete(true, null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)0, (int)8);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("", this.resultCollector);
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/wc/X.java wc.X [X]", this.resultCollector);
    }
}

