/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrderByTests
extends JavaResourceModelTestCase {
    public OrderByTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOrderBy() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OrderBy"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderBy");
            }
        });
    }

    private ICompilationUnit createTestOrderByWithValue() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OrderBy"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderBy(value = \"key\")");
            }
        });
    }

    public void testOrderBy() throws Exception {
        ICompilationUnit cu = this.createTestOrderBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.OrderBy");
        OrderByTests.assertNotNull((Object)orderBy);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestOrderByWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.OrderBy");
        OrderByTests.assertEquals((String)"key", (String)orderBy.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestOrderBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("foo");
        this.assertSourceContains("@OrderBy(\"foo\")", cu);
        orderBy.setValue(null);
        this.assertSourceContains("@OrderBy", cu);
    }
}

