/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkIdMapping;
import org.eclipse.jpt.eclipselink.core.context.Mutable;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaIdMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableId() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableIdDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaIdMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaIdMappingTests.assertEquals((String)"eclipseLinkConverter", (String)idMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        EclipseLinkJavaIdMappingTests.assertEquals((String)"eclipseLinkConverter", (String)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertEquals((String)"class-instance", (String)((Convert)idMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        idMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)idMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        idMapping.setSpecifiedConverter(null);
        EclipseLinkJavaIdMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConvertAnnotation convert = (ConvertAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        EclipseLinkJavaIdMappingTests.assertEquals((String)"eclipseLinkConverter", (String)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertEquals((String)"foo", (String)((Convert)idMapping.getConverter()).getConverterName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        EclipseLinkJavaIdMappingTests.assertSame((Object)idMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableIdDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

