/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmNullAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmOneToOneMapping;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLink1_1OrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLink1_1OrmPersistentAttributeTests
extends EclipseLink1_1OrmContextModelTestCase {
    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetDataModelProvider());
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"eclipselink1_1");
        dataModel.setProperty("JpaFacetDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    public EclipseLink1_1OrmPersistentAttributeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityIdMappingPropertyAccess() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericOrmNullAttributeMapping));
        ormPersistentAttribute.makeSpecified("oneToOne");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmOneToOneMapping));
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.getMapping().setName("id2");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName(null);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
    }

    public void testGetJavaPersistentAttributeMixedAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getPersistentType().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentAttribute.setSpecifiedAccess(AccessType.FIELD);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccessPropertyInJava() throws Exception {
        this.createTestEntityIdMappingPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
    }
}

