/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.TransformationAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class TransformationAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public TransformationAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTransformation() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Transformation"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transformation");
            }
        });
    }

    private ICompilationUnit createTestTransformationWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Transformation"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transformation(optional = true)");
            }
        });
    }

    private ICompilationUnit createTestTransformationWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Transformation", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transformation(fetch = FetchType.EAGER)");
            }
        });
    }

    public void testTransformationAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestTransformation();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotationTests.assertNotNull((Object)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation"));
        attributeResource.setMappingAnnotation(null);
        TransformationAnnotationTests.assertNull((Object)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation"));
        attributeResource.setMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertNotNull((Object)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation"));
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)transformation.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)transformation.getOptional());
        transformation.setOptional(Boolean.FALSE);
        TransformationAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)transformation.getOptional());
        this.assertSourceContains("@Transformation(optional = false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)transformation.getOptional());
        transformation.setOptional(null);
        TransformationAnnotationTests.assertNull((Object)transformation.getOptional());
        this.assertSourceContains("@Transformation", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)transformation.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)transformation.getFetch());
        transformation.setFetch(FetchType.LAZY);
        TransformationAnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)transformation.getFetch());
        this.assertSourceContains("@Transformation(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestTransformationWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        TransformationAnnotation transformation = (TransformationAnnotation)attributeResource.getMappingAnnotation("org.eclipse.persistence.annotations.Transformation");
        TransformationAnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)transformation.getFetch());
        transformation.setFetch(null);
        TransformationAnnotationTests.assertNull((Object)transformation.getFetch());
        this.assertSourceContains("@Transformation", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }
}

