/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public abstract class PerformanceMeterFactory {
    private static Set fScenarios = new HashSet();

    public PerformanceMeter createPerformanceMeter(String scenario) {
        PerformanceMeterFactory.assertUniqueScenario(scenario);
        return this.doCreatePerformanceMeter(scenario);
    }

    public PerformanceMeter createPerformanceMeter(TestCase testCase, String monitorId) {
        return this.createPerformanceMeter(Performance.getDefault().getDefaultScenarioId(testCase, monitorId));
    }

    public PerformanceMeter createPerformanceMeter(TestCase testCase) {
        return this.createPerformanceMeter(Performance.getDefault().getDefaultScenarioId(testCase));
    }

    protected abstract PerformanceMeter doCreatePerformanceMeter(String var1);

    private static void assertUniqueScenario(String scenario) {
        if (fScenarios.contains(scenario)) {
            throw new IllegalArgumentException();
        }
        fScenarios.add(scenario);
    }
}

