/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.DeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;

public class GlobalDeleteAction
extends SelectionProviderAction {
    protected Shell shell;
    private DeleteAction serverDeleteAction = null;
    private boolean isRemoveServer = false;

    public GlobalDeleteAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.shell = shell;
        this.setEnabled(false);
        this.serverDeleteAction = new DeleteAction(shell, selectionProvider);
    }

    private boolean isRemoveModuleActionEnabled(IStructuredSelection sel) {
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        IModule[] moduleArray = null;
        Iterator iterator = sel.iterator();
        Object obj = iterator.next();
        if (obj instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)obj;
            moduleArray = ms.module;
        }
        if (iterator.hasNext()) {
            moduleArray = null;
        }
        return moduleArray == null || moduleArray.length == 1;
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.serverDeleteAction.selectionChanged(sel);
        if (this.serverDeleteAction.isEnabled()) {
            this.isRemoveServer = true;
            this.setEnabled(true);
            return;
        }
        if (this.isRemoveModuleActionEnabled(sel)) {
            this.isRemoveServer = false;
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.isRemoveServer) {
            this.serverDeleteAction.run();
            return;
        }
        IServer server = null;
        IModule[] moduleArray = null;
        IStructuredSelection sel = this.getStructuredSelection();
        if (!sel.isEmpty()) {
            Iterator iterator = sel.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                moduleArray = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                moduleArray = null;
            }
        }
        if (moduleArray != null && moduleArray.length == 1) {
            new RemoveModuleAction(this.shell, server, moduleArray[0]).run();
        }
    }
}

