/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class TestDefaultingFragment
extends AbstractDataModelOperation {
    private SelectionList testFacilities;
    private String launchedServiceTestName;
    private ScenarioContext scenarioContext;
    private boolean generateProxy;
    private String clientRuntimeId_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        this.scenarioContext = WebServicePlugin.getInstance().getScenarioContext().copy();
        if (this.generateProxy || this.testFacilities == null) {
            this.selectTestFacility();
        }
        return status;
    }

    public SelectionList getTestFacility() {
        return this.testFacilities;
    }

    private void selectTestFacility() {
        String[] testTypes = this.scenarioContext.getWebServiceTestTypes();
        ArrayList<String> newTestTypes = new ArrayList<String>();
        String[] wsdlCases = this.scenarioContext.getNonJavaTestService();
        boolean launched = false;
        int i = 0;
        while (i < testTypes.length) {
            WebServiceTestExtension extension = (WebServiceTestExtension)WebServiceTestRegistry.getInstance().getWebServiceExtensionsByName(testTypes[i]);
            if (this.clientRuntimeId_ == null || extension.supportsRuntime(this.clientRuntimeId_)) {
                if (testTypes[i].equals(this.launchedServiceTestName)) {
                    launched = true;
                } else {
                    newTestTypes.add(testTypes[i]);
                }
            }
            ++i;
        }
        if (launched) {
            newTestTypes.add(this.launchedServiceTestName);
        }
        if (!this.generateProxy) {
            this.testFacilities = new SelectionList(wsdlCases, 0);
        } else {
            String[] tempArray = new String[newTestTypes.size()];
            this.testFacilities = new SelectionList(newTestTypes.toArray(tempArray), 0);
        }
    }

    public void setServiceTestFacilities(SelectionList facilities) {
        this.testFacilities = facilities;
    }

    public void setLaunchedServiceTestName(String launchedServiceTestName) {
        this.launchedServiceTestName = launchedServiceTestName;
    }

    public void setGenerateProxy(boolean generateProxy) {
        this.generateProxy = generateProxy;
    }

    public void setClientRuntimeId(String clientRuntimeId) {
        this.clientRuntimeId_ = clientRuntimeId;
    }
}

