/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.layouts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BindingEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;

public class BindingColumnLayout
extends AbstractLayout {
    EditPart bindingColumnEditPart;

    public BindingColumnLayout(EditPart bindingColumnEditPart) {
        this.bindingColumnEditPart = bindingColumnEditPart;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Rectangle clientArea = container.getClientArea();
        Dimension d = this.calculateChildrenSize(container.getChildren(), wHint, hHint);
        d.height = Math.max(d.height, clientArea.height);
        return d;
    }

    private Dimension calculateChildrenSize(List children, int wHint, int hHint) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize(wHint, hHint);
            height += childSize.height;
            height += 80;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return new Dimension(Math.max(width, 150), height);
    }

    public void layout(IFigure container) {
        Rectangle clientArea = container.getClientArea();
        Rectangle r = new Rectangle();
        r.x = clientArea.x + 50;
        r.y = clientArea.y;
        Iterator i = container.getChildren().iterator();
        while (i.hasNext()) {
            Figure child = (Figure)i.next();
            Dimension d = child.getPreferredSize(-1, -1);
            r.width = d.width;
            r.height = d.height;
            child.setBounds(r);
            IFigure intefaceFigure = this.getInterfaceFigureForExpandedEditPartFigure(child);
            if (intefaceFigure != null) {
                Rectangle b = intefaceFigure.getBounds();
                int width = 30;
                child.setBounds(new Rectangle(b.x - width, b.y, width, b.height));
            }
            r.y += d.height;
            r.y += 80;
        }
    }

    public void setExpanded(BindingEditPart bindingEditPart, boolean isExpanded) {
        IInterface interfaze = this.getInterface(bindingEditPart);
        if (interfaze != null) {
            bindingEditPart.setExpanded(isExpanded);
            if (isExpanded) {
                Iterator i = this.bindingColumnEditPart.getChildren().iterator();
                while (i.hasNext()) {
                    BindingEditPart otherBindingEditPart = (BindingEditPart)i.next();
                    if (otherBindingEditPart == bindingEditPart || interfaze != this.getInterface(otherBindingEditPart)) continue;
                    otherBindingEditPart.setExpanded(false);
                }
            }
        }
    }

    private IFigure getInterfaceFigureForExpandedEditPartFigure(Figure editPartFigure) {
        Iterator i = this.bindingColumnEditPart.getChildren().iterator();
        while (i.hasNext()) {
            AbstractGraphicalEditPart interfaceEditPart;
            BindingEditPart bindingEditPart = (BindingEditPart)i.next();
            if (!bindingEditPart.isExpanded() || bindingEditPart.getFigure() != editPartFigure || (interfaceEditPart = this.getMatchingEditPart(this.getInterface(bindingEditPart))) == null) continue;
            return interfaceEditPart.getFigure();
        }
        return null;
    }

    private IInterface getInterface(BindingEditPart editPart) {
        IBinding binding = (IBinding)editPart.getModel();
        return binding.getInterface();
    }

    private AbstractGraphicalEditPart getMatchingEditPart(IInterface interfaze) {
        return (AbstractGraphicalEditPart)this.bindingColumnEditPart.getViewer().getEditPartRegistry().get(interfaze);
    }
}

