/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.XmlAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;

public class GenericJavaXmlAdapter
extends AbstractJavaContextNode
implements XmlAdapter {
    protected final JavaResourceType resourceType;
    protected String boundType;
    protected String valueType;

    public GenericJavaXmlAdapter(JaxbContextNode parent, JavaResourceType resourceType) {
        super(parent);
        this.resourceType = resourceType;
        this.initBoundAndValueTypes();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.resourceType;
    }

    @Override
    public IResource getResource() {
        return this.resourceType.getFile();
    }

    protected void initBoundAndValueTypes() {
        String[] types = this.findBoundAndValueTypes(this.getJavaResourceType());
        this.boundType = types[0];
        this.valueType = types[1];
    }

    @Override
    public void update() {
        super.update();
        this.updateBoundAndValueTypes();
    }

    protected void updateBoundAndValueTypes() {
        String[] types = this.findBoundAndValueTypes(this.getJavaResourceType());
        this.setBoundType_(types[0]);
        this.setValueType_(types[1]);
    }

    protected String[] findBoundAndValueTypes(JavaResourceType resourceType) {
        JavaResourceType superResourceType;
        for (JavaResourceMethod resourceMethod : resourceType.getMethods()) {
            if (!"marshal".equals(resourceMethod.getName()) || resourceMethod.getParametersSize() != 1) continue;
            String valueType = resourceMethod.getTypeBinding().getQualifiedName();
            String boundType = resourceMethod.getParameterTypeName(0);
            return new String[]{boundType, valueType};
        }
        String superResourceTypeName = resourceType.getSuperclassQualifiedName();
        if (!StringTools.isBlank((String)superResourceTypeName) && (superResourceType = (JavaResourceType)this.getJaxbProject().getJavaResourceType(superResourceTypeName, JavaResourceAnnotatedElement.AstNodeType.TYPE)) != null) {
            return this.findBoundAndValueTypes(superResourceType);
        }
        String objectTypeName = Object.class.getName();
        return new String[]{objectTypeName, objectTypeName};
    }

    @Override
    public String getBoundType() {
        return this.boundType;
    }

    protected void setBoundType_(String newType) {
        String oldType = this.boundType;
        this.boundType = newType;
        this.firePropertyChanged("boundType", oldType, newType);
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    protected void setValueType_(String newType) {
        String oldType = this.valueType;
        this.valueType = newType;
        this.firePropertyChanged("valueType", oldType, newType);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJavaResourceType().getNameTextRange();
    }
}

