/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.IBindingHandler;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class BindingHandlerDelegate
implements IBindingHandler {
    private static final String BINDING_DISABLED_IMAGE_FILE = "PD_Binding_disabled.gif";
    private static final String BINDING_IMAGE_FILE = "PD_Binding.gif";

    public String handleBinding(Shell shell, IDOMNode ancester, IDOMElement element, String currentValue) {
        IBindingHandler handler = this.getDelegatedHandler(ancester, element);
        if (handler != null) {
            return handler.handleBinding(shell, ancester, element, currentValue);
        }
        return null;
    }

    public boolean isEnabled(IDOMNode ancester, IDOMElement element, String uri, String tagName, IAttributeDescriptor attr) {
        IBindingHandler handler = this.getDelegatedHandler(ancester, element);
        return handler == null ? false : handler.isEnabled(ancester, element, uri, tagName, attr);
    }

    public Image getImage() {
        return PDPlugin.getDefault().getImage(BINDING_IMAGE_FILE);
    }

    public Image getDisabledImage() {
        return PDPlugin.getDefault().getImage(BINDING_DISABLED_IMAGE_FILE);
    }

    private IBindingHandler getDelegatedHandler(IDOMNode ancester, IDOMElement element) {
        Object obj;
        IProject project = this.getProject(ancester, element);
        if (project != null && (obj = project.getAdapter(IBindingHandler.class)) instanceof IBindingHandler) {
            return (IBindingHandler)obj;
        }
        return null;
    }

    private IProject getProject(IDOMNode ancester, IDOMElement element) {
        IDOMModel model = this.getModel(ancester, element);
        if (model != null) {
            return StructuredModelUtil.getProjectFor((IStructuredModel)model);
        }
        return null;
    }

    private IDOMModel getModel(IDOMNode ancester, IDOMElement element) {
        if (ancester != null) {
            return ancester.getModel();
        }
        if (element != null) {
            return element.getModel();
        }
        return null;
    }
}

