/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.internal.IGenericRuntime;
import org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class GenericRuntime
extends RuntimeDelegate
implements IGenericRuntime,
IGenericRuntimeWorkingCopy {
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            String id = this.getVMInstallId();
            IVMInstall[] iVMInstallArray = vmInstalls;
            int n = vmInstalls.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall vmInst = iVMInstallArray[n2];
                if (id.equals(vmInst.getId())) {
                    return vmInst;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        IRuntime runtime = this.getRuntime();
        IPath path = runtime.getLocation();
        if (!path.toFile().exists()) {
            return new Status(4, "org.eclipse.jst.server.core", 0, Messages.errorLocation, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.core", 0, Messages.errorJRE, null);
        }
        return Status.OK_STATUS;
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }
}

