/*******************************************************************************
 * Copyright (c) 2007 WSO2 Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * WSO2 Inc. - initial API and implementation
 * yyyymmdd bug      Email and other contact information
 * -------- -------- -----------------------------------------------------------
 * 20070222  168766 sandakith@wso2.com - Lahiru Sandakith, Initial code to introduse the Axis2 
 * 										  facet to the framework for 168766
 * 20070426   183046 sandakith@wso2.com - Lahiru Sandakith
 * 20070510   172926 sandakith@wso2.com - Lahiru Sandakith, Fix 172926 Use Util Classes
 * 20070606   177421 sandakith@wso2.com - fix web.xml wiped out when Axis2 facet
 * 20070612   192047 sandakith@wso2.com - Lahiru Sandakith, 192047
 * 20070612   192047 kathy@ca.ibm.com   - Kathy Chan
 * 20070813   196173  sandakith@wso2.com - Lahiru Sandakith, Fix 196173, DWP custom location fix
 * 20070824   200515 sandakith@wso2.com - Lahiru Sandakith, NON-NLS move to seperate file
 * 20100308	  282466 samindaw@wso2.com - Saminda Wijeratne, support for axis2 1.5
 *******************************************************************************/
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.axis2.core.constant.Axis2Constants;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class FacetContainerUtils {
	
	public static IPath getWorkspace(){
		return ResourcesPlugin.getWorkspace().getRoot().getLocation();
	}
	
	public static IProject getProjectName(String project){
		String projectString = replaceEscapecharactors(project.toString());
		return ResourcesPlugin.getWorkspace().getRoot().getProject(
				getProjectNameFromFramewokNameString(projectString));
	}
	
	public static IPath getProjectRoot(String project){
		String projectString = replaceEscapecharactors(project.toString());
		return ResourcesPlugin.getWorkspace().getRoot().getProject(
				getProjectNameFromFramewokNameString(projectString)).getLocation();
	}

	public static String  pathToWebProjectContainer(String project) {
		IPath projectRoot = getProjectRoot(project);
		IPath currentDynamicWebProjectDir = J2EEUtils.getWebContentPath(
				getProjectName(project));
		IPath currentDynamicWebProjectDirWithoutProjectRoot = J2EEUtils.getWebContentPath(
				getProjectName(project)).removeFirstSegments(1).makeAbsolute();
		if(projectRoot.toOSString().contains(getWorkspace().toOSString())){
			return getWorkspace()
						.append(currentDynamicWebProjectDir).toOSString();
		}else{
			return projectRoot
						.append(currentDynamicWebProjectDirWithoutProjectRoot).toOSString();
		}
		
	}
	
	public static String  pathToWebProjectContainerWEBINF(String project) {
		IPath projectRoot = getProjectRoot(project);
		IPath webContainerWEBINFDir = J2EEUtils.getWebInfPath(
				getProjectName(project));
		IPath webContainerWEBINFDirWithoutProjectRoot = J2EEUtils.getWebInfPath(
				getProjectName(project)).removeFirstSegments(1).makeAbsolute();
		if(projectRoot.toOSString().contains(getWorkspace().toOSString())){
			return getWorkspace()
						.append(webContainerWEBINFDir).toOSString();
		}else{
			return projectRoot
						.append(webContainerWEBINFDirWithoutProjectRoot).toOSString();
		}
	}
	
	public static String  pathToWebProjectContainerMETAINF(String project) {
		String containerDirectory = pathToWebProjectContainer(project);
		String webContainerMETAINF = Axis2Constants.DIR_META_INF;
		String webContainerMETAINFString = Axis2CoreUtils.addAnotherNodeToPath(
												containerDirectory,
												webContainerMETAINF);
		return webContainerMETAINFString;
	}
	
	public static String  pathToWebProjectContainerAxis2Web(String project) {
		String containerDirectory = pathToWebProjectContainer(project);
		String webContainerAxis2Web = Axis2Constants.DIR_AXIS2_WEB;
		String webContainerAxis2WebString = Axis2CoreUtils.addAnotherNodeToPath(
				containerDirectory,
												webContainerAxis2Web);
		return webContainerAxis2WebString;
	}
	
	public static String pathToWebProjectContainerLib(String project){
		String webContainerWEBINFString = pathToWebProjectContainerWEBINF(project);
		return  Axis2CoreUtils.addAnotherNodeToPath(
				webContainerWEBINFString,
				Axis2Constants.DIR_LIB);
		
	}
	
	public static String pathToWebProjectContainerWebXML(String project){
		String webContainerWEBINFString = pathToWebProjectContainerWEBINF(project);
		return  Axis2CoreUtils.addAnotherNodeToPath(
				webContainerWEBINFString,
				"web.xml");
	}
	
	//Fix for the windows build not working
	private static String replaceEscapecharactors(String vulnarableString){
		if (vulnarableString.indexOf("/")!=-1){
			vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
		}
		return vulnarableString;
	}
	
	
	private static String getProjectNameFromFramewokNameString(String frameworkProjectString){
		if (frameworkProjectString.indexOf(getSplitCharactor())== -1){
			return frameworkProjectString;
		}else{
			return frameworkProjectString.split(getSplitCharactors())[1];
		}
	}
	
	
	private static String getSplitCharactor(){
		//Windows check (because from inside wtp in return I received a hard coded path)
		if (File.separatorChar == '\\'){
			return "\\" ;
		}else{
			return File.separator;
		}
	}
	
	public static String pathToAxis2CoreFacetTempDirectory(String project){
	//
		String pluginAxis2CoreTempDir = WebServiceAxis2CorePlugin
        .getInstance().getStateLocation().toOSString();
		String projectString = replaceEscapecharactors(project);
		return FileUtils.addAnotherNodeToPath(pluginAxis2CoreTempDir, projectString);
		
		
	}
	
	private static String getSplitCharactors(){
		//Windows check (because from inside wtp in return I received a hard coded path)
		if (File.separatorChar == '\\'){
			return "\\" + File.separator;
		}else{
			return File.separator;
		}
	}
	
	
	public static String getDeployedWSDLURL(IProject serverProject, 
											String ServerFactoryId, 
											String ServerInstanceId,
											String serviceName){ 
		// Note that ServerCore.findServer() might return null if the server cannot be found and
		// ServerUtils.getEncodedWebComponentURL() can handle null server properly (by using ServerFactoryId)
		String deployedWSDLURLpath = null;
		IServer server = null;
		if (ServerInstanceId != null) {
			server = ServerCore.findServer(ServerInstanceId);
		}
		deployedWSDLURLpath = ServerUtils.getEncodedWebComponentURL(serverProject, 
				ServerFactoryId, server);
		if (deployedWSDLURLpath == null) {
			deployedWSDLURLpath = Axis2Constants.LOCAL_SERVER_PORT;
		}
		String[] deployedWSDLURLParts = {Axis2Constants.SERVICES,serviceName};
		return FileUtils.addNodesToURL(deployedWSDLURLpath, deployedWSDLURLParts)+"?wsdl";
	}
	
	public static String getAxis2WebContainerLibPath(IProject project){
		return getAxis2WebContainerLibPath(FacetContainerUtils.pathToWebProjectContainer(
				project.toString()));
	}
	
	public static String getAxis2WebContainerLibPath(String webcontainerPath){
		return FileUtils.addAnotherNodeToPath(getAxis2WebContainerWEB_INFPath(webcontainerPath),
				Axis2Constants.DIR_LIB);
	}
	
	public static String getAxis2WebContainerwebinfClassPath(IProject project){
		return getAxis2WebContainerwebinfClassPath(FacetContainerUtils.pathToWebProjectContainer(
				project.toString()));
	}
	
	public static String getAxis2WebContainerwebinfClassPath(String webcontainerPath){
		return FileUtils.addAnotherNodeToPath(getAxis2WebContainerWEB_INFPath(webcontainerPath),
				Axis2Constants.DIR_CLASSES);
	}
	
	public static String getAxis2WebContainerRepositoryPath(String webcontainerPath){
		return FileUtils.addAnotherNodeToPath(getAxis2WebContainerWEB_INFPath(webcontainerPath),
				Axis2Constants.DIR_SERVICES);
	}
	
	public static String getAxis2WebContainerWEB_INFPath(String webcontainerPath){
		return  FileUtils.addAnotherNodeToPath(webcontainerPath,Axis2Constants.DIR_WEB_INF);
	}
	
	
}
