/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.MediaType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBContextFactory {
    @Deprecated
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    @Deprecated
    public static final String DEFAULT_TARGET_NAMESPACE_KEY = "defaultTargetNamespace";
    @Deprecated
    public static final String ANNOTATION_HELPER_KEY = "annotationHelper";
    public static final String PKG_SEPARATOR = ".";

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0) {
            loader = classesToBeBound[0].getClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Type[] types = new Type[classesToBeBound.length];
        System.arraycopy(classesToBeBound, 0, types, 0, classesToBeBound.length);
        return JAXBContextFactory.createContext(types, properties, classLoader);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        JAXBContext.ContextPathInput contextInput = new JAXBContext.ContextPathInput(contextPath, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        HashMap<Type, TypeMappingInfo> typeToTypeMappingInfo = new HashMap<Type, TypeMappingInfo>();
        TypeMappingInfo[] typeMappingInfos = new TypeMappingInfo[typesToBeBound.length];
        int i = 0;
        while (i < typesToBeBound.length) {
            TypeMappingInfo tmi = new TypeMappingInfo();
            tmi.setType(typesToBeBound[i]);
            typeToTypeMappingInfo.put(typesToBeBound[i], tmi);
            typeMappingInfos[i] = tmi;
            ++i;
        }
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(typeMappingInfos, properties, classLoader);
        context.setTypeToTypeMappingInfo(typeToTypeMappingInfo);
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(TypeMappingInfo[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        JAXBContext.TypeMappingInfoInput contextInput = new JAXBContext.TypeMappingInfoInput(typesToBeBound, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        Map<String, List<XmlBindings>> bindings = new HashMap<String, List<XmlBindings>>();
        Object value = null;
        if (properties != null) {
            Object v = properties.get("eclipselink.oxm.metadata-source");
            value = v;
            if (v == null) {
                value = properties.get(ECLIPSELINK_OXM_XML_KEY);
            }
        }
        if (value != null) {
            if (value instanceof Map) {
                Map metadataFiles = null;
                try {
                    metadataFiles = value;
                }
                catch (ClassCastException classCastException) {
                    throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                }
                for (Map.Entry entry : metadataFiles.entrySet()) {
                    String key = null;
                    ArrayList<XmlBindings> xmlBindings = new ArrayList<XmlBindings>();
                    try {
                        key = (String)entry.getKey();
                        if (key == null) {
                            throw org.eclipse.persistence.exceptions.JAXBException.nullMapKey();
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw org.eclipse.persistence.exceptions.JAXBException.incorrectKeyParameterType();
                    }
                    Object metadataSource = entry.getValue();
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource((String)key);
                    }
                    if (metadataSource instanceof List) {
                        for (Object next : (List)metadataSource) {
                            XmlBindings binding = JAXBContextFactory.getXmlBindings(next, classLoader, properties);
                            if (binding == null) continue;
                            xmlBindings.add(binding);
                        }
                    } else {
                        XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader, properties);
                        if (binding != null) {
                            xmlBindings.add(binding);
                        }
                    }
                    if (xmlBindings == null) continue;
                    bindings.put(key, xmlBindings);
                }
            } else if (value instanceof List) {
                for (Object metadataSource : (List)value) {
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource();
                    }
                    bindings = JAXBContextFactory.processBindingFile(bindings, metadataSource, classLoader, properties);
                }
            } else {
                bindings = JAXBContextFactory.processBindingFile(bindings, value, classLoader, properties);
            }
        }
        HashMap<String, XmlBindings> mergedBindings = new HashMap<String, XmlBindings>(bindings.size());
        for (Map.Entry entry : bindings.entrySet()) {
            mergedBindings.put((String)entry.getKey(), XMLProcessor.mergeXmlBindings((List)entry.getValue()));
        }
        return mergedBindings;
    }

    private static Map<String, List<XmlBindings>> processBindingFile(Map<String, List<XmlBindings>> originalBindings, Object bindingHandle, ClassLoader classLoader, Map<String, Object> properties) {
        XmlBindings binding = JAXBContextFactory.getXmlBindings(bindingHandle, classLoader, properties);
        if (binding != null) {
            String key = binding.getPackageName();
            if (key.equals("##default")) {
                throw org.eclipse.persistence.exceptions.JAXBException.packageNotSetForBindingException();
            }
            List<XmlBindings> existingBindings = originalBindings.get(key);
            if (existingBindings != null) {
                existingBindings.add(binding);
            } else {
                existingBindings = new ArrayList<XmlBindings>();
                existingBindings.add(binding);
                originalBindings.put(key, existingBindings);
            }
        }
        return originalBindings;
    }

    private static XmlBindings getXmlBindings(Object metadata, ClassLoader classLoader, Map<String, Object> properties) {
        JAXBContext jaxbContext = CompilerHelper.getXmlBindingsModelContext();
        InputStream openedStream = null;
        try {
            JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", MediaType.APPLICATION_XML);
            unmarshaller.setProperty("eclipselink.auto-detect-media-type", true);
            unmarshaller.setProperty("eclipselink.json.include-root", false);
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            if (metadata instanceof MetadataSource) {
                XmlBindings xmlBindings = ((MetadataSource)metadata).getXmlBindings(properties, classLoader);
                return xmlBindings;
            }
            JAXBElement bindingsJaxbElement = null;
            if (metadata instanceof XMLEventReader) {
                bindingsJaxbElement = unmarshaller.unmarshal((XMLEventReader)metadata, XmlBindings.class);
            } else if (metadata instanceof XMLStreamReader) {
                bindingsJaxbElement = unmarshaller.unmarshal((XMLStreamReader)metadata, XmlBindings.class);
            } else {
                Source source = null;
                if (metadata instanceof File) {
                    source = new StreamSource(new FileInputStream((File)metadata));
                } else if (metadata instanceof InputSource) {
                    if (((InputSource)metadata).getByteStream() != null) {
                        source = new StreamSource(((InputSource)metadata).getByteStream());
                    } else if (((InputSource)metadata).getCharacterStream() != null) {
                        source = new StreamSource(((InputSource)metadata).getCharacterStream());
                    }
                } else if (metadata instanceof InputStream) {
                    source = new StreamSource((InputStream)metadata);
                } else if (metadata instanceof Node) {
                    source = new DOMSource((Node)metadata);
                } else if (metadata instanceof Reader) {
                    source = new StreamSource((Reader)metadata);
                } else if (metadata instanceof Source) {
                    source = (Source)metadata;
                } else if (metadata instanceof URL) {
                    openedStream = ((URL)metadata).openStream();
                    source = new StreamSource(openedStream);
                } else if (metadata instanceof String) {
                    StreamSource streamSource = new StreamSource((String)metadata);
                    try {
                        bindingsJaxbElement = unmarshaller.unmarshal(streamSource, XmlBindings.class);
                    }
                    catch (JAXBException e) {
                        openedStream = classLoader.getResourceAsStream((String)metadata);
                        if (openedStream != null) {
                            bindingsJaxbElement = unmarshaller.unmarshal(new StreamSource(openedStream), XmlBindings.class);
                        }
                        throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)e));
                    }
                } else {
                    throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                }
                if (bindingsJaxbElement == null) {
                    if (source == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                    }
                    bindingsJaxbElement = unmarshaller.unmarshal(source, XmlBindings.class);
                }
            }
            if (bindingsJaxbElement != null) {
                XmlBindings xmlBindings = (XmlBindings)bindingsJaxbElement.getValue();
                return xmlBindings;
            }
            try {
                throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
            }
            catch (JAXBException ex) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)ex));
            }
            catch (IOException ioException) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)ioException);
            }
        }
        finally {
            if (openedStream != null) {
                try {
                    openedStream.close();
                }
                catch (IOException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)e);
                }
            }
        }
    }
}

