/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.reconcile.AbstractStructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;

public abstract class AbstractStructuredFoldingStrategy
extends AbstractStructuredTextReconcilingStrategy
implements IProjectionListener {
    public static final String ID = "foldingstrategy";
    public static final String FOLDING_ENABLED = "foldingEnabled";
    protected ProjectionAnnotationModel fProjectionAnnotationModel;
    private ProjectionViewer fViewer;
    private IReconcileStep fFoldingStep;

    public void setViewer(ProjectionViewer viewer) {
        super.setViewer((SourceViewer)viewer);
        if (this.fViewer != null) {
            this.fViewer.removeProjectionListener((IProjectionListener)this);
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fProjectionAnnotationModel = this.fViewer.getProjectionAnnotationModel();
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.fViewer != null) {
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
        }
        this.fFoldingStep = null;
        this.projectionDisabled();
    }

    @Override
    public void setDocument(IDocument document) {
        super.setDocument(document);
    }

    public void projectionDisabled() {
        this.fProjectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        if (this.fViewer != null) {
            this.fProjectionAnnotationModel = this.fViewer.getProjectionAnnotationModel();
        }
    }

    @Override
    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IStructuredModel model = null;
        if (this.fProjectionAnnotationModel != null) {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
                if (model != null) {
                    IStructuredDocument structDoc = model.getStructuredDocument();
                    IStructuredDocumentRegion[] structRegions = structDoc.getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
                    Set indexedRegions = this.getIndexedRegions(model, structRegions);
                    ArrayList modifications = new ArrayList();
                    ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
                    HashMap<FoldingAnnotation, Position> additions = new HashMap<FoldingAnnotation, Position>();
                    boolean isInsert = dirtyRegion.getType().equals("__insert");
                    boolean isRemove = dirtyRegion.getType().equals("__remove");
                    this.markInvalidAnnotationsForDeletion(dirtyRegion, deletions);
                    Iterator indexedRegionsIter = indexedRegions.iterator();
                    while (indexedRegionsIter.hasNext() && this.fProjectionAnnotationModel != null) {
                        IndexedRegion indexedRegion = (IndexedRegion)indexedRegionsIter.next();
                        if (!this.indexedRegionValidType(indexedRegion)) continue;
                        FoldingAnnotation annotation = new FoldingAnnotation(indexedRegion, false);
                        if (isInsert) {
                            Annotation existingAnno = this.getExistingAnnotation(indexedRegion);
                            if (existingAnno == null) {
                                Position newPos = this.calcNewFoldPosition(indexedRegion);
                                if (newPos == null || newPos.length <= 0) continue;
                                additions.put(annotation, newPos);
                                continue;
                            }
                            this.updateAnnotations(existingAnno, indexedRegion, additions, modifications, deletions);
                            continue;
                        }
                        if (!isRemove) continue;
                        deletions.add(annotation);
                    }
                    if (this.fProjectionAnnotationModel != null) {
                        this.fProjectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[1]), additions, modifications.toArray(new Annotation[0]));
                    }
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    protected abstract Position calcNewFoldPosition(IndexedRegion var1);

    protected void updateAnnotations(Annotation existingAnnotation, IndexedRegion dirtyRegion, Map additions, List modifications, List deletions) {
        if (existingAnnotation instanceof FoldingAnnotation) {
            FoldingAnnotation foldingAnnotation = (FoldingAnnotation)existingAnnotation;
            Position newPos = this.calcNewFoldPosition(foldingAnnotation.getRegion());
            if (newPos != null && newPos.length > 0 && this.fProjectionAnnotationModel != null) {
                Position oldPos = this.fProjectionAnnotationModel.getPosition((Annotation)foldingAnnotation);
                if (!newPos.equals((Object)oldPos)) {
                    oldPos.setOffset(newPos.offset);
                    oldPos.setLength(newPos.length);
                    modifications.add(foldingAnnotation);
                }
            } else {
                deletions.add(foldingAnnotation);
            }
        }
    }

    protected void markInvalidAnnotationsForDeletion(DirtyRegion dirtyRegion, List deletions) {
        Iterator iter = this.getAnnotationIterator(dirtyRegion);
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                if (!(anno instanceof FoldingAnnotation)) continue;
                Position pos = this.fProjectionAnnotationModel.getPosition(anno);
                if (pos.length != 0) continue;
                deletions.add(anno);
            }
        }
    }

    protected abstract boolean indexedRegionValidType(IndexedRegion var1);

    @Override
    protected boolean containsStep(IReconcileStep step) {
        return this.fFoldingStep.equals(step);
    }

    @Override
    public void createReconcileSteps() {
        this.fFoldingStep = new StructuredReconcileStep(){};
    }

    private Iterator getAnnotationIterator(DirtyRegion dirtyRegion) {
        Iterator annoIter = null;
        if (this.fProjectionAnnotationModel != null) {
            int offset = dirtyRegion.getOffset();
            if (offset > 0) {
                --offset;
            }
            annoIter = this.fProjectionAnnotationModel.getAnnotationIterator(offset, dirtyRegion.getLength(), false, false);
        }
        return annoIter;
    }

    private Annotation getExistingAnnotation(IndexedRegion indexedRegion) {
        Iterator iter = this.fProjectionAnnotationModel.getAnnotationIterator(indexedRegion.getStartOffset(), 1, false, true);
        Annotation anno = null;
        if (iter.hasNext()) {
            anno = (Annotation)iter.next();
        }
        return anno;
    }

    private Set getIndexedRegions(IStructuredModel model, IStructuredDocumentRegion[] structRegions) {
        HashSet<IndexedRegion> indexedRegions = new HashSet<IndexedRegion>(structRegions.length);
        int structRegionIndex = 0;
        while (structRegionIndex < structRegions.length && this.fProjectionAnnotationModel != null) {
            IStructuredDocumentRegion structuredDocumentRegion = structRegions[structRegionIndex];
            int offset = structuredDocumentRegion.getStartOffset();
            IndexedRegion indexedRegion = model.getIndexedRegion(offset);
            indexedRegions.add(indexedRegion);
            if (structuredDocumentRegion.getEndOffset() > indexedRegion.getEndOffset()) {
                ITextRegionList textRegions = structuredDocumentRegion.getRegions();
                int textRegionCount = textRegions.size();
                int textRegionIndex = 1;
                while (textRegionIndex < textRegionCount) {
                    offset = structuredDocumentRegion.getStartOffset(textRegions.get(textRegionIndex));
                    indexedRegion = model.getIndexedRegion(offset);
                    indexedRegions.add(indexedRegion);
                    ++textRegionIndex;
                }
            }
            ++structRegionIndex;
        }
        return indexedRegions;
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible;
        private IndexedRegion fRegion;

        public FoldingAnnotation(IndexedRegion region, boolean isCollapsed) {
            super(isCollapsed);
            this.fIsVisible = false;
            this.fRegion = region;
        }

        public IndexedRegion getRegion() {
            return this.fRegion;
        }

        public void setRegion(IndexedRegion region) {
            this.fRegion = region;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof FoldingAnnotation) {
                equal = this.fRegion.equals(((FoldingAnnotation)((Object)obj)).fRegion);
            }
            return equal;
        }

        public int hashCode() {
            return this.fRegion.hashCode();
        }

        public String toString() {
            return this.fRegion.toString();
        }
    }
}

