/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.queue.FixedCapacityArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.tests.internal.queue.QueueTests;

public class FixedCapacityArrayQueueTests
extends QueueTests {
    public FixedCapacityArrayQueueTests(String name) {
        super(name);
    }

    FixedCapacityArrayQueue<String> buildQueue() {
        return QueueTools.fixedCapacityArrayQueue((int)10);
    }

    public void testCollectionConstructor() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("first");
        c.add("second");
        c.add("third");
        c.add("fourth");
        c.add("fifth");
        c.add("sixth");
        c.add("seventh");
        c.add("eighth");
        c.add("ninth");
        c.add("tenth");
        FixedCapacityArrayQueue queue = QueueTools.fixedCapacityArrayQueue(c);
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"first", (String)((String)queue.peek()));
        FixedCapacityArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"third", (String)((String)queue.peek()));
        FixedCapacityArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testIsFull() {
        FixedCapacityArrayQueue<String> queue = this.buildQueue();
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isFull());
        queue.enqueue((Object)"first");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isFull());
        queue.enqueue((Object)"second");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isFull());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isFull());
        queue.dequeue();
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        queue.dequeue();
        queue.dequeue();
        queue.dequeue();
        queue.dequeue();
        queue.dequeue();
        queue.dequeue();
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isFull());
    }

    public void testWrappedElements() {
        FixedCapacityArrayQueue<String> queue = this.buildQueue();
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        FixedCapacityArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        FixedCapacityArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceeded() {
        FixedCapacityArrayQueue<String> queue = this.buildQueue();
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        boolean exCaught = false;
        try {
            queue.enqueue((Object)"eleventh");
            FixedCapacityArrayQueueTests.fail((String)"bogus");
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayQueueTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElements() {
        FixedCapacityArrayQueue<String> queue = this.buildQueue();
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        FixedCapacityArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        queue.enqueue((Object)"thirteenth");
        boolean exCaught = false;
        try {
            queue.enqueue((Object)"fourteenth");
            FixedCapacityArrayQueueTests.fail((String)"bogus");
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayQueueTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeue()));
        FixedCapacityArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }
}

