/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.FixedCapacityArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.queue.ListQueue;
import org.eclipse.jpt.common.utility.internal.queue.PriorityQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.queue.SynchronizedQueue;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class QueueToolsTests
extends TestCase {
    public static final Transformer<String, String> FIRST_LETTER_TRANSFORMER = new FirstLetterTransformer();
    public static final Transformer<String, String> EMPHASIZER = new StringTools.CharDelimiter('*');

    public QueueToolsTests(String name) {
        super(name);
    }

    public void testEnqueueAllIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertTrue((boolean)QueueTools.enqueueAll((Queue)queue, iterable));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testEnqueueAllIterable_empty() {
        ArrayList iterable = new ArrayList();
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertFalse((boolean)QueueTools.enqueueAll((Queue)queue, iterable));
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueAllIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertTrue((boolean)QueueTools.enqueueAll((Queue)queue, iterable.iterator()));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testEnqueueAllArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertTrue((boolean)QueueTools.enqueueAll((Queue)queue, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testEnqueueAllArray_empty() {
        ArrayList iterable = new ArrayList();
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertFalse((boolean)QueueTools.enqueueAll((Queue)queue, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrain() {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        queue.enqueue((Object)"three");
        ArrayList list = QueueTools.drain((Queue)queue);
        QueueToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        QueueToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        QueueToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainToCollection() {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        queue.enqueue((Object)"three");
        ArrayList list = new ArrayList();
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, list));
        QueueToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        QueueToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        QueueToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainToCollection_empty() {
        ArrayQueue queue = QueueTools.arrayQueue();
        ArrayList list = new ArrayList();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue, list));
        QueueToolsTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainToListIndex() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"aaa");
        queue.enqueue((Object)"bbb");
        queue.enqueue((Object)"ccc");
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, list, (int)2));
        QueueToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        QueueToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        QueueToolsTests.assertEquals((String)"aaa", (String)((String)list.get(2)));
        QueueToolsTests.assertEquals((String)"bbb", (String)((String)list.get(3)));
        QueueToolsTests.assertEquals((String)"ccc", (String)((String)list.get(4)));
        QueueToolsTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainToListIndex_end() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"aaa");
        queue.enqueue((Object)"bbb");
        queue.enqueue((Object)"ccc");
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, list, (int)3));
        QueueToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        QueueToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        QueueToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
        QueueToolsTests.assertEquals((String)"aaa", (String)((String)list.get(3)));
        QueueToolsTests.assertEquals((String)"bbb", (String)((String)list.get(4)));
        QueueToolsTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testDrainToListIndex_empty() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue, list, (int)3));
        QueueToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        QueueToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        QueueToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainToStack() {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        queue.enqueue((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, (Stack)stack));
        QueueToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        QueueToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testDrainToStack_empty() {
        ArrayQueue queue = QueueTools.arrayQueue();
        ArrayStack stack = StackTools.arrayStack();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue, (Stack)stack));
        QueueToolsTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainToQueue() {
        ArrayQueue queue1 = QueueTools.arrayQueue();
        queue1.enqueue((Object)"one");
        queue1.enqueue((Object)"two");
        queue1.enqueue((Object)"three");
        ArrayQueue queue2 = QueueTools.arrayQueue();
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue1, (Queue)queue2));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue2.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue2.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue2.dequeue()));
    }

    public void testDrainToQueue_empty() {
        ArrayQueue queue1 = QueueTools.arrayQueue();
        ArrayQueue queue2 = QueueTools.arrayQueue();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue1, (Queue)queue2));
        QueueToolsTests.assertTrue((boolean)queue2.isEmpty());
    }

    public void testDrainToMapTransformer() {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"zero");
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        HashMap map = new HashMap();
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, map, FIRST_LETTER_TRANSFORMER));
        QueueToolsTests.assertEquals((String)"one", (String)((String)map.get("o")));
        QueueToolsTests.assertEquals((String)"two", (String)((String)map.get("t")));
        QueueToolsTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainToMapTransformer_empty() {
        ArrayQueue queue = QueueTools.arrayQueue();
        HashMap map = new HashMap();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue, map, FIRST_LETTER_TRANSFORMER));
        QueueToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainToMapTransformerTransformer() {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"zero");
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        HashMap map = new HashMap();
        QueueToolsTests.assertTrue((boolean)QueueTools.drainTo((Queue)queue, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        QueueToolsTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        QueueToolsTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        QueueToolsTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainToMapTransformerTransformer_empty() {
        ArrayQueue queue = QueueTools.arrayQueue();
        HashMap map = new HashMap();
        QueueToolsTests.assertFalse((boolean)QueueTools.drainTo((Queue)queue, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        QueueToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testArrayQueue() {
        ArrayQueue queue = QueueTools.arrayQueue();
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayQueueInt() {
        ArrayQueue queue = QueueTools.arrayQueue((int)20);
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
        QueueToolsTests.assertEquals((int)20, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testArrayQueueIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue(iterable);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testArrayQueueIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue(iterable, (int)5);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testArrayQueueIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue(iterable.iterator());
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testArrayQueueIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue(iterable.iterator(), (int)5);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testArrayQueueArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayQueue queue = QueueTools.arrayQueue((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testLinkedQueue() {
        LinkedQueue queue = QueueTools.linkedQueue();
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testLinkedQueueInt() {
        LinkedQueue queue = QueueTools.linkedQueue((int)20);
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testLinkedQueueIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedQueue queue = QueueTools.linkedQueue(iterable);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testLinkedQueueIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedQueue queue = QueueTools.linkedQueue(iterable, (int)5);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testLinkedQueueIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedQueue queue = QueueTools.linkedQueue(iterable.iterator());
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testLinkedQueueIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedQueue queue = QueueTools.linkedQueue(iterable.iterator(), (int)5);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testLinkedQueueArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedQueue queue = QueueTools.linkedQueue((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testFixedCapacityArrayQueueCollection() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        FixedCapacityArrayQueue queue = QueueTools.fixedCapacityArrayQueue(iterable);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testPriorityQueueComparator() {
        PriorityQueue queue = QueueTools.priorityQueue((Comparator)ComparatorTools.reverseComparator());
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueToolsTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)first, (String)((String)queue.dequeue()));
    }

    public void testPriorityQueueObjectArray() {
        String first = "first";
        String second = "second";
        String third = "third";
        String[] stringArray = new String[4];
        stringArray[1] = second;
        stringArray[2] = first;
        stringArray[3] = third;
        String[] array = stringArray;
        PriorityQueue queue = QueueTools.priorityQueue((Comparable[])array);
        QueueToolsTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)third, (String)((String)queue.dequeue()));
    }

    public void testPriorityQueueComparatorObjectArray() {
        String first = "first";
        String second = "second";
        String third = "third";
        Object[] objectArray = new String[4];
        objectArray[1] = first;
        objectArray[2] = second;
        objectArray[3] = third;
        Object[] array = objectArray;
        PriorityQueue queue = QueueTools.priorityQueue((Comparator)ComparatorTools.reverseComparator(), (Object[])array);
        QueueToolsTests.assertEquals((String)third, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)first, (String)((String)queue.dequeue()));
    }

    public void testSynchronizedQueueObject() {
        Object lock = new Object();
        SynchronizedQueue queue = QueueTools.synchronizedQueue((Object)lock);
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueToolsTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((Object)lock, (Object)queue.getMutex());
    }

    public void testSynchronizedQueueQueueObject() {
        Object lock = new Object();
        ArrayQueue innerQueue = QueueTools.arrayQueue();
        String first = "first";
        String second = "second";
        innerQueue.enqueue((Object)first);
        innerQueue.enqueue((Object)second);
        SynchronizedQueue queue = QueueTools.synchronizedQueue((Queue)innerQueue, (Object)lock);
        QueueToolsTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((Object)lock, (Object)queue.getMutex());
    }

    public void testAdaptList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ListQueue queue = QueueTools.adapt(list);
        QueueToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        QueueToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testEmptyQueue() {
        Queue queue = QueueTools.emptyQueue();
        QueueToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(QueueTools.class);
                QueueToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        QueueToolsTests.assertTrue((boolean)exCaught);
    }

    static class FirstLetterTransformer
    implements Transformer<String, String> {
        FirstLetterTransformer() {
        }

        public String transform(String string) {
            return string.substring(0, 1);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

