/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashSet;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTML2TextReader;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class ContentAssistTestUtilities {
    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals) throws Exception {
        ContentAssistTestUtilities.runProposalTest(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals, false, true);
    }

    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, boolean negativeTest, boolean exactMatch) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposal(pages, expectedProposals, negativeTest, exactMatch, false);
    }

    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, boolean negativeTest, boolean exactMatch, boolean inOrder) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposal(pages, expectedProposals, negativeTest, exactMatch, inOrder);
    }

    public static void runProposalInfoTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, String[][] expectedProposalInfo) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposalInfo(pages, expectedProposals, expectedProposalInfo);
    }

    public static void verifyNoDuplicates(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset) throws Exception {
        int numOfPages = 1;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, numOfPages);
        ContentAssistTestUtilities.checkForDuplicates(pages, numOfPages);
    }

    public static void runHTMLProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, boolean negativeTest, boolean exactMatch) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getHTMLProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposal(pages, expectedProposals, negativeTest, exactMatch, false);
    }

    private static ICompletionProposal[][] getProposals(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, int numOfPages) throws Exception {
        IFile file = testProject.getFile(filePath);
        AbstractTextEditor editor = testProject.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(editor, offset, numOfPages);
        return pages;
    }

    private static ICompletionProposal[][] getProposals(AbstractTextEditor editor, int offset, int pageCount) throws Exception {
        ICompletionProposal[][] pages = null;
        if (editor instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)editor).getViewer();
            JavaScriptSourceViewerConfiguration configuration = new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), JavaScriptPlugin.getDefault().getCombinedPreferenceStore(), (ITextEditor)editor, "___java_partitioning");
            ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant(viewer);
            String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
            IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
            Method privateFireSessionBeginEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
            privateFireSessionBeginEventMethod.setAccessible(true);
            privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
            pages = new ICompletionProposal[pageCount][];
            int p = 0;
            while (p < pageCount) {
                pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
                ++p;
            }
            Method privateFireSessionEndEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionEndEvent", null);
            privateFireSessionEndEventMethod.setAccessible(true);
            privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        } else if (editor instanceof StructuredTextEditor) {
            StructuredTextViewer viewer = ((StructuredTextEditor)editor).getTextViewer();
            StructuredTextViewerConfigurationHTML configuration = new StructuredTextViewerConfigurationHTML();
            ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant((ISourceViewer)viewer);
            viewer.configure((SourceViewerConfiguration)configuration);
            viewer.setSelectedRange(offset, 0);
            String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
            IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
            Method privateFireSessionBeginEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
            privateFireSessionBeginEventMethod.setAccessible(true);
            privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
            pages = new ICompletionProposal[pageCount][];
            int p = 0;
            while (p < pageCount) {
                pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
                ++p;
            }
            Method privateFireSessionEndEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionEndEvent", null);
            privateFireSessionEndEventMethod.setAccessible(true);
            privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        }
        return pages;
    }

    private static void verifyExpectedProposal(ICompletionProposal[][] pages, String[][] expectedProposals, boolean negativeTest, boolean exactMatch, boolean inOrder) {
        StringBuffer error = new StringBuffer();
        int lastFoundIndex = -1;
        String lastFoundProposal = "";
        int page = 0;
        while (page < expectedProposals.length) {
            int expected = 0;
            while (expected < expectedProposals[page].length) {
                String expectedProposal = expectedProposals[page][expected];
                boolean found = false;
                int suggestion = 0;
                while (suggestion < pages[page].length && !found) {
                    String displayString = pages[page][suggestion].getDisplayString();
                    found = exactMatch ? displayString.equals(expectedProposal) : displayString.indexOf(expectedProposal) != -1;
                    ++suggestion;
                }
                if (inOrder && found && suggestion < lastFoundIndex) {
                    error.append("\nProposal was found out of order: " + expectedProposal + " found before " + lastFoundProposal);
                }
                if (found && negativeTest) {
                    error.append("\nUnexpected proposal was found on page " + page + ": '" + expectedProposal + "'");
                } else if (!found && !negativeTest) {
                    error.append("\n Expected proposal was not found on page " + page + ": '" + expectedProposal + "'");
                }
                if (found) {
                    lastFoundProposal = expectedProposal;
                    lastFoundIndex = suggestion;
                }
                ++expected;
            }
            ++page;
        }
        if (error.length() > 0) {
            StringBuffer expected = new StringBuffer();
            int i = 0;
            while (i < expectedProposals.length) {
                int j = 0;
                while (j < expectedProposals[i].length) {
                    expected.append(expectedProposals[i][j]);
                    expected.append('\n');
                    ++j;
                }
                ++i;
            }
            StringBuffer actual = new StringBuffer();
            int i2 = 0;
            while (i2 < pages.length) {
                int j = 0;
                while (j < pages[i2].length) {
                    actual.append(pages[i2][j].getDisplayString());
                    actual.append('\n');
                    ++j;
                }
                ++i2;
            }
            Assert.assertEquals((String)error.toString(), (String)expected.toString(), (String)actual.toString());
        }
    }

    private static void verifyExpectedProposalInfo(ICompletionProposal[][] pages, String[][] expectedProposals, String[][] expectedProposalsInfo) {
        StringBuffer error = new StringBuffer();
        String proposalInfo = new String();
        int page = 0;
        while (page < expectedProposals.length) {
            int expected = 0;
            while (expected < expectedProposals[page].length) {
                String expectedProposal = expectedProposals[page][expected];
                String expectedProposalInfo = expectedProposalsInfo[page][expected];
                boolean found = false;
                int suggestion = 0;
                while (suggestion < pages[page].length && !found) {
                    found = pages[page][suggestion].getDisplayString().equals(expectedProposal);
                    if (found) {
                        proposalInfo = pages[page][suggestion].getAdditionalProposalInfo();
                        if (proposalInfo != null && proposalInfo.indexOf(expectedProposalInfo) >= 0) break;
                        error.append("\nRequired proposal info for " + expectedProposal + " does not exist.");
                        break;
                    }
                    ++suggestion;
                }
                ++expected;
            }
            ++page;
        }
        if (error.length() > 0) {
            StringBuffer expected = new StringBuffer();
            int i = 0;
            while (i < expectedProposalsInfo.length) {
                int j = 0;
                while (j < expectedProposalsInfo[i].length) {
                    expected.append(expectedProposalsInfo[i][j]);
                    expected.append('\n');
                    ++j;
                }
                ++i;
            }
            StringBuffer actual = new StringBuffer();
            int i2 = 0;
            while (i2 < pages.length) {
                int j = 0;
                while (j < pages[i2].length) {
                    try {
                        actual.append(new HTML2TextReader((Reader)new StringReader(pages[i2][j].getAdditionalProposalInfo()), null).getString().trim());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    actual.append('\n');
                    ++j;
                }
                ++i2;
            }
            Assert.assertEquals((String)error.toString(), (String)expected.toString(), (String)actual.toString());
        }
    }

    private static void checkForDuplicates(ICompletionProposal[][] pages, int numOfPages) {
        HashSet<String> set = new HashSet<String>();
        StringBuffer error = new StringBuffer();
        int suggestion = 0;
        while (suggestion < pages[0].length) {
            if (set.contains(pages[0][suggestion].toString())) {
                error.append("\nDuplicate proposal found: '" + pages[0][suggestion] + "'");
            } else {
                set.add(pages[0][suggestion].toString());
            }
            ++suggestion;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
        set.clear();
    }

    private static ICompletionProposal[][] getHTMLProposals(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, int numOfPages) throws Exception {
        IFile file = testProject.getFile(filePath);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.html.core.htmlsource.source");
        StructuredTextEditor editor = (StructuredTextEditor)part.getAdapter(ITextEditor.class);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getHTMLProposals(editor, offset, numOfPages);
        return pages;
    }

    private static ICompletionProposal[][] getHTMLProposals(StructuredTextEditor editor, int offset, int pageCount) throws Exception {
        StructuredTextViewer viewer = editor.getTextViewer();
        Method getSourceViewerConfiguration = AbstractTextEditor.class.getDeclaredMethod("getSourceViewerConfiguration", new Class[0]);
        getSourceViewerConfiguration.setAccessible(true);
        StructuredTextViewerConfiguration configuration = (StructuredTextViewerConfiguration)getSourceViewerConfiguration.invoke((Object)editor, null);
        IContentAssistant contentAssistant = configuration.getContentAssistant((ISourceViewer)viewer);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Method privateFireSessionBeginEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Method privateFireSessionEndEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        editor.close(false);
        return pages;
    }
}

