/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private static final String DES_ECB = "DES/ECB/PKCS5Padding";
    private final Cipher decryptCipherDES_ECB = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";
    private final Cipher decryptCipherAES_ECB;
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private final Cipher encryptCipherAES_CBC;
    private final Cipher decryptCipherAES_CBC;

    public JCEEncryptor() throws Exception {
        this.decryptCipherDES_ECB.init(2, Synergizer.getDESMultitasker());
        this.decryptCipherAES_ECB = Cipher.getInstance(AES_ECB);
        this.decryptCipherAES_ECB.init(2, Synergizer.getAESMultitasker());
        SecretKey sk = Synergizer.getAESCBCMultitasker();
        IvParameterSpec iv = Synergizer.getIvSpec();
        this.encryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.encryptCipherAES_CBC.init(1, (Key)sk, iv);
        this.decryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.decryptCipherAES_CBC.init(2, (Key)sk, iv);
    }

    @Override
    public synchronized String encryptPassword(String password) {
        try {
            return Helper.buildHexStringFromBytes(this.encryptCipherAES_CBC.doFinal(password.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized String decryptPassword(String encryptedPswd) {
        block36: {
            if (encryptedPswd == null) {
                return null;
            }
            password = null;
            bytePassword = new byte[]{};
            try {
                bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
                password = new String(this.decryptCipherAES_CBC.doFinal(bytePassword), "UTF-8");
            }
            catch (IllegalBlockSizeException | ConversionException v0) {
                password = encryptedPswd;
            }
            catch (Exception v1) {
                oisAes = null;
                try {
                    try {
                        oisAes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherAES_ECB));
                        password = (String)oisAes.readObject();
                    }
                    catch (Exception v2) {
                        block35: {
                            oisDes = null;
                            try {
                                oisDes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherDES_ECB));
                                password = (String)oisDes.readObject();
                            }
                            catch (ArrayIndexOutOfBoundsException v3) {
                                password = encryptedPswd;
                                if (oisDes != null) {
                                    try {
                                        oisDes.close();
                                    }
                                    catch (IOException v4) {}
                                }
                                break block35;
                            }
                            catch (Exception h) {
                                try {
                                    if (!(h.getCause() instanceof IllegalBlockSizeException)) {
                                        throw ValidationException.errorDecryptingPassword(h);
                                    }
                                    password = encryptedPswd;
                                    ** if (oisDes == null) goto lbl-1000
                                }
                                catch (Throwable var7_7) {
                                    if (oisDes != null) {
                                        try {
                                            oisDes.close();
                                        }
                                        catch (IOException v6) {}
                                    }
                                    throw var7_7;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        oisDes.close();
                                    }
                                    catch (IOException v5) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block35;
                                }
                            }
                            if (oisDes == null) break block35;
                            try {
                                oisDes.close();
                            }
                            catch (IOException v7) {}
                        }
                        if (oisAes != null) {
                            try {
                                oisAes.close();
                            }
                            catch (IOException v8) {}
                        }
                        break block36;
                    }
                }
                catch (Throwable var8_8) {
                    if (oisAes != null) {
                        try {
                            oisAes.close();
                        }
                        catch (IOException v9) {}
                    }
                    throw var8_8;
                }
                if (oisAes == null) break block36;
                try {
                    oisAes.close();
                }
                catch (IOException v10) {}
            }
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getDESMultitasker() throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }

        private static SecretKey getAESMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("3E7CFEF156E712906E1F603B59463C67"), "AES");
        }

        private static SecretKey getAESCBCMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("2DB7354A48F1CA7B48ACA247540FC923"), "AES");
        }

        private static IvParameterSpec getIvSpec() {
            byte[] b = new byte[]{-26, 124, -99, 32, -37, -58, -93, 100, 126, -55, -21, 48, -86, 97, 12, 113};
            return new IvParameterSpec(b);
        }
    }
}

