/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebSpherePlatformDetector
implements ServerPlatformDetector {
    private static final String[] LIBERTY_PROPS = new String[]{"server.config.dir", "server.output.dir"};
    private static final String LIBERTY_PROFILE_INFO_INT = "com.ibm.websphere.config.mbeans.FeatureListMBean";
    private static final String FULL_PROFILE_WAS_DIR_CLS = "com.ibm.websphere.product.WASDirectory";

    @Override
    public String checkPlatform() {
        if (this.isLiberty()) {
            return "WebSphere_Liberty";
        }
        if (this.isFullProfile()) {
            return "WebSphere_7";
        }
        return null;
    }

    private boolean isLiberty() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isLibertyInternal();
                }
            });
        }
        return this.isLibertyInternal();
    }

    private boolean isFullProfile() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isFullProfileInternal();
                }
            });
        }
        return this.isFullProfileInternal();
    }

    private Boolean isLibertyInternal() {
        if (!this.checkProperties(LIBERTY_PROPS).booleanValue() && !this.checkClassLoader(LIBERTY_PROFILE_INFO_INT).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean isFullProfileInternal() {
        return this.checkClassLoader(FULL_PROFILE_WAS_DIR_CLS);
    }

    private Boolean checkProperties(String[] props) {
        String[] stringArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (System.getProperty(prop) == null) {
                return Boolean.FALSE;
            }
            ++n2;
        }
        return Boolean.TRUE;
    }

    private Boolean checkClassLoader(String className) {
        try {
            ClassLoader loader = WebSpherePlatformDetector.class.getClassLoader();
            Class<?> cls = loader.loadClass(className);
            if (cls != null) {
                return Boolean.TRUE;
            }
        }
        catch (Throwable throwable) {}
        return Boolean.FALSE;
    }
}

