/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSImportRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelParser;
import org.eclipse.wst.css.core.internal.document.CSSModelUpdater;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSSelectorListImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleSheetImpl;
import org.eclipse.wst.css.core.internal.document.DOMCSSImpl;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.eventimpl.CSSEmbededStyleNotifyAdapter;
import org.eclipse.wst.css.core.internal.eventimpl.CSSStyleNotifyAdapter;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.css.core.internal.util.ImportRuleCollector;
import org.eclipse.wst.css.core.internal.util.ImportedCollector;
import org.eclipse.wst.css.core.internal.util.SelectorsCollector;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CSSModelImpl
extends AbstractStructuredModel
implements ICSSModel,
IStructuredDocumentListener {
    private CSSDocumentImpl document = null;
    private Node ownerNode = null;
    private CSSStyleNotifyAdapter styleNotifier = null;
    private CSSModelParser fParser = null;
    private CSSModelUpdater fUpdater = null;
    private boolean fStructuredDocumentUpdate = false;
    private static final String ID_NON_EXTERNAL_CSS = "**_NON_EXTERNAL_CSS_***";

    @Override
    public void addStyleListener(ICSSStyleListener listener) {
        this.getStyleNotifier().addStyleListener(listener);
    }

    void attrReplaced(CSSNodeImpl parentNode, CSSNodeImpl newAttr, CSSNodeImpl oldAttr) {
        int i;
        CSSSelectorListImpl list;
        CSSAttrImpl attr;
        if (!this.fStructuredDocumentUpdate) {
            CSSModelUpdater updater = this.getUpdater();
            updater.attrReplaced(parentNode, newAttr, oldAttr);
        }
        ICSSSelector[] removed = null;
        ICSSSelector[] added = null;
        if (oldAttr != null && oldAttr.getNodeType() == -1 && ((CSSAttrImpl)oldAttr).getName().equals("selector")) {
            attr = (CSSAttrImpl)oldAttr;
            list = new CSSSelectorListImpl(attr.getValue());
            removed = new ICSSSelector[list.getLength()];
            i = 0;
            while (i < list.getLength()) {
                removed[i] = list.getSelector(i);
                ++i;
            }
        }
        if (newAttr != null && newAttr.getNodeType() == -1 && ((CSSAttrImpl)newAttr).getName().equals("selector")) {
            attr = (CSSAttrImpl)newAttr;
            list = new CSSSelectorListImpl(attr.getValue());
            added = new ICSSSelector[list.getLength()];
            i = 0;
            while (i < list.getLength()) {
                added[i] = list.getSelector(i);
                ++i;
            }
        }
        if (removed != null || added != null || this.getDocument().getNodeType() == 8) {
            this.getStyleNotifier().fire(removed, added, null);
        }
        if (this.getStyleListeners() != null && this.getStyleListeners().size() > 0) {
            boolean update = false;
            if (oldAttr != null && oldAttr.getNodeType() == -1 && ((CSSAttrImpl)oldAttr).getName().equals("href")) {
                update = true;
            }
            if (newAttr != null && newAttr.getNodeType() == -1 && ((CSSAttrImpl)newAttr).getName().equals("href")) {
                update = true;
            }
            if (update) {
                ((ICSSImportRule)((Object)parentNode)).getStyleSheet();
            }
        }
    }

    public void beginRecording(Object requester, String label, String description) {
        IDOMModel model;
        this.getStyleNotifier().beginRecording();
        Node node = this.getOwnerDOMNode();
        if (node != null && node instanceof IDOMNode && (model = ((IDOMNode)node).getModel()) != null) {
            model.beginRecording(requester, label, description);
            return;
        }
        super.beginRecording(requester, label, description);
    }

    void childReplaced(CSSNodeImpl parentNode, CSSNodeImpl newChild, CSSNodeImpl oldChild) {
        int i;
        if (!this.fStructuredDocumentUpdate) {
            CSSModelUpdater updater = this.getUpdater();
            updater.childReplaced(parentNode, newChild, oldChild);
        }
        ICSSSelector[] removed = null;
        ICSSSelector[] added = null;
        if (parentNode.getNodeType() == 7 || parentNode.getNodeType() == 4) {
            SelectorsCollector selTrav = new SelectorsCollector();
            selTrav.apply(oldChild);
            int nSel = selTrav.getSelectors().size();
            if (nSel > 0) {
                removed = new ICSSSelector[nSel];
                i = 0;
                while (i < nSel) {
                    removed[i] = (ICSSSelector)selTrav.getSelectors().get(i);
                    ++i;
                }
            }
            selTrav = new SelectorsCollector();
            selTrav.apply(newChild);
            nSel = selTrav.getSelectors().size();
            if (nSel > 0) {
                added = new ICSSSelector[nSel];
                i = 0;
                while (i < nSel) {
                    added[i] = (ICSSSelector)selTrav.getSelectors().get(i);
                    ++i;
                }
            }
        } else {
            ICSSNode rule = parentNode;
            while (rule != null) {
                if (rule instanceof ICSSStyleRule) break;
                rule = rule.getParentNode();
            }
            if (rule != null) {
                ICSSSelectorList list = ((ICSSStyleRule)rule).getSelectors();
                added = new ICSSSelector[list.getLength()];
                i = 0;
                while (i < list.getLength()) {
                    added[i] = list.getSelector(i);
                    ++i;
                }
            }
        }
        if (removed != null || added != null || this.getDocument().getNodeType() == 8) {
            this.getStyleNotifier().fire(removed, added, null);
        }
        AbstractCssTraverser trav = new ImportRuleCollector();
        trav.apply(oldChild);
        Iterator it = ((ImportRuleCollector)trav).getRules().iterator();
        while (it.hasNext()) {
            ((CSSImportRuleImpl)it.next()).closeStyleSheet();
        }
        if (this.getStyleListeners() != null && this.getStyleListeners().size() > 0) {
            trav = new ImportedCollector();
            trav.apply(newChild);
        }
    }

    private void closeImported() {
        if (!this.isShared()) {
            if (this.getStyleListeners() != null) {
                Vector toRemove = new Vector(this.getStyleListeners());
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    this.removeStyleListener((ICSSStyleListener)it.next());
                }
            }
            ImportRuleCollector trav = new ImportRuleCollector();
            trav.apply(this.getDocument());
            Iterator it2 = trav.getRules().iterator();
            while (it2.hasNext()) {
                ((CSSImportRuleImpl)it2.next()).releaseRule();
            }
        }
    }

    private CSSDocumentImpl createDocument() {
        CSSDocumentImpl doc = null;
        int parserMode = 0;
        if (this.ownerNode == null) {
            doc = (CSSStyleSheetImpl)DOMCSSImpl.createCSSStyleSheet(null, null);
            parserMode = 0;
        } else if (this.ownerNode instanceof Element && ((Element)this.ownerNode).getTagName().toUpperCase().equals("STYLE")) {
            Element style = (Element)this.ownerNode;
            doc = (CSSStyleSheetImpl)DOMCSSImpl.createCSSStyleSheet(style.getAttribute("TITLE"), style.getAttribute("MEDIA"));
            parserMode = 0;
        } else if (this.ownerNode instanceof Element || this.ownerNode instanceof Attr) {
            doc = (CSSStyleDeclarationImpl)DOMCSSImpl.createCSSStyleDeclaration();
            parserMode = 1;
        }
        RegionParser regionParser = this.getStructuredDocument().getParser();
        if (regionParser instanceof CSSSourceParser) {
            ((CSSSourceParser)regionParser).setParserMode(parserMode);
        }
        return doc;
    }

    public void endRecording(Object requester) {
        IDOMModel model;
        Node node = this.getOwnerDOMNode();
        if (node != null && node instanceof IDOMNode && (model = ((IDOMNode)node).getModel()) != null) {
            model.endRecording(requester);
            return;
        }
        super.endRecording(requester);
        this.getStyleNotifier().endRecording();
    }

    @Override
    public ICSSDocument getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
            this.document.setModel(this);
        }
        return this.document;
    }

    public IStructuredDocument getStructuredDocument() {
        IStructuredDocument structuredDocument = null;
        structuredDocument = super.getStructuredDocument();
        if (structuredDocument != null) {
            return structuredDocument;
        }
        Assert.isNotNull((Object)this.getModelHandler());
        structuredDocument = (IStructuredDocument)this.getModelHandler().getDocumentLoader().createNewStructuredDocument();
        this.setStructuredDocument(structuredDocument);
        return structuredDocument;
    }

    public IndexedRegion getIndexedRegion(int offset) {
        if (this.getDocument() == null) {
            return null;
        }
        return ((CSSStructuredDocumentRegionContainer)((Object)this.getDocument())).getContainerNode(offset);
    }

    @Override
    public Node getOwnerDOMNode() {
        return this.ownerNode;
    }

    public void setOwnerDOMNode(Node node) {
        Assert.isTrue((this.ownerNode == null ? 1 : 0) != 0);
        this.ownerNode = node;
        if (this.ownerNode != null) {
            try {
                this.setId(ID_NON_EXTERNAL_CSS);
            }
            catch (ResourceInUse resourceInUse) {}
        }
    }

    protected CSSModelParser getParser() {
        if (this.fParser == null && this.getDocument() != null) {
            this.fParser = new CSSModelParser(this.document);
        }
        return this.fParser;
    }

    @Override
    public List getStyleListeners() {
        return this.getStyleNotifier().getStyleListeners();
    }

    @Override
    public Object getStyleSheetType() {
        if (this.getDocument() instanceof ICSSStyleDeclaration) {
            return "inlineCSS";
        }
        if (this.getOwnerDOMNode() != null) {
            return "embeddedCSS";
        }
        return "externalCSS";
    }

    private CSSStyleNotifyAdapter getStyleNotifier() {
        if (this.styleNotifier == null) {
            this.styleNotifier = this.ownerNode != null ? new CSSEmbededStyleNotifyAdapter(this) : new CSSStyleNotifyAdapter(this);
        }
        return this.styleNotifier;
    }

    private CSSModelUpdater getUpdater() {
        if (this.fUpdater == null) {
            this.fUpdater = new CSSModelUpdater(this);
            this.fUpdater.setParser(this.getParser());
        }
        return this.fUpdater;
    }

    @Override
    public boolean isRecording() {
        return this.getStyleNotifier().isRecording();
    }

    public boolean isShared() {
        return this.getStyleSheetType() == "externalCSS" && super.isShared();
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        IStructuredDocumentRegionList flatNodes;
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (structuredDocument != this.getStructuredDocument()) {
            this.setStructuredDocument(structuredDocument);
        }
        if ((flatNodes = structuredDocument.getRegionList()) == null) {
            return;
        }
        if (this.getDocument() == null) {
            return;
        }
        this.fStructuredDocumentUpdate = true;
        ((CSSStructuredDocumentRegionContainer)((Object)this.getDocument())).removeChildNodes();
        CSSModelParser parser = this.getParser();
        parser.setStructuredDocumentEvent((StructuredDocumentEvent)structuredDocumentEvent);
        parser.replaceStructuredDocumentRegions(flatNodes, null);
        this.fStructuredDocumentUpdate = false;
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocumentRegionList oldStructuredDocumentRegions = structuredDocumentEvent.getOldStructuredDocumentRegions();
        IStructuredDocumentRegionList newStructuredDocumentRegions = structuredDocumentEvent.getNewStructuredDocumentRegions();
        if (oldStructuredDocumentRegions == null && newStructuredDocumentRegions == null) {
            return;
        }
        this.fStructuredDocumentUpdate = true;
        CSSModelParser parser = this.getParser();
        parser.setStructuredDocumentEvent((StructuredDocumentEvent)structuredDocumentEvent);
        if (structuredDocumentEvent.isEntireDocumentReplaced()) {
            parser.replaceDocument(newStructuredDocumentRegions);
        } else {
            parser.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
        }
        this.fStructuredDocumentUpdate = false;
    }

    @Override
    public void refreshNodes() {
        this.fStructuredDocumentUpdate = true;
        ((CSSStructuredDocumentRegionContainer)((Object)this.getDocument())).removeChildNodes();
        this.fStructuredDocumentUpdate = false;
        this.getParser().cleanupUpdateContext();
        IStructuredDocument structuredDocument = this.getStructuredDocument();
        String source = structuredDocument.getText();
        structuredDocument.replaceText((Object)this, 0, source.length(), null);
        structuredDocument.replaceText((Object)this, 0, 0, source);
    }

    public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = structuredDocumentEvent.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegion region = structuredDocumentEvent.getRegion();
        if (region == null) {
            return;
        }
        this.fStructuredDocumentUpdate = true;
        CSSModelParser parser = this.getParser();
        parser.setStructuredDocumentEvent((StructuredDocumentEvent)structuredDocumentEvent);
        parser.changeRegion(flatNode, region);
        this.fStructuredDocumentUpdate = false;
    }

    public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = structuredDocumentEvent.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegionList oldRegions = structuredDocumentEvent.getOldRegions();
        ITextRegionList newRegions = structuredDocumentEvent.getNewRegions();
        if (oldRegions == null && newRegions == null) {
            return;
        }
        this.fStructuredDocumentUpdate = true;
        CSSModelParser parser = this.getParser();
        parser.setStructuredDocumentEvent((StructuredDocumentEvent)structuredDocumentEvent);
        parser.replaceRegions(flatNode, newRegions, oldRegions);
        this.fStructuredDocumentUpdate = false;
    }

    public void releaseFromEdit() {
        this.closeImported();
        if (this.getStyleSheetType() == "externalCSS") {
            super.releaseFromEdit();
        }
    }

    public void releaseFromRead() {
        this.closeImported();
        if (this.getStyleSheetType() == "externalCSS") {
            super.releaseFromRead();
        }
    }

    @Override
    public void removeStyleListener(ICSSStyleListener listener) {
        this.getStyleNotifier().removeStyleListener(listener);
    }

    public void setStructuredDocument(IStructuredDocument newStructuredDocument) {
        IStructuredDocument oldStructuredDocument = super.getStructuredDocument();
        if (newStructuredDocument == oldStructuredDocument) {
            return;
        }
        if (oldStructuredDocument != null) {
            oldStructuredDocument.removeDocumentChangingListener((IStructuredDocumentListener)this);
        }
        super.setStructuredDocument(newStructuredDocument);
        if (newStructuredDocument != null) {
            if (newStructuredDocument.getLength() > 0) {
                this.newModel(new NewDocumentEvent(newStructuredDocument, (Object)this));
            }
            newStructuredDocument.addDocumentChangingListener((IStructuredDocumentListener)this);
        }
    }

    @Override
    public void styleChanged(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        this.getStyleNotifier().styleChanged(srcModel, removed, added, media);
    }

    @Override
    public void styleUpdate(ICSSModel srcModel) {
        this.getStyleNotifier().styleUpdate(srcModel);
    }

    void valueChanged(CSSNodeImpl node, String oldValue) {
        if (!this.fStructuredDocumentUpdate) {
            CSSModelUpdater updater = this.getUpdater();
            updater.valueChanged(node, oldValue);
        }
        ICSSSelector[] removed = null;
        ICSSSelector[] added = null;
        if (node != null) {
            if (node.getNodeType() == -1 && ((CSSAttrImpl)node).getName().equals("selector")) {
                CSSAttrImpl attr = (CSSAttrImpl)node;
                CSSSelectorListImpl list = new CSSSelectorListImpl(attr.getValue());
                added = new ICSSSelector[list.getLength()];
                int i = 0;
                while (i < list.getLength()) {
                    added[i] = list.getSelector(i);
                    ++i;
                }
                list = new CSSSelectorListImpl(oldValue);
                removed = new ICSSSelector[list.getLength()];
                i = 0;
                while (i < list.getLength()) {
                    removed[i] = list.getSelector(i);
                    ++i;
                }
            } else if (node instanceof ICSSValue) {
                ICSSNode rule = node;
                while (rule != null) {
                    if (rule instanceof ICSSStyleRule) break;
                    rule = rule.getParentNode();
                }
                if (rule != null) {
                    ICSSSelectorList list = ((ICSSStyleRule)rule).getSelectors();
                    added = new ICSSSelector[list.getLength()];
                    int i = 0;
                    while (i < list.getLength()) {
                        added[i] = list.getSelector(i);
                        ++i;
                    }
                }
            }
        }
        if (removed != null || added != null || this.getDocument().getNodeType() == 8) {
            this.getStyleNotifier().fire(removed, added, null);
        }
        if (this.getStyleListeners() != null && this.getStyleListeners().size() > 0 && node != null && node.getNodeType() == -1 && ((CSSAttrImpl)node).getName().equals("href")) {
            ((ICSSImportRule)((ICSSAttr)((Object)node)).getOwnerCSSNode()).getStyleSheet();
        }
    }
}

