/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSID;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FnIDREF
extends Function {
    private static Collection _expected_args = null;

    public FnIDREF() {
        super(new QName("idref"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnIDREF.idref(args, ec);
    }

    public static ResultSequence idref(Collection args, EvaluationContext ec) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnIDREF.expected_args());
        ResultBuffer rs = new ResultBuffer();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idst = idrefRS.first().getStringValue().split(" ");
        ArrayList ids = FnIDREF.createIDs(idst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (ec.getContextItem() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(ec.getContextItem() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)ec.getContextItem();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnIDREF.hasID(ids, node)) {
            ElementType element = new ElementType((Element)node, ec.getStaticContext().getTypeModel());
            rs.add(element);
        }
        rs = FnIDREF.processAttributes(node, ids, rs, ec);
        rs = FnIDREF.processChildNodes(node, ids, rs, ec);
        return rs.getSequence();
    }

    private static ArrayList createIDs(String[] idtokens) {
        ArrayList<XSID> xsid = new ArrayList<XSID>();
        int i = 0;
        while (i < idtokens.length) {
            XSID id = new XSID(idtokens[i]);
            xsid.add(id);
            ++i;
        }
        return xsid;
    }

    private static ResultBuffer processChildNodes(Node node, List ids, ResultBuffer rs, EvaluationContext ec) {
        if (!node.hasChildNodes()) {
            return rs;
        }
        NodeList nodeList = node.getChildNodes();
        int nodecnt = 0;
        while (nodecnt < nodeList.getLength()) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() == 1 && !FnIDREF.isDuplicate(childNode, rs)) {
                ElementType element = new ElementType((Element)childNode, ec.getStaticContext().getTypeModel());
                if (element.isIDREF() && FnIDREF.hasID(ids, childNode)) {
                    rs.add(element);
                }
                rs = FnIDREF.processAttributes(childNode, ids, rs, ec);
                rs = FnIDREF.processChildNodes(childNode, ids, rs, ec);
            }
            ++nodecnt;
        }
        return rs;
    }

    private static ResultBuffer processAttributes(Node node, List idrefs, ResultBuffer rs, EvaluationContext ec) {
        if (!node.hasAttributes()) {
            return rs;
        }
        NamedNodeMap attributeList = node.getAttributes();
        int atsub = 0;
        while (atsub < attributeList.getLength()) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode, ec.getStaticContext().getTypeModel());
            if (((NodeType)atType).isID() && FnIDREF.hasID(idrefs, atNode) && !FnIDREF.isDuplicate(node, rs)) {
                ElementType element = new ElementType((Element)node, ec.getStaticContext().getTypeModel());
                rs.add(element);
            }
            ++atsub;
        }
        return rs;
    }

    private static boolean hasID(List ids, Node node) {
        int i = 0;
        while (i < ids.size()) {
            XSID idref = (XSID)ids.get(i);
            if (idref.getStringValue().equals(node.getNodeValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultBuffer rs) {
        ListIterator it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

