/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ElementSynchronizerImpl;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSynchronizer
extends ElementSynchronizerImpl {
    private static final String RETURN_PARAM_NAME = "return";
    private static final String HOLDER_CLASS_NAME = "Holder";
    private static final String HOLDER_CLASS_FQNAME = "javax.xml.ws.Holder";

    public ParameterSynchronizer(IModelElementSynchronizer parent) {
        super(parent);
    }

    public void synchronizeParameters(IWebMethod wm, IMethod method, IAnnotationInspector inspector) throws JavaModelException {
        LinkedList<IWebParam> mergedParams = new LinkedList<IWebParam>();
        if (!"V".equals(method.getReturnType())) {
            IWebParam retParam = this.obtainInstance(wm, RETURN_PARAM_NAME);
            this.mergeParam(retParam, 0, wm, method, method.getReturnType(), inspector);
            mergedParams.add(retParam);
        }
        String[] names = method.getParameterNames();
        String[] typeSignatures = method.getParameterTypes();
        int i = 0;
        while (i < names.length) {
            IWebParam param = this.obtainInstance(wm, names[i]);
            this.mergeParam(param, i, wm, method, typeSignatures[i], inspector);
            mergedParams.add(param);
            ++i;
        }
        wm.getParameters().retainAll(mergedParams);
    }

    private void mergeParam(IWebParam webParam, int pos, IWebMethod webMethod, IMethod method, String typeSign, IAnnotationInspector inspector) throws JavaModelException {
        String targetNamespace;
        String partName;
        String name;
        WebParamKind kind;
        IAnnotation wpAnnotation;
        ITypeParameter typeParam = method.getTypeParameter(webParam.getImplementation());
        assert (typeParam != null);
        IAnnotation iAnnotation = wpAnnotation = this.isWebResult(webParam) ? null : inspector.inspectParam(typeParam, "javax.jws.WebParam");
        if (!typeSign.equals(webParam.getTypeName())) {
            this.util().setFeatureValue(webParam, 3, typeSign);
        }
        WebParamKind webParamKind = kind = this.isWebResult(webParam) ? WebParamKind.OUT : this.calcKind((IAnnotation<ITypeParameter>)wpAnnotation, method, typeSign);
        if (!kind.equals((Object)webParam.getKind())) {
            webParam.setKind(kind);
        }
        boolean isHeader = this.calcHeader((IAnnotation<ITypeParameter>)wpAnnotation);
        if (webParam.isHeader() ^ isHeader) {
            webParam.setHeader(isHeader);
        }
        String string = name = this.isWebResult(webParam) ? this.defCalc().calcWebResultDefaultName(webMethod) : this.calcName((IAnnotation<ITypeParameter>)wpAnnotation, webMethod, pos);
        if (!name.equals(webParam.getName())) {
            webParam.setName(name);
        }
        if (!(partName = this.calcPartName((IAnnotation<ITypeParameter>)wpAnnotation, name)).equals(webParam.getPartName())) {
            webParam.setPartName(partName);
        }
        if (!(targetNamespace = this.calcTargetNamespace((IAnnotation<ITypeParameter>)wpAnnotation, webMethod, webParam)).equals(webParam.getTargetNamespace())) {
            webParam.setTargetNamespace(targetNamespace);
        }
        this.resource().getSerializerFactory().adapt((Notifier)webParam, IAnnotationSerializer.class);
        this.adaptToLocationInterface(webParam, "javax.jws.WebParam", (IAnnotation<? extends IJavaElement>)wpAnnotation);
    }

    private boolean isWebResult(IWebParam param) {
        return param.getImplementation().equals(RETURN_PARAM_NAME);
    }

    protected String resolveFullyQualifiedName(IMethod method, String typeSignature) throws JavaModelException, IllegalArgumentException {
        if (Signature.getTypeSignatureKind((String)typeSignature) == 2) {
            return Signature.toString((String)typeSignature);
        }
        String[][] resolvedTypes = method.getDeclaringType().resolveType(Signature.toString((String)typeSignature));
        if (resolvedTypes == null) {
            return "";
        }
        String pack = resolvedTypes[0][0];
        String className = resolvedTypes[0][1];
        if (pack != null && pack.length() != 0) {
            return String.valueOf(pack) + "." + className;
        }
        return className;
    }

    protected WebParamKind calcKind(IAnnotation<ITypeParameter> parmAnnotation, IMethod method, String typeSignature) throws JavaModelException, IllegalArgumentException {
        String typeFQName;
        if (parmAnnotation != null && parmAnnotation.getPropertyValue("mode") != null) {
            String mode = parmAnnotation.getPropertyValue("mode");
            if ("javax.jws.WebParam.Mode.INOUT".endsWith(mode)) {
                return WebParamKind.INOUT;
            }
            if ("javax.jws.WebParam.Mode.IN".endsWith(mode)) {
                return WebParamKind.IN;
            }
            if ("javax.jws.WebParam.Mode.OUT".endsWith(mode)) {
                return WebParamKind.OUT;
            }
        }
        if (this.isPossiblyHolderClass(typeSignature) && (typeFQName = this.resolveFullyQualifiedName(method, typeSignature)).startsWith(HOLDER_CLASS_FQNAME)) {
            return WebParamKind.INOUT;
        }
        return WebParamKind.IN;
    }

    private boolean isPossiblyHolderClass(String typeSignature) {
        String erasuteTypeName = Signature.getSignatureSimpleName((String)Signature.getTypeErasure((String)typeSignature));
        return HOLDER_CLASS_NAME.equals(erasuteTypeName);
    }

    private String calcName(IAnnotation<ITypeParameter> parmAnnotation, IWebMethod webMethod, int paramPosition) {
        if (parmAnnotation != null && parmAnnotation.getPropertyValue("name") != null) {
            return parmAnnotation.getPropertyValue("name");
        }
        return this.defCalc().calcWebParamDefaultName(webMethod, paramPosition);
    }

    private String calcPartName(IAnnotation<ITypeParameter> wpAnnotation, String name) {
        if (wpAnnotation != null && wpAnnotation.getPropertyValue("partName") != null) {
            return wpAnnotation.getPropertyValue("partName");
        }
        return name;
    }

    private boolean calcHeader(IAnnotation<ITypeParameter> wpAnnotation) {
        if (wpAnnotation != null && wpAnnotation.getPropertyValue("header") != null) {
            return Boolean.parseBoolean(wpAnnotation.getPropertyValue("header"));
        }
        return false;
    }

    private String calcTargetNamespace(IAnnotation<ITypeParameter> wpAnnotation, IWebMethod webMethod, IWebParam webParam) {
        if (wpAnnotation != null && wpAnnotation.getPropertyValue("targetNamespace") != null) {
            return wpAnnotation.getPropertyValue("targetNamespace");
        }
        return this.defCalc().calcWebParamDefaultTargetNS(webMethod, webParam);
    }

    private IWebParam obtainInstance(IWebMethod wm, String impl) {
        IWebParam existing = this.findWebParamByImplName(wm, impl);
        if (existing != null) {
            return existing;
        }
        IWebParam newParam = this.domFactory().createIWebParam();
        this.util().setFeatureValue(newParam, 0, impl);
        wm.getParameters().add((Object)newParam);
        return newParam;
    }

    private IWebParam findWebParamByImplName(IWebMethod wm, String impl) {
        for (IWebParam param : wm.getParameters()) {
            if (!impl.equals(param.getImplementation())) continue;
            return param;
        }
        return null;
    }
}

