/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ant;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import org.apache.tools.ant.Task;

public final class AntErrorManager
extends BasicErrorManager {
    private final MessageFormatter formatter;
    private final Task task;

    public AntErrorManager(MessageFormatter formatter, Task task) {
        this.formatter = formatter;
        this.task = task;
    }

    @Override
    public void println(CheckLevel level, JSError error) {
        switch (level) {
            case ERROR: {
                this.task.log(error.format(level, this.formatter), 0);
                break;
            }
            case WARNING: {
                this.task.log(error.format(level, this.formatter), 1);
                break;
            }
        }
    }

    @Override
    protected void printSummary() {
        String message = this.getErrorCount() + " error(s), " + this.getWarningCount() + " warning(s)";
        if (this.getTypedPercent() > 0.0) {
            message = message + ", " + this.getTypedPercent() + " typed";
        }
        int level = this.getErrorCount() + this.getWarningCount() == 0 ? 2 : 1;
        this.task.log(message, level);
    }
}

