/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.NamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;

public abstract class AbstractJavaNamedDiscriminatorColumn<PA extends NamedDiscriminatorColumn.ParentAdapter, A extends DiscriminatorColumnAnnotation>
extends AbstractJavaNamedColumn<PA, A>
implements SpecifiedNamedDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength;
    protected int defaultLength = 31;

    protected AbstractJavaNamedDiscriminatorColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractJavaNamedDiscriminatorColumn(PA parentAdapter, A columnAnnotation) {
        super(parentAdapter, columnAnnotation);
    }

    @Override
    protected void initialize(A columnAnnotation) {
        super.initialize(columnAnnotation);
        this.specifiedDiscriminatorType = this.buildSpecifiedDiscriminatorType(columnAnnotation);
        this.specifiedLength = this.buildSpecifiedLength(columnAnnotation);
    }

    @Override
    protected void synchronizeWithResourceModel(A columnAnnotation) {
        super.synchronizeWithResourceModel(columnAnnotation);
        this.setSpecifiedDiscriminatorType_(this.buildSpecifiedDiscriminatorType(columnAnnotation));
        this.setSpecifiedLength_(this.buildSpecifiedLength(columnAnnotation));
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    @Override
    public abstract A getColumnAnnotation();

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.specifiedDiscriminatorType != null ? this.specifiedDiscriminatorType : this.defaultDiscriminatorType;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType discriminatorType) {
        if (ObjectTools.notEquals((Object)((Object)this.specifiedDiscriminatorType), (Object)((Object)discriminatorType))) {
            this.getColumnAnnotation().setDiscriminatorType(DiscriminatorType.toJavaResourceModel(discriminatorType));
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedDiscriminatorType_(discriminatorType);
        }
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = discriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildSpecifiedDiscriminatorType(A columnAnnotation) {
        return DiscriminatorType.fromJavaResourceModel(columnAnnotation.getDiscriminatorType());
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return ((NamedDiscriminatorColumn.ParentAdapter)this.parentAdapter).getDefaultDiscriminatorType();
    }

    @Override
    public int getLength() {
        return this.specifiedLength != null ? this.specifiedLength : this.defaultLength;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer length) {
        if (ObjectTools.notEquals((Object)this.specifiedLength, (Object)length)) {
            this.getColumnAnnotation().setLength(length);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedLength_(length);
        }
    }

    protected void setSpecifiedLength_(Integer length) {
        Integer old = this.specifiedLength;
        this.specifiedLength = length;
        this.firePropertyChanged("specifiedLength", old, length);
    }

    protected Integer buildSpecifiedLength(A columnAnnotation) {
        return columnAnnotation.getLength();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int length) {
        int old = this.defaultLength;
        this.defaultLength = length;
        this.firePropertyChanged("defaultLength", old, length);
    }

    protected int buildDefaultLength() {
        return ((NamedDiscriminatorColumn.ParentAdapter)this.parentAdapter).getDefaultLength();
    }
}

