/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.jpql.spi.IJpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JavaConstructor;
import org.eclipse.jpt.jpa.core.jpql.spi.JavaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeRepository;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

public class JavaType
implements IJpaType {
    private Collection<IConstructor> constructors;
    private String[] enumConstants;
    private Class<?> type;
    private ITypeDeclaration typeDeclaration;
    private String typeName;
    private JpaTypeRepository typeRepository;

    public JavaType(JpaTypeRepository typeRepository, Class<?> type) {
        this.type = type;
        this.typeName = type.getName();
        this.typeRepository = typeRepository;
    }

    protected IConstructor buildConstructor(Constructor<?> constructor) {
        return new JavaConstructor(this, constructor);
    }

    protected Collection<IConstructor> buildConstructors() {
        Constructor<?>[] javaConstructors = this.type.getDeclaredConstructors();
        ArrayList<IConstructor> constructors = new ArrayList<IConstructor>(javaConstructors.length);
        Constructor<?>[] constructorArray = javaConstructors;
        int n = javaConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> javaConstructor = constructorArray[n2];
            constructors.add(this.buildConstructor(javaConstructor));
            ++n2;
        }
        return constructors;
    }

    protected String[] buildEnumConstants() {
        if (!this.type.isEnum()) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }
        ?[] enumConstants = this.type.getEnumConstants();
        String[] names = new String[enumConstants.length];
        int index = enumConstants.length;
        while (--index >= 0) {
            names[index] = ((Enum)enumConstants[index]).name();
        }
        return names;
    }

    public Iterable<IConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = this.buildConstructors();
        }
        return IterableTools.cloneSnapshot(this.constructors);
    }

    public boolean equals(IType type) {
        return this == type || this.typeName.equals(type.getName());
    }

    public boolean equals(Object object) {
        return this.equals((IType)object);
    }

    public String[] getEnumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = this.buildEnumConstants();
        }
        return this.enumConstants;
    }

    public String getName() {
        return this.typeName;
    }

    protected Class<?> getType() {
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = new JavaTypeDeclaration(this.typeRepository, this, null, this.type != null ? this.type.isArray() : false);
        }
        return this.typeDeclaration;
    }

    protected JpaTypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.type.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean isAssignableTo(IType otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        TypeHelper typeHelper = this.typeRepository.getTypeHelper();
        IType thisType = typeHelper.convertPrimitive((IType)this);
        if ((otherType = typeHelper.convertPrimitive(otherType)) instanceof JavaType) {
            Class<?> thisClass = ((JavaType)thisType).type;
            Class<?> otherClass = ((JavaType)otherType).type;
            return otherClass.isAssignableFrom(thisClass);
        }
        if (otherType instanceof JpaType) {
            org.eclipse.jdt.core.IType jdtType = this.typeRepository.findType(this.typeName);
            if (jdtType != null) {
                JpaType jpaType = new JpaType(this.typeRepository, jdtType);
                return jpaType.isAssignableTo(otherType);
            }
            return false;
        }
        return false;
    }

    public boolean isEnum() {
        return this.type != null && this.type.isEnum();
    }

    public boolean isResolvable() {
        return true;
    }

    @Override
    public void setTypeDeclaration(JpaTypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    public String toString() {
        return this.typeName;
    }
}

