/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.internal.ScriptBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ScriptHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeHandle;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class ScriptManager {
    private final Map<Long, ScriptImpl> idToScript = Collections.synchronizedMap(new HashMap());
    private final V8ContextFilter contextFilter;
    private final DebugSession debugSession;

    ScriptManager(V8ContextFilter contextFilter, DebugSession debugSession) {
        this.contextFilter = contextFilter;
        this.debugSession = debugSession;
    }

    public Script addScript(ScriptHandle scriptBody, List<SomeHandle> refs) {
        ScriptImpl theScript = this.addScriptImpl(scriptBody, refs);
        if (theScript != null) {
            this.debugSession.getSessionManager().getDebugEventListener().scriptLoaded(theScript);
        }
        return theScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ScriptImpl addScriptImpl(ScriptHandle scriptBody, List<SomeHandle> refs) {
        ScriptImpl theScript = this.findById(V8ProtocolUtil.getScriptIdFromResponse(scriptBody));
        ScriptManager scriptManager = this;
        synchronized (scriptManager) {
            if (theScript == null) {
                ScriptBase.Descriptor<Long> desc = ScriptManager.createDescriptor(scriptBody, refs, this.contextFilter);
                if (desc == null) {
                    return null;
                }
                theScript = new ScriptImpl(desc, this.debugSession);
                this.idToScript.put((Long)desc.id, theScript);
            }
            if (scriptBody.source() == null) return theScript;
            this.setSourceCode(scriptBody, theScript);
            return theScript;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptCollected(long scriptId) {
        ScriptImpl script;
        ScriptManager scriptManager = this;
        synchronized (scriptManager) {
            script = BasicUtil.removeSafe(this.idToScript, scriptId);
            if (script == null) {
                return;
            }
            script.setCollected();
        }
        this.debugSession.getDebugEventListener().scriptCollected(script);
    }

    private void setSourceCode(ScriptHandle body, ScriptImpl script) {
        String src = body.source();
        if (src == null) {
            return;
        }
        if (script != null) {
            script.setSource(src);
        }
    }

    public ScriptImpl findById(Long id) {
        return BasicUtil.getSafe(this.idToScript, id);
    }

    public boolean isAllSourcesLoaded() {
        final boolean[] result = new boolean[]{true};
        this.forEach(new Callback(){

            @Override
            public boolean process(Script script) {
                if (!script.hasSource()) {
                    result[0] = false;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    public Collection<Script> allScripts() {
        final HashSet<Script> result = new HashSet<Script>();
        this.forEach(new Callback(){

            @Override
            public boolean process(Script script) {
                result.add(script);
                return true;
            }
        });
        return result;
    }

    public synchronized void forEach(Callback callback) {
        for (Script script : this.idToScript.values()) {
            if (callback.process(script)) continue;
            return;
        }
    }

    public void reset() {
        this.idToScript.clear();
    }

    public V8ContextFilter getContextFilter() {
        return this.contextFilter;
    }

    private static ScriptBase.Descriptor<Long> createDescriptor(ScriptHandle script, List<SomeHandle> refs, V8ContextFilter contextFilter) {
        Script.Type type;
        String name;
        block5: {
            if ((script = V8ProtocolUtil.validScript(script, refs, contextFilter)) == null) {
                return null;
            }
            name = script.name();
            try {
                Long scriptType = script.scriptType();
                type = V8ProtocolUtil.getScriptType(scriptType);
                if (type != null) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        int lineOffset = (int)script.lineOffset();
        int columnOffset = (int)script.columnOffset();
        int lineCount = (int)script.lineCount();
        Long id = V8ProtocolUtil.getScriptIdFromResponse(script);
        if (id == null) {
            throw new RuntimeException("Null script id");
        }
        return new ScriptBase.Descriptor<Long>(type, id, name, lineOffset, columnOffset, lineCount);
    }

    public static Long convertAlienScriptId(Object scriptIdObj) {
        if (!(scriptIdObj instanceof Long)) {
            throw new IllegalStateException("Script id must be of type Long");
        }
        return (Long)scriptIdObj;
    }

    public static interface Callback {
        public boolean process(Script var1);
    }
}

