/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaPlatformFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.EclipseLinkSelectMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class EclipseLinkDynamicEntityClassWizardPage
extends DataModelWizardPage {
    protected Text packageText;
    protected Button packageButton;
    protected Label packageLabel;
    protected Text classText;
    protected Label classLabel;
    protected Label projectNameLabel;
    private Combo projectNameCombo;
    private String projectName;
    private Text entityNameText;
    private Label entityNameLabel;
    private Text tableNameText;
    private Button tableNameCheckButton;
    private Label ormXmlNameLabel;
    private Text ormXmlNameText;
    private Button browseButton;
    private static final Transformer<IJavaElement, String> JAVA_ELEMENT_NAME_TRANSFORMER = new JavaElementNameTransformer();

    public EclipseLinkDynamicEntityClassWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_DESC);
        this.setTitle(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TITLE);
        this.setPageComplete(false);
        this.projectName = null;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME", "IArtifactEditOperationDataModelProperties.COMPONENT_NAME", "NewJavaClassDataModel.JAVA_PACKAGE", "NewJavaClassDataModel.CLASS_NAME", "IEntityDataModelProperties.XML_NAME"};
    }

    private IProject getProject() {
        return (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.addProjectNameGroup(composite);
        this.addPackageGroup(composite);
        this.addClassNameGroup(composite);
        this.addEntityNameGroup(composite);
        this.addEntityTableGroup(composite);
        this.addMappingXMLGroup(composite);
        if (this.packageText.getText().trim().length() == 0) {
            this.packageText.setFocus();
        } else {
            this.classText.setFocus();
        }
        WorkbenchTools.setHelp((Control)composite, (String)EclipseLinkHelpContextIds.DYNAMIC_ENTITY_CLASS);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void addProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PROJECT_NAME_LABEL);
        GridData data = new GridData();
        this.projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(parent, 2056);
        data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                IProject project = ProjectUtilities.getProject((String)EclipseLinkDynamicEntityClassWizardPage.this.projectNameCombo.getText());
                EclipseLinkDynamicEntityClassWizardPage.this.validateProjectRequirements(project);
            }
        });
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
        new Label(parent, 0);
    }

    private void addPackageGroup(Composite composite) {
        this.packageLabel = new Label(composite, 16384);
        this.packageLabel.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_JAVA_PACKAGE_LABEL);
        this.packageLabel.setLayoutData((Object)new GridData(256));
        this.packageText = new Text(composite, 2052);
        this.packageText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.packageText, "NewJavaClassDataModel.JAVA_PACKAGE", null);
        IPackageFragment packageFragment = this.getSelectedPackageFragment();
        String targetProject = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (packageFragment != null && packageFragment.exists() && packageFragment.getJavaProject().getElementName().equals(targetProject)) {
            this.getPackageFragmentRoot(packageFragment);
            this.model.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)packageFragment.getElementName());
        }
        this.packageButton = new Button(composite, 8);
        this.packageButton.setText(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_BROWSE_BUTTON_LABEL);
        this.packageButton.setLayoutData((Object)new GridData(256));
        this.packageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EclipseLinkDynamicEntityClassWizardPage.this.handlePackageButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addClassNameGroup(Composite composite) {
        this.classLabel = new Label(composite, 16384);
        this.classLabel.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CLASS_NAME_LABEL);
        this.classLabel.setLayoutData((Object)new GridData(256));
        this.classText = new Text(composite, 2052);
        this.classText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.classText, "NewJavaClassDataModel.CLASS_NAME", null);
        new Label(composite, 16384);
    }

    private void addEntityNameGroup(Composite composite) {
        this.entityNameLabel = new Label(composite, 16384);
        this.entityNameLabel.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_ENTITY_NAME);
        this.entityNameLabel.setLayoutData((Object)new GridData(256));
        this.entityNameText = new Text(composite, 2052);
        this.entityNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.entityNameText, "IEntityDataModelProperties.ENTITY_NAME", null);
        new Label(composite, 16384);
    }

    private void addEntityTableGroup(Composite composite) {
        Group group = this.createGroup(composite, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TABLE_NAME_GROUP);
        this.tableNameCheckButton = this.createTableNameCheckButton((Composite)group, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_USE_DEFULT, "IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        this.tableNameText = this.createNameGroup((Composite)group, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TABLE_NAME, "IEntityDataModelProperties.TABLE_NAME");
        this.tableNameText.setEnabled(!this.tableNameCheckButton.getSelection());
    }

    private void addMappingXMLGroup(Composite parent) {
        Group group = this.createGroup(parent, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_GROUP);
        this.createBrowseGroup((Composite)group, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_NAME_LABEL, "IEntityDataModelProperties.XML_NAME");
        this.ormXmlNameText.setText("META-INF/eclipselink-orm.xml");
    }

    protected Text createNameGroup(Composite parent, String label, String property) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(label);
        nameLabel.setLayoutData((Object)new GridData(32));
        Text nameText = new Text(composite, 2052);
        nameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(nameText, property, null);
        return nameText;
    }

    private Button createTableNameCheckButton(Composite parent, String text, String property) {
        final Button button = new Button(parent, 32);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = button.getSelection();
                if (EclipseLinkDynamicEntityClassWizardPage.this.tableNameText != null) {
                    EclipseLinkDynamicEntityClassWizardPage.this.tableNameText.setEnabled(!isChecked);
                }
            }
        });
        this.synchHelper.synchCheckbox(button, property, null);
        return button;
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(text);
        return group;
    }

    private void createBrowseGroup(Composite parent, String label, String property) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.ormXmlNameLabel = new Label(composite, 16384);
        this.ormXmlNameLabel.setText(label);
        this.ormXmlNameLabel.setLayoutData((Object)new GridData(32));
        this.ormXmlNameText = new Text(composite, 2180);
        this.ormXmlNameText.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_BROWSE_BUTTON_LABEL);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)browseButtonData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EclipseLinkDynamicEntityClassWizardPage.this.handleChooseXmlButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.synchHelper.synchText(this.ormXmlNameText, property, null);
    }

    private void handleChooseXmlButtonPressed() {
        IFile initialSelection;
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        JpaProject jpaProject = this.getJpaProject(project);
        if (jpaProject == null) {
            return;
        }
        ViewerFilter filter = this.getDialogViewerFilter(jpaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        EclipseLinkSelectMappingFileDialog dialog = new EclipseLinkSelectMappingFileDialog(this.getShell(), project, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CHOOSE_XML_DIALOG_TITLE);
        dialog.setMessage(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CHOOSE_XML_DIALOG_MSG);
        dialog.addFilter(filter);
        dialog.setInput(project);
        String ormFileName = this.ormXmlNameText.getText();
        JptXmlResource resource = jpaProject.getMappingFileXmlResource((IPath)new Path(ormFileName));
        IFile iFile = initialSelection = resource != null ? resource.getFile() : null;
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            this.model.setProperty("IEntityDataModelProperties.XML_NAME", (Object)dialog.getChosenName());
            this.validatePage();
        }
    }

    protected ViewerFilter getDialogViewerFilter(JpaProject jpaProject) {
        return new XmlMappingFileViewerFilter(jpaProject, XmlEntityMappings.CONTENT_TYPE);
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected boolean isProjectValid(IProject project) {
        return project.isAccessible() && ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET) && ObjectTools.equals((Object)this.getJpaPlatformGroupId(project), (Object)"eclipselink") && this.projectIsEclipseLink2_1Compatible(project);
    }

    protected String getJpaPlatformGroupId(IProject project) {
        JpaPlatform.Config config = (JpaPlatform.Config)project.getAdapter(JpaPlatform.Config.class);
        return config == null ? null : config.getGroupConfig().getId();
    }

    private boolean projectIsEclipseLink2_1Compatible(IProject project) {
        JpaProject jpaProject = this.getJpaProject(project);
        if (jpaProject == null) {
            return false;
        }
        EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion jpaVersion = (EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion)jpaProject.getJpaPlatform().getJpaVersion();
        return jpaVersion.isCompatibleWithEclipseLinkVersion("2.1");
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = ProjectUtilities.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        if (selectedProject == null) {
            selectedProject = this.getSelectedProject();
        }
        if (selectedProject != null && selectedProject.isAccessible() && ProjectTools.hasNature((IProject)selectedProject, (String)"org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
            this.projectNameCombo.setText(selectedProject.getName());
            this.validateProjectRequirements(selectedProject);
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
        }
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.validateProjectRequirements(ProjectUtilities.getProject((String)this.projectName));
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
        }
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            return null;
        }
        if (packageFragment.getParent() instanceof IPackageFragment) {
            return this.getPackageFragmentRoot((IPackageFragment)packageFragment.getParent());
        }
        if (packageFragment.getParent() instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)packageFragment.getParent();
        }
        return null;
    }

    protected void handlePackageButtonPressed() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_TITLE);
        dialog.setMessage(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_DESC);
        dialog.setEmptyListMessage(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_MSG);
        dialog.setElements((Object[])this.getPackages());
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            if (fragment != null) {
                this.packageText.setText(fragment.getElementName());
            } else {
                this.packageText.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_EMPTY_STRING);
            }
        }
    }

    protected IJavaElement[] getPackages() {
        IPackageFragmentRoot[] packRoots = (IPackageFragmentRoot[])this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        if (packRoots.length <= 0) {
            return new IJavaElement[0];
        }
        IJavaElement[] packages = new IJavaElement[]{};
        try {
            ArrayList<IJavaElement> pkList = new ArrayList<IJavaElement>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = packRoots;
            int n = packRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                IJavaElement[] iJavaElementArray = packageRoot.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    if (!IterableTools.contains(this.getJavaElementNames(pkList), (Object)element.getElementName())) {
                        pkList.add(element);
                    }
                    ++n4;
                }
                ++n2;
            }
            packages = new IJavaElement[pkList.size()];
            pkList.toArray(packages);
        }
        catch (JavaModelException javaModelException) {}
        return packages;
    }

    private Iterable<String> getJavaElementNames(List<IJavaElement> elements) {
        return IterableTools.transform(elements, JAVA_ELEMENT_NAME_TRANSFORMER);
    }

    private IProject getSelectedProject() {
        TreePath path;
        IWorkbenchWindow window = WorkbenchTools.getActiveWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        IProject project = this.getExtendedSelectedProject(stucturedSelection.getFirstElement());
        if (project != null) {
            return project;
        }
        if (selection instanceof TreeSelection && ((TreeSelection)selection).getPaths().length > 0 && (path = ((TreeSelection)selection).getPaths()[0]).getSegmentCount() > 0 && path.getSegment(0) instanceof IProject) {
            return (IProject)path.getSegment(0);
        }
        return null;
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        return null;
    }

    private IPackageFragment getSelectedPackageFragment() {
        IWorkbenchWindow window = WorkbenchTools.getActiveWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 4) {
                return (IPackageFragment)element;
            }
            if (element.getElementType() == 5) {
                IJavaElement parent = ((ICompilationUnit)element).getParent();
                if (parent.getElementType() == 4) {
                    return (IPackageFragment)parent;
                }
            } else if (element.getElementType() == 7) {
                return ((IType)element).getPackageFragment();
            }
        }
        return null;
    }

    protected IJavaElement getInitialJavaElement(ISelection selection) {
        IResource resource;
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (jelem = this.getJavaElement(selectedElement = ((IStructuredSelection)selection).getFirstElement())) == null && (resource = this.getResource(selectedElement)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchWindow window = WorkbenchTools.getActiveWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPart part = window.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = window.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JptJpaEclipseLinkUiPlugin.instance().logError(e);
            }
        }
        return jelem;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected void validateProjectRequirements(IProject project) {
    }

    protected IJavaElement getJavaElement(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IJavaElement) {
            return (IJavaElement)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IJavaElement)((IAdaptable)obj).getAdapter(IJavaElement.class);
        }
        return (IJavaElement)Platform.getAdapterManager().getAdapter(obj, IJavaElement.class);
    }

    protected IResource getResource(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        }
        return (IResource)Platform.getAdapterManager().getAdapter(obj, IResource.class);
    }

    static class JavaElementNameTransformer
    extends TransformerAdapter<IJavaElement, String> {
        JavaElementNameTransformer() {
        }

        public String transform(IJavaElement element) {
            return element.getElementName();
        }
    }
}

