/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRangeHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.HTMLEditPartsFactory;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class EditModelQuery {
    private static Logger _log = PDPlugin.getLogger(EditModelQuery.class);
    private static EditModelQuery _instance;
    private static final int START_INDEX_BEFORE_TAG = 1;
    private static final int END_INDEX_WITHIN_TAG = 2;
    private static final HashSet SPECIAL_EMPTY_CHARS;
    public static final HashMap CHAR_NODE_MAP;
    private static final HashSet HTML_CONSTRAINED_CONTAINERS;
    public static final HashSet HTML_STYLE_NODES;
    static final HashSet UNREMOVEBLE_TAGS;

    static {
        SPECIAL_EMPTY_CHARS = new HashSet();
        CHAR_NODE_MAP = new HashMap();
        HTML_CONSTRAINED_CONTAINERS = new HashSet();
        HTML_STYLE_NODES = new HashSet();
        UNREMOVEBLE_TAGS = new HashSet();
        UNREMOVEBLE_TAGS.add("html");
        UNREMOVEBLE_TAGS.add("head");
        UNREMOVEBLE_TAGS.add("body");
        CHAR_NODE_MAP.put(new Character('\r'), "br");
        CHAR_NODE_MAP.put(new Character('\n'), "br");
        SPECIAL_EMPTY_CHARS.add(" ");
        SPECIAL_EMPTY_CHARS.add("\t");
        SPECIAL_EMPTY_CHARS.add("\r");
        SPECIAL_EMPTY_CHARS.add("\n");
        HTML_CONSTRAINED_CONTAINERS.add("td");
        HTML_CONSTRAINED_CONTAINERS.add("tr");
        HTML_CONSTRAINED_CONTAINERS.add("table");
        HTML_STYLE_NODES.add("b");
        HTML_STYLE_NODES.add("em");
        HTML_STYLE_NODES.add("h1");
        HTML_STYLE_NODES.add("h2");
        HTML_STYLE_NODES.add("h3");
        HTML_STYLE_NODES.add("h4");
        HTML_STYLE_NODES.add("h5");
        HTML_STYLE_NODES.add("h6");
        HTML_STYLE_NODES.add("a");
        HTML_STYLE_NODES.add("u");
        HTML_STYLE_NODES.add("i");
        HTML_STYLE_NODES.add("s");
        HTML_STYLE_NODES.add("strong");
        HTML_STYLE_NODES.add("tt");
        HTML_STYLE_NODES.add("big");
        HTML_STYLE_NODES.add("small");
        HTML_STYLE_NODES.add("font");
    }

    private EditModelQuery() {
    }

    public static EditModelQuery getInstance() {
        if (_instance == null) {
            _instance = new EditModelQuery();
        }
        return _instance;
    }

    /*
     * Unable to fully structure code
     */
    public Node getPreviousNeighbor(Node node) {
        if (EditValidateUtil.validNode(node)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl4:
            // 2 sources

            ** while (node != null && node.getNodeType() != 9 && node.getPreviousSibling() == null)
        }
lbl5:
        // 1 sources

        return node != null && node.getNodeType() != 9 ? node.getPreviousSibling() : null;
    }

    public Node getPreviousLeafNeighbor(Node node) {
        return this.getLastLeafChild(this.getPreviousNeighbor(node));
    }

    /*
     * Unable to fully structure code
     */
    public Node getNextNeighbor(Node node) {
        if (EditValidateUtil.validNode(node)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl4:
            // 2 sources

            ** while (node != null && node.getNodeType() != 9 && node.getNextSibling() == null)
        }
lbl5:
        // 1 sources

        return node != null && node.getNodeType() != 9 ? node.getNextSibling() : null;
    }

    public Node getNextLeafNeighbor(Node node) {
        return this.getFirstLeafChild(this.getNextNeighbor(node));
    }

    private Node getLastLeafChild(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getLastChild() != null) {
            return this.getLastLeafChild(node.getLastChild());
        }
        return node;
    }

    private Node getFirstLeafChild(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getFirstChild() != null) {
            return this.getFirstLeafChild(node.getFirstChild());
        }
        return node;
    }

    static boolean within(int start, int end, Node theNode) {
        return EditModelQuery.getNodeStartIndex(theNode) >= start && EditModelQuery.getNodeEndIndex(theNode) <= end;
    }

    boolean within(int start, int end, IDOMPosition position) {
        int pos = EditModelQuery.getIndexedRegionLocation(position);
        return start <= pos && pos <= end;
    }

    static boolean outOf(int start, int end, Node theNode) {
        if (EditModelQuery.getNodeLenth(theNode) > 0) {
            return EditModelQuery.getNodeStartIndex(theNode) >= end || EditModelQuery.getNodeEndIndex(theNode) <= start;
        }
        return EditModelQuery.getNodeStartIndex(theNode) < start || EditModelQuery.getNodeEndIndex(theNode) > end;
    }

    boolean atEdge(IDOMPosition position, boolean forward) {
        Node node = position.getContainerNode();
        int offset = position.getOffset();
        if (forward) {
            if (EditModelQuery.isText(node)) {
                return offset == node.getNodeValue().length();
            }
            return offset == node.getChildNodes().getLength();
        }
        return offset == 0;
    }

    Node getNeighbor(Node node, boolean forward) {
        if (forward) {
            return this.getNextNeighbor(node);
        }
        return this.getPreviousNeighbor(node);
    }

    /*
     * Unable to fully structure code
     */
    Node getPreviousNeighbor(Node node, Node root) {
        if (EditValidateUtil.validNode(node)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl4:
            // 2 sources

            ** while (node != null && node != root && node.getNodeType() != 9 && node.getPreviousSibling() == null)
        }
lbl5:
        // 1 sources

        return node != null && node != root && node.getNodeType() != 9 ? node.getPreviousSibling() : null;
    }

    /*
     * Unable to fully structure code
     */
    Node getNextNeighbor(Node node, Node root) {
        if (EditValidateUtil.validNode(node)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl4:
            // 2 sources

            ** while (node != null && node != root && node.getNodeType() != 9 && node.getNextSibling() == null)
        }
lbl5:
        // 1 sources

        return node != null && node != root && node.getNodeType() != 9 ? node.getNextSibling() : null;
    }

    Node getNeighbor(Node node, boolean forward, Node root) {
        Assert.isTrue((root != null ? 1 : 0) != 0);
        if (forward) {
            return this.getNextNeighbor(node, root);
        }
        return this.getPreviousNeighbor(node, root);
    }

    Node getLeafNeighbor(Node node, boolean forward) {
        if (node == null) {
            return null;
        }
        if (forward) {
            return this.getNextLeafNeighbor(node);
        }
        return this.getPreviousLeafNeighbor(node);
    }

    Node getLeafNeighbor(Node node, int childIndex, boolean forward) {
        if (node == null) {
            return null;
        }
        Node neighbor = this.getNeighbor(node, childIndex, forward);
        if (neighbor != null) {
            if (forward) {
                return this.getFirstLeafChild(neighbor);
            }
            return this.getLastLeafChild(neighbor);
        }
        return null;
    }

    Node getNeighbor(Node parent, int childIndex, boolean forward) {
        if (!EditValidateUtil.validNode(parent)) {
            return null;
        }
        NodeList nodeList = parent.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            if (nodeList.getLength() < childIndex) {
                return null;
            }
            Node childNode = null;
            if (!forward) {
                --childIndex;
            }
            if ((childNode = nodeList.item(childIndex)) != null) {
                return childNode;
            }
            return this.getNeighbor(parent, forward);
        }
        if (parent.getNodeType() == 3) {
            return this.getNeighbor(parent, forward);
        }
        return null;
    }

    static boolean isSame(IStructuredModel model, TextSelection textSelection) {
        if (model != null && textSelection != null) {
            int t1 = textSelection.getOffset();
            int t2 = textSelection.getLength() + t1;
            return model.getIndexedRegion(t1) == model.getIndexedRegion(t2);
        }
        return false;
    }

    static boolean isSame(IStructuredModel model, DesignRange range, TextSelection textSelection) {
        if (model != null && range != null && textSelection != null) {
            int t1 = textSelection.getOffset();
            int t2 = textSelection.getLength() + t1;
            int r1 = EditModelQuery.getIndexedRegionLocation(DOMRangeHelper.toDOMRange(range).getStartPosition());
            int r2 = EditModelQuery.getIndexedRegionLocation(DOMRangeHelper.toDOMRange(range).getEndPosition());
            return model.getIndexedRegion(t1) == model.getIndexedRegion(r1) && model.getIndexedRegion(t2) == model.getIndexedRegion(r2) || model.getIndexedRegion(t2) == model.getIndexedRegion(r1) && model.getIndexedRegion(t1) == model.getIndexedRegion(r2);
        }
        return false;
    }

    static boolean isSamePoint(TextSelection textSelection) {
        return textSelection.getLength() == 0;
    }

    public static boolean isSame(IDOMPosition p1, IDOMPosition p2) {
        return p1 == p2 || p1.getContainerNode() == p2.getContainerNode() && p1.getOffset() == p2.getOffset();
    }

    public static boolean isSame(DOMRange range) {
        EditValidateUtil.validRange(range);
        return EditModelQuery.isSame(range.getStartPosition(), range.getEndPosition());
    }

    public static boolean isSame(DesignRange range) {
        return EditModelQuery.isSame(range.getStartPosition(), range.getEndPosition());
    }

    public static boolean isSame(DesignPosition p1, DesignPosition p2) {
        if (p1 == p2) {
            return true;
        }
        return p1.getContainerNode() == p2.getContainerNode() && p1.getOffset() == p2.getOffset();
    }

    final boolean isWithinSameText(IDOMPosition p1, IDOMPosition p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.isText() && p2.isText() && p1.getContainerNode() == p2.getContainerNode();
    }

    public static int getIndexedRegionLocation(IDOMPosition p) {
        if (!EditValidateUtil.validPosition(p)) {
            return -1;
        }
        Node parent = p.getContainerNode();
        if (p.isText()) {
            return ((IndexedRegion)parent).getStartOffset() + p.getOffset();
        }
        int index = p.getOffset();
        if (!parent.hasChildNodes()) {
            if (!EditModelQuery.isDocument(parent)) {
                IStructuredDocumentRegion region = ((IDOMNode)parent).getStartStructuredDocumentRegion();
                return region.getEnd();
            }
            int offset = ((IndexedRegion)parent).getStartOffset();
            return offset;
        }
        NodeList children = parent.getChildNodes();
        if (children.getLength() == index) {
            if (!EditModelQuery.isDocument(parent)) {
                int pos = EditModelQuery.getNodeEndNameStartIndex(parent);
                return pos;
            }
            int offset = ((IndexedRegion)parent).getEndOffset();
            return offset;
        }
        Node node = children.item(index);
        return ((IndexedRegion)node).getStartOffset();
    }

    boolean isLinked(IDOMPosition nodePos, IDOMPosition position, boolean left) {
        int end;
        int index = EditModelQuery.getIndexedRegionLocation(position);
        if (left) {
            int pos = EditModelQuery.getIndexedRegionLocation(nodePos);
            return pos == index;
        }
        Node node = null;
        if (nodePos.isText()) {
            node = nodePos.getContainerNode();
            end = ((IndexedRegion)node).getEndOffset();
        } else {
            node = nodePos.getNextSiblingNode();
            Assert.isTrue((node != null ? 1 : 0) != 0);
            end = ((IndexedRegion)node).getEndOffset();
        }
        return end == index;
    }

    boolean isAtNodeNameEdge(int location, Node node, int posType) {
        int start = EditModelQuery.getNodeEndNameStartIndex(node);
        return location == start;
    }

    public boolean isAtNodeNameEdge(int location, Node node) {
        return this.isAtNodeNameEdge(location, node, 1) || this.isAtNodeNameEdge(location, node, 2);
    }

    public static boolean isTransparentText(Node node) {
        Assert.isTrue((node != null ? 1 : 0) != 0);
        if (node == null || !EditModelQuery.isText(node)) {
            return false;
        }
        if (!EditValidateUtil.validText(node)) {
            return false;
        }
        Text text = (Text)node;
        if (text.getLength() == 0) {
            return true;
        }
        String value = text.getNodeValue();
        int i = 0;
        while (i < value.length() && HTMLUtil.isHTMLWhitespace(value.charAt(i))) {
            ++i;
        }
        return i == value.length();
    }

    static int getNodeIndex(Node node) {
        EditValidateUtil.validNode(node);
        Node parent = node.getParentNode();
        int index = 0;
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child == node) {
                return index;
            }
            ++index;
            child = child.getNextSibling();
        }
        return -1;
    }

    public int getSameTypeNodeIndex(Node node) {
        EditValidateUtil.validNode(node);
        int i = 0;
        while (node != null) {
            Node sibling = node.getPreviousSibling();
            if (sibling != null && sibling.getLocalName() != null && sibling.getLocalName().equals(node.getLocalName())) {
                ++i;
            }
            node = sibling;
        }
        return i;
    }

    int getNextConcretePosition(String value, int position, boolean forward) {
        if (value == null) {
            return -1;
        }
        if (value.length() == 0) {
            return 0;
        }
        Assert.isTrue((position >= 0 && position <= value.length() ? 1 : 0) != 0);
        int i = -1;
        if (forward) {
            i = position;
            while (i < value.length() && (value.charAt(i) == '\r' || value.charAt(i) == '\n')) {
                ++i;
            }
            return i;
        }
        i = position - 1;
        while (i >= 0 && (value.charAt(i) == '\r' || value.charAt(i) == '\n')) {
            --i;
        }
        return i + 1;
    }

    public Node getCommonAncestor(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        Node na = node1;
        while (na != null) {
            Node ta = node2;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    public Node getCommonAncestor(IDOMPosition p1, IDOMPosition p2) {
        Node n1 = p1.getContainerNode();
        Node n2 = p2.getContainerNode();
        return this.getCommonAncestor(n1, n2);
    }

    /*
     * Unable to fully structure code
     */
    Node getBlockAncestor(Node node) {
        if (EditValidateUtil.validNode(node)) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            if (EditModelQuery.isBlockNode(node)) {
                return node;
            }
            node = node.getParentNode();
lbl6:
            // 2 sources

            ** while (node != null && EditModelQuery.isChild((String)"body", (Node)node, (boolean)true))
        }
lbl7:
        // 1 sources

        return null;
    }

    public static boolean isBlockNode(Node node) {
        return !EditModelQuery.isInline(node);
    }

    static boolean isTableCell(Node node) {
        INodeAdapter adapter;
        if (node instanceof INodeNotifier && (adapter = ((INodeNotifier)node).getAdapterFor(ICSSStyle.class)) != null) {
            ICSSStyle style = (ICSSStyle)adapter;
            String display = style.getDisplay();
            return display.equalsIgnoreCase("table-cell");
        }
        return false;
    }

    public static boolean isInline(Node refNode) {
        INodeAdapter adapter;
        Node node = refNode;
        EditPart part = Target.resolvePart(node);
        if (part instanceof ElementEditPart) {
            node = ((ElementEditPart)part).getTagConvert().getResultElement();
        }
        if (EditModelQuery.isText(node)) {
            return true;
        }
        if (node instanceof INodeNotifier && (adapter = ((INodeNotifier)node).getAdapterFor(ICSSStyle.class)) != null) {
            ICSSStyle style = (ICSSStyle)adapter;
            String display = style.getDisplay();
            return display.equalsIgnoreCase("inline") || display.equalsIgnoreCase("inline-table") || display.equalsIgnoreCase("compact") || display.equalsIgnoreCase("run-in");
        }
        return false;
    }

    public static boolean isListItem(Node node) {
        INodeAdapter adapter;
        if (node instanceof INodeNotifier && (adapter = ((INodeNotifier)node).getAdapterFor(ICSSStyle.class)) != null) {
            ICSSStyle style = (ICSSStyle)adapter;
            String display = style.getDisplay();
            return display.equalsIgnoreCase("list-item");
        }
        return false;
    }

    public static boolean isChild(String[] names, Node node, boolean ignoreCase, boolean noSame) {
        if (node == null) {
            return false;
        }
        if (noSame) {
            node = node.getParentNode();
        }
        List<String> namesAsList = Arrays.asList(names);
        while (node != null && !EditModelQuery.isDocument(node)) {
            Node oldNode;
            String nodeName = node.getLocalName();
            if (nodeName != null) {
                if (ignoreCase) {
                    nodeName = nodeName.toLowerCase();
                }
                if (namesAsList.contains(nodeName)) {
                    return true;
                }
            }
            if ((oldNode = node) != (node = node.getParentNode())) continue;
            throw new IllegalStateException("Infinite loop discovered in DOM tree");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isChild(String name, Node node, boolean ignoreCase) {
        if (node != null) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            nodeName = node.getLocalName();
            if (nodeName != null && (ignoreCase && name.equalsIgnoreCase(nodeName) || !ignoreCase && name.equalsIgnoreCase(nodeName))) {
                return true;
            }
            node = node.getParentNode();
lbl7:
            // 2 sources

            ** while (node != null && node.getNodeType() != 9)
        }
lbl8:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isChild(Node ancestor, Node node) {
        if (node == null || ancestor == null) {
            return false;
        }
        if (!EditModelQuery.isDocument(ancestor)) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            if (node == ancestor) {
                return true;
            }
            node = node.getParentNode();
lbl8:
            // 2 sources

            ** while (node != null && !EditModelQuery.isDocument((Node)ancestor))
        }
lbl9:
        // 1 sources

        return false;
    }

    Node getNextSibling(IDOMPosition position) {
        if (position.isText()) {
            return position.getContainerNode().getNextSibling();
        }
        return position.getNextSiblingNode();
    }

    Node getPreviousSibling(IDOMPosition position) {
        if (position.isText()) {
            return position.getContainerNode().getPreviousSibling();
        }
        return position.getPreviousSiblingNode();
    }

    Node getParent(IDOMPosition position) {
        if (position.isText()) {
            return position.getContainerNode().getParentNode();
        }
        return position.getContainerNode();
    }

    public Node getSibling(Node node, boolean forward) {
        EditValidateUtil.validNode(node);
        if (forward) {
            return node.getNextSibling();
        }
        return node.getPreviousSibling();
    }

    public Node getSibling(IDOMPosition position, boolean forward) {
        if (forward) {
            return this.getNextSibling(position);
        }
        return this.getPreviousSibling(position);
    }

    int getSize(IDOMPosition position) {
        EditValidateUtil.validPosition(position);
        if (position.isText()) {
            return ((Text)position.getContainerNode()).getLength();
        }
        if (position.getContainerNode().hasChildNodes()) {
            return position.getContainerNode().getChildNodes().getLength();
        }
        return 0;
    }

    public Text getText(IDOMPosition position) {
        if (position.isText() && position.getContainerNode() != null) {
            return (Text)position.getContainerNode();
        }
        return null;
    }

    public static Document getDocumentNode(Node node) {
        if (node != null) {
            return EditModelQuery.isDocument(node) ? (Document)node : node.getOwnerDocument();
        }
        return null;
    }

    static boolean isEmptyNode(Node node) {
        if (node.getNodeType() == 3) {
            return EditModelQuery.isTransparentText(node);
        }
        return node.getChildNodes() == null || node.getChildNodes().getLength() == 0;
    }

    public static boolean isText(Node node) {
        return node != null && node.getNodeType() == 3;
    }

    public static boolean isDocument(Node node) {
        return node != null && node.getNodeType() == 9;
    }

    void assignFather(Vector children, Node firstF) {
        if (children.size() == 0) {
            return;
        }
        if (firstF != null && !EditModelQuery.isDocument(firstF)) {
            String name = firstF.getNodeName();
            if (name != null && HTML_STYLE_NODES.contains(name.toLowerCase())) {
                Node newParent = firstF.cloneNode(false);
                while (children.size() > 0) {
                    newParent.appendChild((Node)children.remove(0));
                }
                children.add(newParent);
            }
            this.assignFather(children, firstF.getParentNode());
        }
    }

    IndexedRegion getPosNode(IStructuredModel model, int pos) {
        IndexedRegion inode = model.getIndexedRegion(pos);
        return inode;
    }

    boolean isAtRightMostWithin(Node node, int pos) {
        return EditModelQuery.getNodeEndNameStartIndex(node) == pos;
    }

    IDOMPosition createDomposition(Node container, Node refNode, boolean forward) {
        if (refNode == null) {
            if (forward && container.hasChildNodes()) {
                return new DOMPosition(container, container.getChildNodes().getLength());
            }
            return new DOMPosition(container, 0);
        }
        Assert.isTrue((refNode.getParentNode() == container ? 1 : 0) != 0);
        int index = EditModelQuery.getNodeIndex(refNode);
        if (!forward) {
            ++index;
        }
        return new DOMPosition(container, index);
    }

    static DesignRange convertToDesignRange(IStructuredModel fModel, TextSelection textSelection) {
        int start = textSelection.getOffset();
        int end = textSelection.getLength() + start;
        IDOMPosition startDomPos = EditModelQuery.getInstance().createDomposition((IDOMModel)fModel, start, false);
        IDOMPosition endDomPos = EditModelQuery.getInstance().createDomposition((IDOMModel)fModel, end, false);
        if (startDomPos == null) {
            startDomPos = endDomPos;
        } else if (endDomPos == null) {
            endDomPos = startDomPos;
        }
        if (startDomPos != null) {
            DesignPosition startPos = null;
            DesignPosition endPos = null;
            startPos = DOMPositionHelper.toDesignPosition(startDomPos);
            endPos = DOMPositionHelper.toDesignPosition(endDomPos);
            if (startPos != null) {
                return new DesignRange(startPos, endPos);
            }
        }
        return null;
    }

    public IDOMPosition createDomposition(IDOMModel model, int position, boolean adjust) {
        return this.createDomposition1(model, position, adjust);
    }

    public IDOMPosition createDomposition1(IDOMModel model, int position, boolean adjust) {
        try {
            IndexedRegion object = this.getPosNode((IStructuredModel)model, position);
            if (object == null && position > 0) {
                object = this.getPosNode((IStructuredModel)model, position - 1);
            }
            Node container = null;
            if (object == null) {
                return new DOMPosition((Node)model.getDocument(), 0);
            }
            container = (Node)object;
            IndexedRegion oppNode = this.getPosNode((IStructuredModel)model, position - 1);
            if (oppNode != null && !EditModelQuery.isChild((Node)oppNode, container) && !EditModelQuery.isInline(container) && EditModelQuery.isInline((Node)oppNode)) {
                container = (Node)oppNode;
            }
            int location = EditHelper.getInstance().getLocation(container, position, false);
            IDOMPosition result = null;
            switch (location) {
                case 1: 
                case 2: {
                    result = new DOMRefPosition(container, false);
                    break;
                }
                case 4: 
                case 5: {
                    result = new DOMRefPosition(container, true);
                    break;
                }
                case 3: {
                    result = EditModelQuery.isText(container) ? new DOMPosition(container, position - EditModelQuery.getNodeStartIndex(container)) : new DOMPosition(container, container.getChildNodes().getLength());
                }
            }
            return result;
        }
        catch (Exception e) {
            _log.error("Error.EditModelQuery.0" + e);
            return null;
        }
    }

    public static int getNodeLenth(Node node) {
        if (node != null && EditValidateUtil.validNode(node)) {
            return ((IndexedRegion)node).getEndOffset() - ((IndexedRegion)node).getStartOffset();
        }
        return 0;
    }

    public static int getNodeStartIndex(Node node) {
        if (EditValidateUtil.validNode(node) && node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getStartOffset();
        }
        return -1;
    }

    public static int getNodeEndIndex(Node node) {
        if (EditValidateUtil.validNode(node) && node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getEndOffset();
        }
        return -1;
    }

    static Node getNodeAt(IStructuredModel model, int position) {
        try {
            IndexedRegion region = model.getIndexedRegion(position);
            if (region instanceof Node) {
                return (Node)region;
            }
            return null;
        }
        catch (Exception e) {
            _log.error("Error.EditModelQuery.1", (Throwable)e);
            return null;
        }
    }

    public static int getNodeStartNameEndIndex(Node node) {
        IStructuredDocumentRegion region;
        if (EditModelQuery.isText(node)) {
            return EditModelQuery.getNodeStartIndex(node);
        }
        if (EditValidateUtil.validNode(node) && node instanceof IDOMNode && (region = ((IDOMNode)node).getStartStructuredDocumentRegion()) != null) {
            return region.getEndOffset();
        }
        return EditModelQuery.getNodeStartIndex(node);
    }

    public static int getNodeEndNameStartIndex(Node node) {
        IStructuredDocumentRegion region;
        if (EditModelQuery.isText(node)) {
            return EditModelQuery.getNodeEndIndex(node);
        }
        if (EditValidateUtil.validNode(node) && node instanceof IDOMNode && (region = ((IDOMNode)node).getEndStructuredDocumentRegion()) != null) {
            return region.getStartOffset();
        }
        return EditModelQuery.getNodeEndIndex(node);
    }

    public boolean isSingleRegionNode(Node node) {
        return EditModelQuery.getNodeEndNameStartIndex(node) == EditModelQuery.getNodeEndIndex(node) && !node.hasChildNodes();
    }

    boolean hasNonTransparentChild(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (EditModelQuery.isText(child)) {
                if (!EditModelQuery.isTransparentText(child)) {
                    return true;
                }
            } else {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasNonTransparentChild(Node node, String[] excludes) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (EditModelQuery.isText(child) ? !EditModelQuery.isTransparentText(child) : !Arrays.asList(excludes).contains(child.getLocalName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasWhitespaceNeighbor(Node node) {
        if (EditModelQuery.isWidget(node = this.getNeighbor(node, true))) {
            return false;
        }
        node = this.getFirstLeafChild(node);
        return EditModelQuery.isTransparentText(node);
    }

    public static boolean isWidget(Object host) {
        boolean result = false;
        EditPart part = null;
        if (host instanceof EditPart) {
            part = (EditPart)host;
        } else if (host instanceof Node && (part = Target.resolvePart((Node)host)) == null) {
            part = new HTMLEditPartsFactory((IDOMDocument)EditModelQuery.getDocumentNode((Node)host)).createEditPart(null, host);
        }
        if (part instanceof NodeEditPart) {
            result = ((NodeEditPart)part).isWidget();
        }
        return result;
    }

    boolean isRedundantWightspaces(Node node) {
        return EditModelQuery.isTransparentText(node) && this.hasWhitespaceNeighbor(node);
    }

    public static boolean hasAncestor(Node node, String[] names, boolean ignoreCase) {
        Assert.isTrue((names != null ? 1 : 0) != 0);
        while (node != null && !EditModelQuery.isDocument(node)) {
            if (EditModelQuery.isElement(node) && EditModelQuery.containItem(names, node, ignoreCase)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static boolean hasAncestor(Node node, String name, boolean ignoreCase) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        while (node != null && !EditModelQuery.isDocument(node)) {
            if (node.getNodeName() != null && (ignoreCase && name.equalsIgnoreCase(node.getNodeName()) || !ignoreCase && name.equals(node.getNodeName()))) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static List getAncestors(Node node, String top, boolean ignoreCase) {
        ArrayList<Node> result = new ArrayList<Node>();
        Assert.isTrue((node != null ? 1 : 0) != 0);
        while (node != null && !EditModelQuery.isDocument(node)) {
            result.add(node);
            String name = node.getLocalName();
            if (ignoreCase && top.equalsIgnoreCase(name) || !ignoreCase && top.equals(name)) break;
            node = node.getParentNode();
        }
        return result;
    }

    public static void copyChildren(Node old, Node newNode) {
        Node child = old.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            child = old.removeChild(child);
            if (old.getParentNode() == newNode) {
                newNode.insertBefore(child, old);
            } else {
                newNode.appendChild(child);
            }
            child = next;
        }
    }

    private static boolean isElement(Node node) {
        return node.getNodeType() == 1;
    }

    public static Node getChild(Node ancestor, String[] childrenNames, int maxLevelToSearch, boolean ignoreCase) {
        if (ancestor == null || maxLevelToSearch < 0) {
            return null;
        }
        if (ancestor.getLocalName() != null && ignoreCase && Arrays.asList(childrenNames).contains(ancestor.getLocalName().toLowerCase()) || !ignoreCase && Arrays.asList(childrenNames).contains(ancestor.getLocalName())) {
            return ancestor;
        }
        NodeList children = ancestor.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node result = EditModelQuery.getChild(children.item(i), childrenNames, maxLevelToSearch - 1, ignoreCase);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    static Node getChildDeferredNode(Node ancestor, String[] childrenNames, int maxLevelToSearch, boolean ignoreCase) {
        if (ancestor == null || maxLevelToSearch < 0) {
            return null;
        }
        String nodeName = ancestor.getNodeName();
        if (nodeName != null && ignoreCase && Arrays.asList(childrenNames).contains(nodeName) || !ignoreCase && Arrays.asList(childrenNames).contains(nodeName)) {
            return ancestor;
        }
        NodeList children = ancestor.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node result = EditModelQuery.getChildDeferredNode(children.item(i), childrenNames, maxLevelToSearch - 1, ignoreCase);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasTransparentNodeOnly(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            if (!EditModelQuery.isTransparentText(children.item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static Node getParent(String name, Node node, boolean ignoreCase) {
        if (node != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            nodeName = node.getLocalName();
            if (nodeName != null && (ignoreCase && name.equalsIgnoreCase(nodeName) || !ignoreCase && name.equalsIgnoreCase(nodeName))) {
                return node;
            }
            node = node.getParentNode();
lbl7:
            // 2 sources

            ** while (node != null && node.getNodeType() != 9)
        }
lbl8:
        // 1 sources

        return null;
    }

    public static void getElementByLocalName(Node rootNode, String localName, boolean caseSensitive, List list) {
        if (list == null) {
            return;
        }
        NodeList nodeList = rootNode.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            int size = nodeList.getLength();
            while (i < size) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    String nodeLocalName = node.getLocalName();
                    if (caseSensitive && localName.equals(nodeLocalName)) {
                        list.add(node);
                    } else if (!caseSensitive && localName.equalsIgnoreCase(nodeLocalName)) {
                        list.add(node);
                    }
                    EditModelQuery.getElementByLocalName(node, localName, true, list);
                }
                ++i;
            }
        }
    }

    public static boolean containItem(String[] tags, Node node, boolean ignoreCase) {
        if (ignoreCase) {
            int i = 0;
            int size = tags.length;
            while (i < size) {
                if (tags[i] != null && tags[i].equalsIgnoreCase(node.getNodeName())) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            int size = tags.length;
            while (i < size) {
                if (tags[i] != null && tags[i].equals(node.getNodeName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

