/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.elementedit.util;

import java.util.List;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;

public class PanelGridUtil {
    private static final int INVALID_POSITION = -10;
    private Element _panelGrid = null;

    public PanelGridUtil(Element panelGrid) {
        this._panelGrid = panelGrid;
    }

    public int convertRowIndexFromDomToView(int domIndex) {
        boolean hasFooterRow;
        boolean hasHeaderRow = JSFDOMUtil.findFacet(this._panelGrid, "header") != null;
        boolean bl = hasFooterRow = JSFDOMUtil.findFacet(this._panelGrid, "footer") != null;
        if (!hasFooterRow) {
            return domIndex;
        }
        if (domIndex == 0) {
            return domIndex;
        }
        if (hasHeaderRow ? domIndex > 1 : domIndex > 0) {
            return domIndex - 1;
        }
        int uiRows = this.getUIRowCount();
        return domIndex + uiRows;
    }

    public int getDomRowIndex(Element cell) {
        int columns;
        boolean hasHeaderRow = JSFDOMUtil.findFacet(this._panelGrid, "header") != null;
        boolean hasFooterRow = JSFDOMUtil.findFacet(this._panelGrid, "footer") != null;
        boolean isFacet = JSFDOMUtil.isFacet(cell);
        Element parent = (Element)cell.getParentNode();
        boolean isParentFacet = JSFDOMUtil.isFacet(parent);
        if (isParentFacet) {
            cell = parent;
        }
        if (isFacet || isParentFacet) {
            String attrName = cell.getAttribute("name");
            if ("header".equalsIgnoreCase(attrName)) {
                return 0;
            }
            if ("footer".equalsIgnoreCase(attrName)) {
                if (hasHeaderRow) {
                    return 1;
                }
                return 0;
            }
        }
        if ((columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGrid, (String)"columns", (int)1)) < 1) {
            columns = 1;
        }
        int pos = this.getPosition(cell);
        int rowIndex = pos / columns;
        if (hasHeaderRow) {
            ++rowIndex;
        }
        if (hasFooterRow) {
            ++rowIndex;
        }
        return rowIndex;
    }

    public int getDomColumnIndex(Element cell) {
        int pos;
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGrid, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        if ((pos = this.getPosition(cell)) == -10) {
            return pos;
        }
        int columnIndex = pos % columns;
        return columnIndex;
    }

    public int getUIRowCount() {
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGrid, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGrid);
        int numRows = (children.size() + columns - 1) / columns;
        return numRows;
    }

    private int getPosition(Element cell) {
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGrid);
        int size = children.size();
        int i = 0;
        i = 0;
        while (i < size) {
            if (cell == children.get(i)) break;
            ++i;
        }
        if (i == size) {
            return -10;
        }
        return i;
    }
}

