/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jst.jsf.common.internal.ITestTracker;
import org.eclipse.jst.jsf.common.internal.resource.AbstractLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleListener
extends AbstractLifecycleListener<ResourceLifecycleEvent, IResourceLifecycleListener, IResource>
implements IResourceChangeListener {
    private static boolean ENABLE_TEST_TRACKING = false;
    private static long _seqId;
    private ITestTracker _testTracker;
    final IWorkspace _workspace;

    public LifecycleListener(IWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this._workspace = workspace;
    }

    public LifecycleListener(IResource res, IWorkspace workspace) {
        this(workspace);
        if (res == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this.addResource(res);
    }

    public LifecycleListener(List<IResource> resources, IWorkspace workspace) {
        this(workspace);
        for (IResource resource : resources) {
            if (resource != null) {
                this.addResource(resource);
                continue;
            }
            throw new NullPointerException("Cannot add null object");
        }
    }

    @Override
    protected void addSystemChangeListener() {
        this._workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    protected void removeSystemChangeListener() {
        this._workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public final void setTestTracker(ITestTracker testTracker) {
        this._testTracker = testTracker;
    }

    protected final void setEnableTracing(boolean newValue) {
        ENABLE_TEST_TRACKING = newValue;
    }

    public void addResource(IResource res) {
        this.addLifecycleObject(res);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        long seqId = _seqId++;
        if (this._testTracker != null && ENABLE_TEST_TRACKING) {
            this._testTracker.fireEvent(ITestTracker.Event.START_TRACKING, seqId, "trackMethod_resourceChanged");
        }
        assert (!this.isDisposed());
        switch (event.getType()) {
            case 2: {
                IProject proj = (IProject)event.getResource();
                for (IResource res : this.getLifecycleObjects()) {
                    if (proj != res && proj != res.getProject()) continue;
                    this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED));
                }
                break;
            }
            case 4: {
                IProject proj = (IProject)event.getResource();
                for (IResource res : this.getLifecycleObjects()) {
                    if (proj == res) {
                        this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
                        continue;
                    }
                    if (proj != res.getProject()) continue;
                    this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED));
                }
                break;
            }
            case 1: {
                for (IResource res : this.getLifecycleObjects()) {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null || (delta = delta.findMember(res.getFullPath())) == null) continue;
                    this.visit(delta);
                }
                break;
            }
        }
        if (ENABLE_TEST_TRACKING && this._testTracker != null) {
            this._testTracker.fireEvent(ITestTracker.Event.STOP_TRACKING, seqId, "trackMethod_resourceChanged");
        }
    }

    private void visit(IResourceDelta delta) {
        assert (!this.isDisposed());
        IResource res = delta.getResource();
        if (res.getType() == 8) {
            this.handleWorkspaceRoot(delta);
        } else if (res instanceof IContainer) {
            this.handleContainer(delta, res);
        } else {
            this.handleFile(delta, res);
        }
    }

    private void handleContainer(IResourceDelta delta, IResource container) {
        this.handleChange(delta, container, container);
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            if (childDelta.getResource().getType() == 1 || childDelta.getResource().getType() == 2) {
                this.handleChange(childDelta, childDelta.getResource(), container);
            }
            ++n2;
        }
    }

    private void handleFile(IResourceDelta delta, IResource res) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                this.handleChange(delta, res, res);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 0x100) == 0) break;
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS));
            }
        }
    }

    private void handleChange(IResourceDelta delta, IResource res, IResource interestedResource) {
        switch (delta.getKind()) {
            case 1: {
                this.handleAdd(delta, res, interestedResource);
                break;
            }
            case 2: {
                this.handleRemove(delta, res, interestedResource);
            }
        }
    }

    private void handleRemove(IResourceDelta delta, IResource res, IResource interestedResource) {
        if ((delta.getFlags() & 0x2000) != 0) {
            if (res.equals((Object)interestedResource)) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED));
            } else if (res.getParent().equals((Object)interestedResource)) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
            }
        } else if (res.equals((Object)interestedResource)) {
            this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
        } else if (res.getParent().equals((Object)interestedResource)) {
            this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED_FROM_CONTAINER));
        }
    }

    private void handleAdd(IResourceDelta delta, IResource res, IResource interestedResource) {
        if ((delta.getFlags() & 0x1000) != 0) {
            if (res.equals((Object)interestedResource)) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED));
            } else if (res.getParent().equals((Object)interestedResource)) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
            }
        } else if (res.equals((Object)interestedResource)) {
            this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED));
        } else if (res.getParent().equals((Object)interestedResource)) {
            this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER));
        }
    }

    private void handleWorkspaceRoot(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(5);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            IResource res = childDelta.getResource();
            if ((childDelta.getFlags() & 0x4000) != 0 && res.getType() == 4) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(this, res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.PROJECT_OPENED));
            }
            ++n2;
        }
    }
}

